/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.sdi.utils.ScopeUtils;
import org.gcube.usecases.ws.thredds.TokenSetter;
import org.gcube.usecases.ws.thredds.engine.impl.CustomAuthorizationFilter;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.faults.UnableToLockException;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsController {
    private static final Logger log = LoggerFactory.getLogger(ThreddsController.class);
    static Configuration JSON_PATH_ALWAYS_LIST_CONFIG = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS, Option.DEFAULT_PATH_LEAF_TO_NULL}).build();
    private String hostname;
    private String operatingPath;
    private String targetToken;
    private String callerToken = null;

    public ThreddsController(String path, String targetToken) throws InternalException {
        this.operatingPath = path;
        this.targetToken = targetToken;
        this.hostname = this.getThreddsHost();
        if (this.hostname == null) {
            throw new InternalException("Invalid hostnam in context " + ScopeUtils.getCurrentScope());
        }
    }

    private static final String truncate(String toTruncate) {
        return toTruncate == null ? toTruncate : toTruncate.substring(0, toTruncate.length() / 2) + "...";
    }

    private void setTargetToken() {
        if (this.callerToken == null) {
            this.callerToken = TokenSetter.getCurrentToken();
            log.trace("Storing caller token {}. Target Token is {}", (Object)ThreddsController.truncate(this.callerToken), (Object)ThreddsController.truncate(this.targetToken));
            TokenSetter.setToken(this.targetToken);
        } else {
            log.trace("Caller token {} already registered. Target Token is {}", (Object)ThreddsController.truncate(this.callerToken), (Object)ThreddsController.truncate(this.targetToken));
        }
    }

    private void resetCallerToken() {
        if (this.callerToken != null) {
            log.trace(String.format("Resetting caller token %1$s. Target Token is %2$s, current is %3$s ", ThreddsController.truncate(this.callerToken), ThreddsController.truncate(this.targetToken), ThreddsController.truncate(TokenSetter.getCurrentToken())));
            TokenSetter.setToken(this.callerToken);
            this.callerToken = null;
        } else {
            log.trace(String.format("Caller token %1$s already reset [current token %2$s]. Target Token is %3$s", ThreddsController.truncate(this.callerToken), ThreddsController.truncate(TokenSetter.getCurrentToken()), ThreddsController.truncate(this.targetToken)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ThreddsInfo getThreddsInfo() {
        this.setTargetToken();
        try {
            String infoPath = "https://" + this.hostname + "/data-transfer-service/gcube/service/Capabilities/pluginInfo/REGISTER_CATALOG";
            log.info("Loading thredds info from {} ", (Object)infoPath);
            WebTarget target = ThreddsController.getWebClient().target(infoPath);
            ThreddsInfo threddsInfo = (ThreddsInfo)target.request(new String[]{"application/json"}).get(ThreddsInfo.class);
            return threddsInfo;
        }
        finally {
            this.resetCallerToken();
        }
    }

    public void lockFolder(String processId) throws UnableToLockException {
        File temp;
        block11: {
            this.setTargetToken();
            PrintWriter writer = null;
            temp = null;
            try {
                log.info("Locking remote path {} to processId {} ", (Object)this.operatingPath, (Object)processId);
                DataTransferClient cl = ThreddsController.getDTClient(this.hostname);
                Destination dest = new Destination();
                dest.setCreateSubfolders(Boolean.valueOf(true));
                dest.setOnExistingFileName(DestinationClashPolicy.FAIL);
                dest.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
                dest.setPersistenceId("thredds");
                dest.setSubFolder(this.operatingPath);
                dest.setDestinationFileName("~WS-LOCK.lock");
                temp = File.createTempFile("tmp_lock", ".tmp");
                writer = new PrintWriter(temp);
                writer.write(processId);
                writer.flush();
                writer.close();
                cl.localFile(temp, dest);
                if (writer == null) break block11;
            }
            catch (Throwable t) {
                try {
                    throw new UnableToLockException("Unable to lock " + this.operatingPath, t);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        IOUtils.closeQuietly(writer);
                    }
                    if (temp != null) {
                        try {
                            Files.deleteIfExists(temp.toPath());
                        }
                        catch (IOException e) {
                            log.warn("Unable to delete temp file {} ", (Object)temp.getAbsolutePath(), (Object)e);
                        }
                    }
                    this.resetCallerToken();
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        if (temp != null) {
            try {
                Files.deleteIfExists(temp.toPath());
            }
            catch (IOException e) {
                log.warn("Unable to delete temp file {} ", (Object)temp.getAbsolutePath(), (Object)e);
            }
        }
        this.resetCallerToken();
    }

    public void deleteThreddsFile(String location) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "https://" + this.hostname + "/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(location);
        log.info("Deleting file at {} ", (Object)urlString);
        try {
            ThreddsController.getWebClient().target(urlString).request().delete();
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    public boolean existsThreddsFile(String location) {
        try {
            this.getFileDescriptor(location);
            return true;
        }
        catch (RemoteFileNotFoundException e) {
            return false;
        }
    }

    public String readThreddsFile(String location) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "https://" + this.hostname + "/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(location);
        log.info("Reading file at {} ", (Object)urlString);
        try {
            String string = (String)ThreddsController.getWebClient().target(urlString).request().get().readEntity(String.class);
            return string;
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    public void createEmptyFolder(String targetPath) throws InternalException {
        this.setTargetToken();
        String toCleanPath = this.getPathFromStartingLocation(targetPath);
        try {
            log.info("Cleaning up {} on {} ", (Object)toCleanPath, (Object)this.hostname);
            DataTransferClient client = ThreddsController.getDTClient(this.hostname);
            File toTransfer = File.createTempFile("clean", ".dt_temp");
            toTransfer.createNewFile();
            Destination dest = new Destination();
            dest.setCreateSubfolders(Boolean.valueOf(true));
            dest.setOnExistingFileName(DestinationClashPolicy.REWRITE);
            dest.setOnExistingSubFolder(DestinationClashPolicy.REWRITE);
            dest.setPersistenceId("thredds");
            dest.setSubFolder(toCleanPath);
            dest.setDestinationFileName(toTransfer.getName());
            log.info("Going to cleanup remote folder {} on {} ", (Object)dest.getSubFolder(), (Object)this.hostname);
            client.localFile(toTransfer, dest);
            this.deleteThreddsFile(targetPath + "/" + toTransfer.getName());
            log.info("Done");
            log.debug("Resulting folder descriptor : {} ", (Object)this.getFileDescriptor(targetPath));
        }
        catch (Exception e) {
            log.error("Unable to delete remote folder " + toCleanPath, (Throwable)e);
            throw new InternalException("Unable to cleanup remote folder.");
        }
        finally {
            this.resetCallerToken();
        }
    }

    public ThreddsCatalog createCatalog(String name) throws InternalException {
        this.setTargetToken();
        try {
            SecurityTokenProvider.instance.get();
            log.info("Creating catalog with name {} for path {} ", (Object)name, (Object)this.operatingPath);
            String sdiUrl = "https://" + ThreddsController.getSDIServiceHost() + "/" + "sdi-service/gcube/service/Thredds";
            Response resp = ThreddsController.getWebClient().target(sdiUrl).queryParam("name", new Object[]{name}).queryParam("path", new Object[]{this.operatingPath}).queryParam("folder", new Object[]{this.operatingPath}).request().put(null);
            if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
                throw new InternalException("Failed catalog registration on SDI Service. Message " + (String)resp.readEntity(String.class));
            }
            ThreddsCatalog threddsCatalog = this.getCatalog();
            return threddsCatalog;
        }
        catch (Throwable t) {
            log.error("Unable to create catalog", t);
            throw new InternalException("Unable to create catalog", t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreddsCatalog getCatalog() {
        this.setTargetToken();
        try {
            ThreddsInfo info = this.getThreddsInfo();
            String instanceBasePath = info.getLocalBasePath();
            ThreddsCatalog threddsCatalog = info.getCatalogByFittingLocation(instanceBasePath + "/" + this.operatingPath);
            return threddsCatalog;
        }
        finally {
            this.resetCallerToken();
        }
    }

    public RemoteFileDescriptor getFileDescriptor() throws RemoteFileNotFoundException {
        return this.getFileDescriptor(null);
    }

    public RemoteFileDescriptor getFileDescriptor(String path) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "https://" + this.hostname + "/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(path);
        log.info("Reading file at {} ", (Object)urlString);
        try {
            RemoteFileDescriptor remoteFileDescriptor = (RemoteFileDescriptor)ThreddsController.getWebClient().target(urlString).queryParam("descriptor", new Object[]{true}).request().get().readEntity(RemoteFileDescriptor.class);
            return remoteFileDescriptor;
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    public InputStream getInputStream(String path) throws RemoteFileNotFoundException {
        this.setTargetToken();
        String urlString = "https://" + this.hostname + "/" + "data-transfer-service/gcube/service/REST/thredds/" + this.getPathFromStartingLocation(path);
        log.info("Reading file at {} ", (Object)urlString);
        try {
            InputStream inputStream = (InputStream)ThreddsController.getWebClient().target(urlString).request().get().readEntity(InputStream.class);
            return inputStream;
        }
        catch (Throwable t) {
            throw new RemoteFileNotFoundException("Unable to access " + urlString, t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferResult transferFile(Destination dest, URL url, Set<PluginInvocation> invocations) throws InvalidSourceException, SourceNotSetException, FailedTransferException, InitializationException, InvalidDestinationException, DestinationNotSetException {
        this.setTargetToken();
        try {
            DataTransferClient client = ThreddsController.getDTClient(this.hostname);
            if (invocations != null && !invocations.isEmpty()) {
                TransferResult transferResult = client.httpSource(url, dest, invocations);
                return transferResult;
            }
            TransferResult transferResult = client.httpSource(url, dest);
            return transferResult;
        }
        finally {
            this.resetCallerToken();
        }
    }

    private String getPathFromStartingLocation(String location) {
        if (location != null && location.length() > 0) {
            return this.operatingPath + "/" + location;
        }
        return this.operatingPath;
    }

    private static String getSDIServiceHost() {
        return ThreddsController.getGCoreEndpointHostname("SDI", "sdi-service");
    }

    private String getThreddsHost() throws InternalException {
        this.setTargetToken();
        try {
            String sdiUrl = "https://" + ThreddsController.getSDIServiceHost() + "/" + "sdi-service/gcube/service/SDI";
            log.info("checking sdI configuration at {}", (Object)sdiUrl);
            Response resp = ThreddsController.getWebClient().target(sdiUrl).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            String respString = (String)resp.readEntity(String.class);
            if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
                throw new InternalException("Failed to contact SDI. Message " + respString);
            }
            DocumentContext sourceCtx = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(respString);
            String string = new URL((String)((List)sourceCtx.read("$.threddsConfiguration..baseEndpoint", new Predicate[0])).get(0)).getHost();
            return string;
        }
        catch (Throwable t) {
            log.error("Unable to read SDI configuration", t);
            throw new InternalException("Unable to gt configuration from SDI", t);
        }
        finally {
            this.resetCallerToken();
        }
    }

    private static String getGCoreEndpointHostname(String serviceClass, String serviceName) {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        GCoreEndpoint endpoint = (GCoreEndpoint)client.submit((Query)query).get(0);
        return ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().iterator().next()).uri().getHost();
    }

    private static Client getWebClient() {
        return (Client)ClientBuilder.newClient((javax.ws.rs.core.Configuration)new ClientConfig().register(CustomAuthorizationFilter.class)).property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
    }

    private static DataTransferClient getDTClient(String threddsHostName) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting DT Client for {} ", (Object)threddsHostName);
        return DataTransferClient.getInstanceByEndpoint((String)("https://" + threddsHostName));
    }
}

