/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.usecases.ws.thredds.Constants;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessDescriptor;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessStatus;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceFolderManager;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceUtils;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationThread;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferFromThreddsRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferToThreddsRequest;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceNotSynchedException;
import org.gcube.usecases.ws.thredds.model.CompletionCallback;
import org.gcube.usecases.ws.thredds.model.StepReport;
import org.gcube.usecases.ws.thredds.model.SyncOperationCallBack;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.gcube.usecases.ws.thredds.model.SynchronizedElementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Process {
    private static final Logger log = LoggerFactory.getLogger(Process.class);
    private final Object $lock = new Object[0];
    private boolean submittedRequests = false;
    private ProcessDescriptor descriptor;
    private ProcessStatus status;
    private String processId = UUID.randomUUID().toString();
    private Queue<StepReport> queuedReports = new LinkedList<StepReport>();
    private WorkspaceFolderManager manager;
    private Set<SyncOperationCallBack> toInvokeCallbacks = ConcurrentHashMap.newKeySet();
    private CompletionCallback callback = null;

    public Process(String folderId, CompletionCallback callback) throws WorkspaceInteractionException, InternalException {
        log.debug("Created Process with id {} ", (Object)this.processId);
        this.manager = new WorkspaceFolderManager(folderId);
        this.manager.lock(this.processId);
        SynchFolderConfiguration folderConfig = this.manager.getSynchConfiguration();
        try {
            this.descriptor = new ProcessDescriptor(folderId, ((FolderItem)this.manager.getTheFolder().get()).getPath(), System.currentTimeMillis(), this.processId, folderConfig);
        }
        catch (Exception e) {
            throw new WorkspaceInteractionException("Unable to read path from folder " + folderId, e);
        }
        this.callback = callback;
        this.status = new ProcessStatus();
    }

    public void launch(ExecutorService service) throws WorkspaceNotSynchedException, WorkspaceInteractionException, StorageHubException, InternalException {
        WorkspaceUtils.resetStatus(this.manager.getTheFolder());
        this.status.setCurrentMessage("Analyzing folder..");
        Process.generateRequests(this, service, this.manager.getTheFolder());
        this.submittedRequests = true;
        if (this.status.getQueuedTransfers().get() > 0L) {
            this.status.setCurrentMessage("Waiting for requests [" + this.status.getQueuedTransfers().get() + "] to be served.");
            this.status.setStatus(ProcessStatus.Status.ONGOING);
            while (!this.queuedReports.isEmpty()) {
                this.onStep(this.queuedReports.remove());
            }
        } else {
            this.status.setCurrentMessage("Folder is up to date.");
            this.status.setStatus(ProcessStatus.Status.COMPLETED);
            this.callback.onProcessCompleted(this);
            this.invokeCallbacks();
        }
    }

    public void addCallBack(SyncOperationCallBack toAddCallback) {
        this.toInvokeCallbacks.add(toAddCallback);
        log.debug("Added callback for process {}. Current callback size is {}", (Object)this.processId, (Object)this.toInvokeCallbacks.size());
    }

    public ProcessDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void onStep(StepReport report) {
        if (!this.submittedRequests) {
            this.queuedReports.add(report);
        } else {
            this.updateStatus(report);
            if (this.isCompleted()) {
                try {
                    this.manager.setLastUpdateTime();
                }
                catch (Throwable t) {
                    log.error("Unable to update last update time.", t);
                }
                if (this.status.getStatus().equals((Object)ProcessStatus.Status.WARNINGS)) {
                    this.status.setCurrentMessage("Process completed with errors. Please check logs or retry.");
                } else {
                    this.status.setCurrentMessage("Synchronization complete.");
                }
                this.status.setStatus(ProcessStatus.Status.COMPLETED);
                this.callback.onProcessCompleted(this);
            }
            this.invokeCallbacks();
        }
    }

    private void invokeCallbacks() {
        for (SyncOperationCallBack callback : this.toInvokeCallbacks) {
            try {
                callback.onStep((ProcessStatus)this.status.clone(), (ProcessDescriptor)this.descriptor.clone());
            }
            catch (Throwable t) {
                log.warn("Unable to invoke callback {}.", (Object)callback, (Object)t);
            }
        }
    }

    private boolean isCompleted() {
        return this.status.getErrorCount().get() + this.status.getServedTransfers().get() >= this.status.getQueuedTransfers().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(StepReport report) {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Logging report {} ", (Object)report);
            switch (report.getStatus()) {
                case CANCELLED: 
                case ERROR: {
                    this.status.getErrorCount().incrementAndGet();
                    if (this.status.getStatus().equals((Object)ProcessStatus.Status.STOPPED)) break;
                    this.status.setStatus(ProcessStatus.Status.WARNINGS);
                    break;
                }
                default: {
                    this.status.getServedTransfers().incrementAndGet();
                }
            }
            this.status.setCurrentMessage("Waiting for requests [" + (this.status.getErrorCount().get() + this.status.getServedTransfers().get()) + "/" + this.status.getQueuedTransfers().get() + "] to be served.");
            this.status.getLogBuilder().append(String.format("%s - item [%s] %s: %s \n", Constants.DATE_FORMAT.format(new Date(report.getCompletionTime())), report.getElementName(), (Object)((Object)report.getStatus()) + "", report.getMessage()));
        }
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public void cancel() {
        if (this.status.getQueuedTransfers().get() > 1L) {
            this.status.setStatus(ProcessStatus.Status.STOPPED);
            this.status.setCurrentMessage("Process Stopped. Waiting for remaining requests to cancel..");
        } else {
            this.status.setStatus(ProcessStatus.Status.COMPLETED);
            this.status.setCurrentMessage("Process cancelled before it started.");
        }
        this.invokeCallbacks();
        this.callback.onProcessCompleted(this);
    }

    public void cleanup() throws WorkspaceNotSynchedException, WorkspaceInteractionException, InternalException {
        this.manager.unlock(this.processId);
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (Throwable t) {
            log.warn("Exception while trying to cleanup {} ", (Object)this);
        }
    }

    private static final void generateRequests(Process ownerProcess, ExecutorService service, FolderContainer toScanFolder) throws StorageHubException, InternalException {
        String folderPath = ((FolderItem)toScanFolder.get()).getPath();
        log.info("Generating requests for folder {}", (Object)folderPath);
        log.debug("Process is {} ", (Object)ownerProcess.getDescriptor());
        HashSet<String> handledWorkspaceItemEntries = new HashSet<String>();
        SynchFolderConfiguration config = ownerProcess.getDescriptor().getSynchConfiguration();
        HashSet<String> localChildrenNames = new HashSet<String>();
        List localFolderChildren = toScanFolder.list().withAccounting().withMetadata().getContainers();
        for (ItemContainer item : localFolderChildren) {
            localChildrenNames.add(item.get().getName());
        }
        String relativePath = ((FolderItem)toScanFolder.get()).getMetadata().getMap().get("WS-SYNCH.REMOTE-PATH") + "";
        ThreddsController folderController = new ThreddsController(relativePath, config.getTargetToken());
        RemoteFileDescriptor folderDesc = null;
        try {
            folderDesc = folderController.getFileDescriptor();
        }
        catch (RemoteFileNotFoundException e) {
            log.debug("RemoteFolder {} doesn't exists. Creating it.. ", (Object)relativePath);
            folderController.createEmptyFolder(null);
            folderDesc = folderController.getFileDescriptor();
        }
        HashSet<String> remoteChildrenNames = new HashSet<String>(folderDesc.getChildren());
        Set<String> handledAccountingEntries = WorkspaceUtils.scanAccountingForStatus(toScanFolder, config, localChildrenNames, remoteChildrenNames, folderController, ownerProcess, service);
        log.debug("Checking content of {} ", (Object)folderPath);
        for (ItemContainer item : localFolderChildren) {
            if (item.getType().equals((Object)ContainerType.FOLDER)) {
                Process.generateRequests(ownerProcess, service, (FolderContainer)item);
                continue;
            }
            Map props = item.get().getMetadata().getMap();
            String itemId = item.getId();
            String itemName = item.get().getName();
            if (!props.containsKey("WS-SYNCH.TO-BE-SYNCHRONIZED") || props.get("WS-SYNCH.TO-BE-SYNCHRONIZED") == null) continue;
            try {
                SynchronizedElementInfo.SynchronizationStatus status = SynchronizedElementInfo.SynchronizationStatus.valueOf(props.get("WS-SYNCH.SYNCH-STATUS") + "");
                log.trace(String.format("Found TBS item %1$s, name %2$s, status : %3$s", new Object[]{item.getId(), item.get().getName(), status}));
                SynchronizationRequest request = null;
                switch (status) {
                    case OUTDATED_REMOTE: {
                        request = new TransferToThreddsRequest(ownerProcess, (FolderItem)toScanFolder.get(), item.get());
                        break;
                    }
                    case OUTDATED_WS: {
                        request = new TransferFromThreddsRequest(ownerProcess, item.get(), (FolderItem)toScanFolder.get(), null);
                    }
                }
                if (request != null) {
                    service.execute(new SynchronizationThread(request));
                    log.debug("Submitted request number {} ", (Object)ownerProcess.status.getQueuedTransfers().incrementAndGet());
                } else {
                    log.debug("Item is up to date");
                }
                handledWorkspaceItemEntries.add(itemName);
            }
            catch (Throwable t) {
                log.error(String.format("Unable to submit request for %1$s ID %2$s ", itemName, itemId), t);
            }
        }
        try {
            Set<String> toImportItems = WorkspaceUtils.scanRemoteFolder(folderDesc, handledAccountingEntries, handledWorkspaceItemEntries, toScanFolder, folderController, config, ownerProcess, service);
            log.debug("Checking if remote location contains folders to be imported...");
            for (String item : toImportItems) {
                if (!folderController.getFileDescriptor(item).isDirectory()) continue;
                log.info("Creating folder {} under {} ", (Object)item, (Object)folderPath);
                try {
                    FolderContainer folder = toScanFolder.newFolder(item, "Imported from thredds");
                    WorkspaceUtils.initProperties(folder, relativePath + "/" + item, config.getFilter(), config.getTargetToken(), config.getToCreateCatalogName(), config.getValidateMetadata(), config.getRootFolderId());
                    Process.generateRequests(ownerProcess, service, folder);
                }
                catch (Throwable t) {
                    log.error("Unable to import folder {} into {} ", (Object)item, (Object)folderPath);
                }
            }
        }
        catch (InternalException e) {
            log.error("Unable to check remote content with config {} ", (Object)config, (Object)e);
        }
        log.info("All requests for {} synchronization have been submitted [count {} ]. ", (Object)folderPath, (Object)ownerProcess.status.getQueuedTransfers().get());
    }
}

