/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine;

import java.beans.ConstructorProperties;
import java.io.File;
import java.util.HashSet;
import lombok.NonNull;

public class PublishRequest {
    @NonNull
    private PublishItem source;
    @NonNull
    private Mode mode;
    @NonNull
    private String catalog;
    @NonNull
    private String publishToken;
    private Integer queueCount = 0;
    private String queueId;
    private File metadata = null;
    private HashSet<String> toGatherReportsId = null;

    public boolean isQueue() {
        return this.queueCount > 0;
    }

    public boolean isGenerateMeta() {
        return this.metadata == null;
    }

    @ConstructorProperties(value={"source", "mode", "catalog", "publishToken"})
    public PublishRequest(@NonNull PublishItem source, @NonNull Mode mode, @NonNull String catalog, @NonNull String publishToken) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (mode == null) {
            throw new NullPointerException("mode");
        }
        if (catalog == null) {
            throw new NullPointerException("catalog");
        }
        if (publishToken == null) {
            throw new NullPointerException("publishToken");
        }
        this.source = source;
        this.mode = mode;
        this.catalog = catalog;
        this.publishToken = publishToken;
    }

    @NonNull
    public PublishItem getSource() {
        return this.source;
    }

    @NonNull
    public Mode getMode() {
        return this.mode;
    }

    @NonNull
    public String getCatalog() {
        return this.catalog;
    }

    @NonNull
    public String getPublishToken() {
        return this.publishToken;
    }

    public Integer getQueueCount() {
        return this.queueCount;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public File getMetadata() {
        return this.metadata;
    }

    public HashSet<String> getToGatherReportsId() {
        return this.toGatherReportsId;
    }

    public void setSource(@NonNull PublishItem source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
    }

    public void setMode(@NonNull Mode mode) {
        if (mode == null) {
            throw new NullPointerException("mode");
        }
        this.mode = mode;
    }

    public void setCatalog(@NonNull String catalog) {
        if (catalog == null) {
            throw new NullPointerException("catalog");
        }
        this.catalog = catalog;
    }

    public void setPublishToken(@NonNull String publishToken) {
        if (publishToken == null) {
            throw new NullPointerException("publishToken");
        }
        this.publishToken = publishToken;
    }

    public void setQueueCount(Integer queueCount) {
        this.queueCount = queueCount;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public void setMetadata(File metadata) {
        this.metadata = metadata;
    }

    public void setToGatherReportsId(HashSet<String> toGatherReportsId) {
        this.toGatherReportsId = toGatherReportsId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublishItem this$source = this.getSource();
        PublishItem other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$publishToken = this.getPublishToken();
        String other$publishToken = other.getPublishToken();
        if (this$publishToken == null ? other$publishToken != null : !this$publishToken.equals(other$publishToken)) {
            return false;
        }
        Integer this$queueCount = this.getQueueCount();
        Integer other$queueCount = other.getQueueCount();
        if (this$queueCount == null ? other$queueCount != null : !((Object)this$queueCount).equals(other$queueCount)) {
            return false;
        }
        String this$queueId = this.getQueueId();
        String other$queueId = other.getQueueId();
        if (this$queueId == null ? other$queueId != null : !this$queueId.equals(other$queueId)) {
            return false;
        }
        File this$metadata = this.getMetadata();
        File other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        HashSet<String> this$toGatherReportsId = this.getToGatherReportsId();
        HashSet<String> other$toGatherReportsId = other.getToGatherReportsId();
        return !(this$toGatherReportsId == null ? other$toGatherReportsId != null : !((Object)this$toGatherReportsId).equals(other$toGatherReportsId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublishRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublishItem $source = this.getSource();
        result = result * 59 + ($source == null ? 0 : $source.hashCode());
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 0 : ((Object)((Object)$mode)).hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 0 : $catalog.hashCode());
        String $publishToken = this.getPublishToken();
        result = result * 59 + ($publishToken == null ? 0 : $publishToken.hashCode());
        Integer $queueCount = this.getQueueCount();
        result = result * 59 + ($queueCount == null ? 0 : ((Object)$queueCount).hashCode());
        String $queueId = this.getQueueId();
        result = result * 59 + ($queueId == null ? 0 : $queueId.hashCode());
        File $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 0 : ((Object)$metadata).hashCode());
        HashSet<String> $toGatherReportsId = this.getToGatherReportsId();
        result = result * 59 + ($toGatherReportsId == null ? 0 : ((Object)$toGatherReportsId).hashCode());
        return result;
    }

    public String toString() {
        return "PublishRequest(source=" + this.getSource() + ", mode=" + (Object)((Object)this.getMode()) + ", catalog=" + this.getCatalog() + ", publishToken=" + this.getPublishToken() + ", queueCount=" + this.getQueueCount() + ", queueId=" + this.getQueueId() + ", metadata=" + this.getMetadata() + ", toGatherReportsId=" + this.getToGatherReportsId() + ")";
    }

    public static enum Mode {
        NCML,
        NC;

    }

    public static class PublishItem {
        String url;
        String name;
        String id;

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        @ConstructorProperties(value={"url", "name", "id"})
        public PublishItem(String url, String name, String id) {
            this.url = url;
            this.name = name;
            this.id = id;
        }

        public String toString() {
            return "PublishRequest.PublishItem(url=" + this.getUrl() + ", name=" + this.getName() + ", id=" + this.getId() + ")";
        }
    }
}

