/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.rest;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.spatia.data.model.profiles.ApplicationProfile;
import org.gcube.spatial.data.sdi.SDIServiceManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.gcube.spatial.data.sdi.model.health.HealthReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="SDI")
@ManagedBy(value=SDIServiceManager.class)
public class SDI {
    private static final Logger log = LoggerFactory.getLogger(SDI.class);
    @Inject
    private SDIManager sdiManager;

    @GET
    @Produces(value={"application/json"})
    public ScopeConfiguration getConfiguration() {
        try {
            ScopeConfiguration config = this.sdiManager.getContextConfiguration();
            log.debug("Served Configuration");
            return config;
        }
        catch (Throwable t) {
            log.error("Unable to serve get configuration");
            throw new WebApplicationException("Unable to get configuration. Contact administrator.", t);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="status")
    public HealthReport getReport() {
        try {
            return this.sdiManager.getHealthReport();
        }
        catch (Throwable t) {
            log.error("Unabel to get Health Report ", t);
            throw new WebApplicationException("Unable to check Health. Contact administrator.", t);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="profile/{service_class}/{service_name}")
    public ApplicationProfile getProfile(@PathParam(value="service_class") String serviceClass, @PathParam(value="service_name") String serviceName) {
        try {
            log.debug("Looking for Application Profile [SC :{} SN : {}]", (Object)serviceClass, (Object)serviceName);
            throw new RuntimeException("Feature not yet available");
        }
        catch (WebApplicationException e) {
            log.warn("Unable to serve request", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Unable to serve request", e);
            throw new WebApplicationException("Unable to serve request", e);
        }
    }
}

