/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataUtils;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.AbstractMetadataTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataHandler {
    private static final Logger log = LoggerFactory.getLogger(MetadataHandler.class);
    private Document document = null;
    private String metaUUID = null;
    private XPathHelper helper;

    public MetadataHandler(File xmlFile) {
        Element documentNode = null;
        try {
            FileInputStream inputStream = new FileInputStream(xmlFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            documentNode = MetadataUtils.docBuilder.parse(is).getDocumentElement();
            this.document = documentNode.getOwnerDocument();
            this.helper = MetadataUtils.getHelper((Node)this.document);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to fix : unable to get Document", e);
        }
    }

    public String initUUID() throws SAXException, IOException {
        return this.setUUID(UUID.randomUUID().toString());
    }

    public String setUUID(String uuid) throws SAXException, IOException {
        MetadataUtils.addContent((String)"gmd:MD_Metadata", (Document)this.document, (String)String.format("<fileIdentifier xmlns=\"http://www.isotc211.org/2005/gmd\" xmlns:gco=\"http://www.isotc211.org/2005/gco\">        <gco:CharacterString>%s</gco:CharacterString>    </fileIdentifier>", this.metaUUID), (XPathHelper)this.helper, (MetadataUtils.Position)MetadataUtils.Position.first_child);
        return this.getUUID();
    }

    public String getUUID() throws SAXException, IOException {
        if (this.metaUUID == null) {
            log.debug("Managing metadata ID.. ");
            List metaUUIDList = this.helper.evaluate("//gmd:fileIdentifier/gco:CharacterString/text()");
            if (!metaUUIDList.isEmpty()) {
                this.metaUUID = (String)metaUUIDList.get(0);
                log.debug("Found meta UUID {} ", (Object)this.metaUUID);
            }
        }
        return this.metaUUID;
    }

    public void addContent(String content, AbstractMetadataTemplate.InsertionPoint insertion) throws SAXException, IOException {
        MetadataUtils.addContent((String)insertion.getElementReference(), (Document)this.document, (String)content, (XPathHelper)this.helper, (MetadataUtils.Position)insertion.getPosition());
    }

    public File writeOut() throws IOException, TransformerException {
        DOMSource source = new DOMSource(this.document);
        File output = File.createTempFile("meta_", ".xml");
        output.createNewFile();
        StreamResult result = new StreamResult(output);
        MetadataUtils.transformer.transform(source, result);
        return output;
    }
}

