/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.engine.impl.is.AbstractISModule;
import org.gcube.spatial.data.sdi.engine.impl.is.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.gn.Account;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoNetworkRetriever
extends AbstractISModule {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkRetriever.class);

    protected static final Credentials fromGeoNetworkAccount(Account toTranslate) {
        switch (1.$SwitchMap$org$gcube$spatial$data$sdi$model$gn$Account$Type[toTranslate.getType().ordinal()]) {
            case 1: {
                return new Credentials(toTranslate.getUser(), toTranslate.getPassword(), AccessType.CKAN);
            }
            case 2: {
                return new Credentials(toTranslate.getUser(), toTranslate.getPassword(), AccessType.CONTEXT_USER);
            }
        }
        throw new RuntimeException("Unrecognized account type " + toTranslate);
    }

    protected boolean isSmartGearsMandatory() {
        return LocalConfiguration.getFlag((String)"gn.mandatorySG");
    }

    protected static final ServiceEndpoint getTheRightServiceEndpoint(List<ServiceEndpoint> resources, String endpointName, String priorityProperty) {
        ServiceEndpoint toReturn = null;
        int priority = 1000;
        for (ServiceEndpoint resource : resources) {
            for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
                Map properties;
                log.debug(point.toString());
                if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
                int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
                if (toReturn != null && currentPriority >= priority) continue;
                toReturn = resource;
                priority = currentPriority;
            }
        }
        return toReturn;
    }

    protected static final ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint resource, String endpointName, String priorityProperty) {
        ServiceEndpoint.AccessPoint toReturn = null;
        int priority = 1000;
        for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
            Map properties;
            log.debug(point.toString());
            if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
            int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
            if (toReturn != null && currentPriority >= priority) continue;
            toReturn = point;
            priority = currentPriority;
        }
        return toReturn;
    }

    protected String getGCoreEndpointServiceClass() {
        return LocalConfiguration.getProperty((String)"gn.ge.serviceClass");
    }

    protected String getGCoreEndpointServiceName() {
        return LocalConfiguration.getProperty((String)"gn.ge.serviceName");
    }

    protected String getManagedServiceType() {
        return "GeoNetwork";
    }

    protected String getServiceEndpointCategory() {
        return LocalConfiguration.getProperty((String)"gn.se.category");
    }

    protected String getServiceEndpointPlatformName() {
        return LocalConfiguration.getProperty((String)"gn.se.platform");
    }

    protected String getServiceEndpointAccessPointName() {
        return LocalConfiguration.getProperty((String)"gn.se.endpointName");
    }

    protected List<Status> performInstanceCheck(ServiceEndpoint se) {
        return Collections.EMPTY_LIST;
    }

    protected void checkDefinitionForServiceType(ServiceDefinition definition) {
        log.info("Checking geonetwork for {} ", (Object)definition);
    }

    protected ServiceEndpoint prepareEndpoint(ServiceDefinition definition) throws ServiceRegistrationException {
        ServiceEndpoint toReturn = super.prepareEndpoint(definition);
        GeoNetworkServiceDefinition gnDefinition = (GeoNetworkServiceDefinition)definition;
        ServiceEndpoint.AccessPoint point = new ServiceEndpoint.AccessPoint();
        point.address("http://" + definition.getHostname() + "/geonetwork");
        point.credentials(ISUtils.encryptString((String)definition.getAdminPassword()), "admin");
        point.description("Main Access point");
        point.name(this.getServiceEndpointAccessPointName());
        ServiceEndpoint.Property priorityProperty = new ServiceEndpoint.Property();
        priorityProperty.nameAndValue("priority", gnDefinition.getPriority() + "");
        point.properties().add((Object)priorityProperty);
        ServiceEndpoint.Property suffixesProperty = new ServiceEndpoint.Property();
        suffixesProperty.nameAndValue("suffixes", "");
        point.properties().add((Object)suffixesProperty);
        toReturn.profile().accessPoints().add((Object)point);
        return toReturn;
    }

    protected void checkDefinitionType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
        if (!definition.getType().equals((Object)ServiceDefinition.Type.GEONETWORK) || !(definition instanceof GeoNetworkServiceDefinition)) {
            throw new InvalidServiceDefinitionException("Invalid service type [expected " + ServiceDefinition.Type.GEONETWORK + "]. Definition was " + definition);
        }
    }
}

