/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.rest;

import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.spatial.data.sdi.SDIServiceManager;
import org.gcube.spatial.data.sdi.engine.ThreddsManager;
import org.gcube.spatial.data.sdi.utils.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Thredds")
@ManagedBy(value=SDIServiceManager.class)
public class Thredds {
    private static final Logger log = LoggerFactory.getLogger(Thredds.class);
    @Inject
    ThreddsManager threddsManager;

    @PUT
    @Produces(value={"application/json"})
    public ThreddsCatalog registerCatalog(@QueryParam(value="authority") @DefaultValue(value="www.d4science.org") String authority, @QueryParam(value="name") String baseName, @QueryParam(value="path") String path, @QueryParam(value="folder") String folder) {
        try {
            String scopeName = ScopeUtils.getCurrentScopeName();
            log.info("Received register catalog request under scope {} ", (Object)scopeName);
            if (baseName == null) {
                log.debug("Base name not provided, using VRE {} ", (Object)scopeName);
                baseName = scopeName + "_VRE";
            }
            if (folder == null) {
                log.debug("Folder not provided, using base name {} ", (Object)baseName);
                folder = baseName + "_folder";
            }
            if (path == null) {
                log.debug("Path not provided, using baseName {} ", (Object)baseName);
                path = baseName;
            }
            String datasetScanName = (baseName + " Catalog").replace("_", " ");
            String datasetScanId = baseName + "_in_" + folder;
            String catalogReference = baseName.replaceAll("_", " ");
            return this.threddsManager.createCatalogFromTemplate(authority, path, datasetScanId, datasetScanName, folder, catalogReference);
        }
        catch (Throwable t) {
            log.warn("Unable to create catalog", t);
            throw new WebApplicationException("Unable to serve request", t);
        }
    }
}

