/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.rest;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.swagger.annotations.Api;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.spatial.data.sdi.SDIServiceManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.gcube.spatial.data.sdi.model.health.HealthReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="SDI")
@Api(value="SDI")
@ManagedBy(value=SDIServiceManager.class)
public class SDI {
    private static final Logger log = LoggerFactory.getLogger(SDI.class);
    @Inject
    private SDIManager sdiManager;

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    public ScopeConfiguration getConfiguration() {
        return this.sdiManager.getContextConfiguration();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Path(value="status")
    public HealthReport getReport() {
        try {
            return this.sdiManager.getHealthReport();
        }
        catch (Throwable t) {
            log.error("Unabel to get Health Report ", t);
            throw new WebApplicationException("Unable to check Health. Contact administrator.", t);
        }
    }
}

