/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.util.ArrayList;
import java.util.Comparator;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.sdi.engine.impl.cluster.AbstractCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoServerController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceInteractionException;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.model.service.GeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerCluster
extends AbstractCluster<GeoServerDescriptor, GeoServerController> {
    private static final Logger log = LoggerFactory.getLogger(GeoServerCluster.class);
    private static final Comparator<GeoServerController> comparator = new /* Unavailable Anonymous Inner Class!! */;

    public GeoServerCluster(long objectsTTL, ISModule retriever, String cacheName) {
        super(objectsTTL, retriever, cacheName);
    }

    protected Comparator<GeoServerController> getComparator() {
        return comparator;
    }

    protected GeoServerController translate(ServiceEndpoint e) throws InvalidServiceEndpointException {
        return new GeoServerController(e);
    }

    protected ArrayList<GeoServerController> getLiveControllerCollection() throws ConfigurationNotFoundException {
        ArrayList toReturn = super.getLiveControllerCollection();
        for (GeoServerController controller : toReturn) {
            try {
                controller.configure();
            }
            catch (ServiceInteractionException e) {
                log.warn("Unexpected exception while configuring GeoServer SE [ID : " + controller.getServiceEndpoint().id() + "]", (Throwable)e);
            }
        }
        return toReturn;
    }
}

