/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.gn.extension;

import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataGetInfo;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GN26Extension;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GN3Extension;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GNMetadataAdminExtension;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.ServerAccess;
import org.gcube.spatial.data.sdi.engine.impl.gn.utils.GroupUtils;
import org.gcube.spatial.data.sdi.engine.impl.gn.utils.UserUtils;
import org.gcube.spatial.data.sdi.model.gn.Group;
import org.gcube.spatial.data.sdi.model.gn.User;
import org.jdom.Element;

public class GNClientExtension
implements GNClient {
    private GNClient client;
    private ServerAccess access;

    public GNClientExtension(ServerAccess access) {
        this.access = access;
        if (access.getVersion().getMajor() == 2) {
            this.client = new GN26Extension(access.getGnServiceURL(), access.getUser(), access.getPassword());
        } else if (access.getVersion().getMajor() == 3) {
            this.client = new GN3Extension(access.getGnServiceURL(), access.getUser(), access.getPassword());
        } else {
            throw new RuntimeException("INVALID SERVER ACCESS " + access);
        }
    }

    public void createGroup(String name, String description, String mail, Integer id) throws GNLibException, GNServerException {
        GNMetadataAdminExtension.createGroup((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (String)name, (String)description, (String)mail, (Integer)id);
    }

    public Set<Group> getGroups() throws GNLibException, GNServerException {
        String groupResponse = GNMetadataAdminExtension.getGroups((HTTPUtils)this.getConnection(), (ServerAccess)this.access);
        if (this.access.getVersion().getMajor() == 2) {
            return GroupUtils.parseGroupXMLResponse((String)groupResponse);
        }
        return GroupUtils.parseUserJSONResponse((String)groupResponse);
    }

    public Set<User> getUsers() throws GNLibException, GNServerException {
        String userResponse = GNMetadataAdminExtension.getUsers((HTTPUtils)this.getConnection(), (ServerAccess)this.access);
        if (this.access.getVersion().getMajor() == 2) {
            return UserUtils.parseUserXMLResponse((String)userResponse);
        }
        return UserUtils.parseUserJSONResponse((String)userResponse);
    }

    public void createUser(String name, String password, User.Profile profile, Collection<Integer> groups) throws GNServerException, GNLibException {
        GNMetadataAdminExtension.createUser((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (String)name, (String)password, (User.Profile)profile, groups);
    }

    public void editUser(User toAdd, Collection<Integer> groups) throws GNServerException, GNLibException {
        Set alreadyAddedGroups = this.getGroupsByUser(toAdd.getId());
        alreadyAddedGroups.addAll(groups);
        GNMetadataAdminExtension.editUser((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (User)toAdd, (Collection)alreadyAddedGroups);
    }

    public Set<Integer> getGroupsByUser(Integer userId) throws GNLibException, GNServerException {
        return UserUtils.parseGroupsByUserResponse((String)GNMetadataAdminExtension.getUserGroupd((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (Integer)userId));
    }

    public void assignOwnership(List<Long> toTransferIds, Integer targetUserId, Integer targetGroupId) throws GNServerException, GNLibException {
        try {
            GNMetadataAdminExtension.selectMeta((HTTPUtils)this.getConnection(), (ServerAccess)this.access, toTransferIds);
            GNMetadataAdminExtension.assignMassiveOwnership((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (Integer)targetUserId, (Integer)targetGroupId);
        }
        finally {
            GNMetadataAdminExtension.clearMetaSelection((HTTPUtils)this.getConnection(), (ServerAccess)this.access);
        }
    }

    public String getPossibleOwnershipTransfer(Integer userId) throws GNServerException, GNLibException {
        return GNMetadataAdminExtension.allowedOwnershipTransfer((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (Integer)userId);
    }

    public String getMetadataOwners() throws GNServerException, GNLibException {
        return GNMetadataAdminExtension.metadataOwners((HTTPUtils)this.getConnection(), (ServerAccess)this.access);
    }

    public void transferOwnership(Integer sourceUserId, Integer sourceGroupId, Integer targetUserId, Integer targetGroupId) throws GNServerException, GNLibException {
        GNMetadataAdminExtension.transferOwnership((HTTPUtils)this.getConnection(), (ServerAccess)this.access, (Integer)sourceUserId, (Integer)sourceGroupId, (Integer)targetUserId, (Integer)targetGroupId);
    }

    public boolean ping() {
        return this.client.ping();
    }

    public long insertMetadata(GNInsertConfiguration cfg, File metadataFile) throws GNLibException, GNServerException {
        return this.client.insertMetadata(cfg, metadataFile);
    }

    public long insertRequest(File requestFile) throws GNLibException, GNServerException {
        return this.client.insertRequest(requestFile);
    }

    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        this.client.setPrivileges(metadataId, cfg);
    }

    public GNSearchResponse search(GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        return this.client.search(searchRequest);
    }

    public GNSearchResponse search(File fileRequest) throws GNLibException, GNServerException {
        return this.client.search(fileRequest);
    }

    public Element get(Long id) throws GNLibException, GNServerException {
        return this.client.get(id);
    }

    public Element get(String uuid) throws GNLibException, GNServerException {
        return this.client.get(uuid);
    }

    public void deleteMetadata(long id) throws GNLibException, GNServerException {
        this.client.deleteMetadata(id);
    }

    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException {
        this.client.updateMetadata(id, metadataFile);
    }

    public void updateMetadata(long id, File metadataFile, String encoding) throws GNLibException, GNServerException {
        this.client.updateMetadata(id, metadataFile, encoding);
    }

    public GN3MetadataGetInfo.MetadataInfo getInfo(Long id) throws GNLibException, GNServerException {
        return this.client.getInfo(id);
    }

    public GN3MetadataGetInfo.MetadataInfo getInfo(String uuid) throws GNLibException, GNServerException {
        return this.client.getInfo(uuid);
    }

    public HTTPUtils getConnection() throws GNLibException {
        return this.client.getConnection();
    }
}

