/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.metadata;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.TemplateManager;
import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataHandler;
import org.gcube.spatial.data.sdi.engine.impl.metadata.TemplateApplicationReport;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.AbstractMetadataTemplate;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.InvalidTemplateInvocationException;
import org.gcube.spatial.data.sdi.engine.impl.metadata.templates.ThreddsOnlineTemplate;
import org.gcube.spatial.data.sdi.model.metadata.TemplateCollection;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class MetadataTemplateManagerImpl
implements TemplateManager {
    private static final Logger log = LoggerFactory.getLogger(MetadataTemplateManagerImpl.class);
    private static Configuration cfg;
    private static HashMap<String, AbstractMetadataTemplate> availableMetadataTemplates;
    private static TemplateCollection metadataTemplateDescriptors;

    static {
        availableMetadataTemplates = new HashMap();
    }

    @PostConstruct
    public void defaultInit() {
        this.init(LocalConfiguration.getTemplateConfigurationObject());
    }

    public void init(Object configurationObject) {
        log.debug("Configuring with {} ", configurationObject);
        cfg = new Configuration(Configuration.VERSION_2_3_25);
        if (configurationObject instanceof ApplicationContext) {
            log.debug("Configuration is Context : {} ", configurationObject);
            cfg.setServletContextForTemplateLoading((Object)((ApplicationContext)configurationObject).application(), LocalConfiguration.getProperty((String)"tpl.folder"));
        } else if (configurationObject instanceof File) {
            try {
                cfg.setDirectoryForTemplateLoading((File)configurationObject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Invalid configuration object");
        }
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        ThreddsOnlineTemplate tpl = new ThreddsOnlineTemplate();
        availableMetadataTemplates.put(tpl.getDescriptor().getId(), tpl);
        ArrayList<TemplateDescriptor> metadataTemplates = new ArrayList<TemplateDescriptor>();
        metadataTemplates.add(tpl.getDescriptor());
        log.debug("Loaded metadata templates : ");
        for (TemplateDescriptor desc : metadataTemplates) {
            log.debug(desc.toString());
        }
        metadataTemplateDescriptors = new TemplateCollection(new HashSet(metadataTemplates));
    }

    public TemplateCollection getAvailableMetadataTemplates() {
        return metadataTemplateDescriptors;
    }

    public TemplateApplicationReport applyMetadataTemplates(File original, Set<TemplateInvocation> invocations) throws IOException, TransformerException {
        log.debug("Applying template invocations {} to {} ", invocations, (Object)original.getAbsolutePath());
        TemplateApplicationReport report = new TemplateApplicationReport();
        report.setRequestedInvocations(invocations);
        HashSet<String> appliedTemplates = new HashSet<String>();
        MetadataHandler handler = new MetadataHandler(original);
        for (TemplateInvocation invocation : invocations) {
            try {
                MetadataTemplateManagerImpl.applyTemplate((File)original, (TemplateInvocation)invocation, (MetadataHandler)handler);
                appliedTemplates.add(invocation.getToInvokeTemplateID());
            }
            catch (Throwable t) {
                log.warn("Unable to apply template {} ", (Object)invocation.getToInvokeTemplateID());
                log.debug("StackTrace : ", t);
            }
        }
        log.debug("Writing out result..");
        report.setGeneratedFilePath(handler.writeOut().getAbsolutePath());
        report.setAppliedTemplates(appliedTemplates);
        return report;
    }

    private static void applyTemplate(File original, TemplateInvocation invocation, MetadataHandler handler) throws Exception {
        log.debug("Instantiating " + invocation);
        AbstractMetadataTemplate tpl = (AbstractMetadataTemplate)availableMetadataTemplates.get(invocation.getToInvokeTemplateID());
        if (tpl == null) {
            throw new InvalidTemplateInvocationException("Template with ID " + invocation.getToInvokeTemplateID() + " was not found");
        }
        OutputStreamWriter out = null;
        try {
            try {
                Template temp = cfg.getTemplate(tpl.getFileName());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                out = new OutputStreamWriter(baos);
                temp.process(tpl.getInstantiationRequest(handler, invocation), (Writer)out);
                ((Writer)out).flush();
                String instantiatedTemplate = baos.toString(StandardCharsets.UTF_8.toString());
                handler.addContent(instantiatedTemplate, tpl.getInsertionPoint());
            }
            catch (Exception e) {
                log.error("Unable to apply template. Invocation was {} ", (Object)invocation, (Object)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                IOUtils.closeQuietly(out);
            }
            throw throwable;
        }
        if (out != null) {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    public File generateFromTemplate(Map<String, String> parameters, String template) throws Exception {
        File file;
        block5: {
            FileWriter out = null;
            try {
                log.info("Generating from template {}. Parameters are {} ", (Object)template, parameters);
                Template temp = cfg.getTemplate(template);
                File toReturn = File.createTempFile(template, ".xml");
                out = new FileWriter(toReturn);
                temp.process(parameters, (Writer)out);
                ((Writer)out).flush();
                file = toReturn;
                if (out == null) break block5;
            }
            catch (Exception e) {
                try {
                    log.error("Unable to apply template{}. Parameters were {} ", new Object[]{template, parameters, e});
                    throw e;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        IOUtils.closeQuietly(out);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)out);
        }
        return file;
    }
}

