/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import javax.inject.Singleton;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.impl.cache.Cache;
import org.gcube.spatial.data.sdi.engine.impl.cache.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.engine.impl.cache.ISModule;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.model.health.ServiceHealthReport;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkConfiguration;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;

@Singleton
public class GeoNetworkManagerImpl
implements GeoNetworkManager {
    private Cache<GeoNetworkConfiguration> cache = null;
    private GeoNetworkRetriever retriever = new GeoNetworkRetriever();

    public GeoNetworkManagerImpl() {
        this.cache = Cache.getCache((ISModule)this.retriever, (long)Long.parseLong(LocalConfiguration.get().getProperty("gn.cache.TTL")), (String)"GeoNetwork - cache");
    }

    public GeoNetworkConfiguration getConfiguration() throws ConfigurationNotFoundException {
        return (GeoNetworkConfiguration)this.cache.get();
    }

    public ServiceHealthReport getHealthReport() {
        return this.retriever.getHealthReport();
    }

    public String registerService(GeoNetworkServiceDefinition definition) throws ServiceRegistrationException {
        return this.retriever.registerService((ServiceDefinition)definition);
    }

    public String importHostFromToken(String sourceToken, String hostname) throws ServiceRegistrationException {
        return this.retriever.importHostFromToken(sourceToken, hostname);
    }
}

