/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.cache.AbstractISModule;
import org.gcube.spatial.data.sdi.engine.impl.cache.ISUtils;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.service.GeoServerClusterConfiguration;
import org.gcube.spatial.data.sdi.model.service.GeoServerConfiguration;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.gcube.spatial.data.sdi.model.services.GeoServerDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoServerClusterRetriever
extends AbstractISModule<GeoServerClusterConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(GeoServerClusterRetriever.class);

    public GeoServerClusterConfiguration getObject() throws ConfigurationNotFoundException {
        try {
            ArrayList<GeoServerConfiguration> availableInstances = new ArrayList<GeoServerConfiguration>();
            for (ServiceEndpoint ep : this.getServiceEndpoints()) {
                try {
                    availableInstances.add(this.translate(ep));
                }
                catch (Throwable t) {
                    log.warn("Unable to translate ServiceEndpoint [ID : {}].", (Object)ep.id(), (Object)t);
                }
            }
        }
        catch (Throwable e) {
            log.warn("Unable to gather geoserver cluster configuration on scope " + ScopeUtils.getCurrentScope(), e);
            throw new ConfigurationNotFoundException("Unable to gather geoserver cluster configuration. Please ontact administrator.", e);
        }
        log.info("Retrieving GeoServer cluster configuration under scope {}", (Object)ScopeUtils.getCurrentScope());
        try {
            GISInterface gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            ArrayList<GeoServerConfiguration> availableInstances = new ArrayList<GeoServerConfiguration>();
            for (AbstractGeoServerDescriptor desc : gis.getCurrentCacheElements(Boolean.valueOf(true))) {
                try {
                    availableInstances.add(GeoServerClusterRetriever.translate((AbstractGeoServerDescriptor)desc));
                }
                catch (Throwable t) {
                    log.warn("Unable to translate descriptor for endpoint" + desc.getUrl(), t);
                }
            }
            return new GeoServerClusterConfiguration(availableInstances);
        }
        catch (Exception e) {
            log.warn("Unable to gather geoserver cluster configuration on scope " + ScopeUtils.getCurrentScope(), (Throwable)e);
            throw new ConfigurationNotFoundException("Unable to gather geoserver cluster configuration. Please ontact administrator.", (Throwable)e);
        }
    }

    private final GeoServerConfiguration translate(ServiceEndpoint ep) {
        String publicProperty;
        String sharedProperty;
        String contextProperty;
        GeoServerConfiguration toReturn = new GeoServerConfiguration();
        ServiceEndpoint.Profile profile = ep.profile();
        ServiceEndpoint.AccessPoint point = null;
        for (ServiceEndpoint.AccessPoint declaredPoint : profile.accessPoints().asCollection()) {
            if (!declaredPoint.name().equals(this.getServiceEndpointAccessPointName())) continue;
            point = declaredPoint;
            break;
        }
        toReturn.setBaseEndpoint(point.address());
        String scopeName = ScopeUtils.getCurrentScopeName();
        List accessibleCredentials = toReturn.getAccessibleCredentials();
        accessibleCredentials.add(new Credentials(point.username(), ISUtils.decryptString((String)point.password()), AccessType.ADMIN));
        Map pointProperties = point.propertyMap();
        AccessType[] accessTypeArray = AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessType toLookForType = accessTypeArray[n2];
            String userNameProperty = toLookForType + "_u_" + scopeName;
            String passwordProperty = toLookForType + "_u_" + scopeName;
            if (pointProperties.containsKey(userNameProperty)) {
                String user = ((ServiceEndpoint.Property)pointProperties.get(userNameProperty)).value();
                String password = ISUtils.decryptString((String)((ServiceEndpoint.Property)pointProperties.get(passwordProperty)).value());
                accessibleCredentials.add(new Credentials(user, password, toLookForType));
            }
            ++n2;
        }
        String confidentialProperty = "confidential_" + scopeName;
        if (pointProperties.containsKey(confidentialProperty)) {
            toReturn.setConfidentialWorkspace(((ServiceEndpoint.Property)pointProperties.get(confidentialProperty)).value());
        }
        if (pointProperties.containsKey(contextProperty = "context_" + scopeName)) {
            toReturn.setContextVisibilityWorkspace(((ServiceEndpoint.Property)pointProperties.get(contextProperty)).value());
        }
        if (pointProperties.containsKey(sharedProperty = "shared_" + scopeName)) {
            toReturn.setSharedWorkspace(((ServiceEndpoint.Property)pointProperties.get(sharedProperty)).value());
        }
        if (pointProperties.containsKey(publicProperty = "public_" + scopeName)) {
            toReturn.setPublicWorkspace(((ServiceEndpoint.Property)pointProperties.get(publicProperty)).value());
        }
        Platform platform = profile.platform();
        toReturn.setVersion(new Version(Short.valueOf(platform.version()), platform.minorVersion(), platform.revisionVersion()));
        return toReturn;
    }

    private static final GeoServerConfiguration translate(AbstractGeoServerDescriptor desc) {
        Version version = new Version(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2));
        String baseEndpoint = desc.getUrl();
        List<Credentials> accessibleCredentials = Collections.singletonList(new Credentials(desc.getUser(), desc.getPassword(), AccessType.ADMIN));
        String confidentialWorkspace = null;
        String contextVisibilityWorkspace = null;
        String sharedWorkspace = null;
        String publicWorkspace = null;
        return new GeoServerConfiguration(version, baseEndpoint, accessibleCredentials, confidentialWorkspace, contextVisibilityWorkspace, sharedWorkspace, publicWorkspace);
    }

    protected String getGCoreEndpointServiceClass() {
        return LocalConfiguration.get().getProperty("gs.ge.serviceClass");
    }

    protected String getGCoreEndpointServiceName() {
        return LocalConfiguration.get().getProperty("gs.ge.serviceName");
    }

    protected String getManagedServiceType() {
        return "GeoServer";
    }

    protected String getServiceEndpointAccessPointName() {
        return LocalConfiguration.get().getProperty("gs.se.endpointName");
    }

    protected String getServiceEndpointCategory() {
        return LocalConfiguration.get().getProperty("gs.se.category");
    }

    protected String getServiceEndpointPlatformName() {
        return LocalConfiguration.get().getProperty("gs.se.platform");
    }

    protected List<Status> performInstanceCheck(ServiceEndpoint se) {
        return Collections.EMPTY_LIST;
    }

    protected void checkDefinitionForServiceType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
    }

    protected void checkDefinitionType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
        if (!definition.getType().equals((Object)ServiceDefinition.Type.GEOSERVER) || !(definition instanceof GeoServerDefinition)) {
            throw new InvalidServiceDefinitionException("Invalid service type [expected " + ServiceDefinition.Type.GEOSERVER + "]. Definition was " + definition);
        }
    }
}

