/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import javax.inject.Singleton;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.ThreddsManager;
import org.gcube.spatial.data.sdi.engine.impl.cache.Cache;
import org.gcube.spatial.data.sdi.engine.impl.cache.ISModule;
import org.gcube.spatial.data.sdi.engine.impl.cache.ThreddsRetriever;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.model.health.ServiceHealthReport;
import org.gcube.spatial.data.sdi.model.service.ThreddsConfiguration;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ThreddsDefinition;

@Singleton
public class ThreddsManagerImpl
implements ThreddsManager {
    private Cache<ThreddsConfiguration> cache = null;
    private ThreddsRetriever retriever = new ThreddsRetriever();

    public ThreddsManagerImpl() {
        this.cache = Cache.getCache((ISModule)this.retriever, (long)Long.parseLong(LocalConfiguration.get().getProperty("th.cache.TTL")), (String)"THREDDS - CACHE");
    }

    public ThreddsConfiguration getConfiguration() throws ConfigurationNotFoundException {
        return (ThreddsConfiguration)this.cache.get();
    }

    public ServiceHealthReport getHealthReport() {
        return this.retriever.getHealthReport();
    }

    public String registerService(ThreddsDefinition definition) throws ServiceRegistrationException {
        return this.retriever.registerService((ServiceDefinition)definition);
    }

    public String importHostFromToken(String sourceToken, String hostname) throws ServiceRegistrationException {
        return this.retriever.importHostFromToken(sourceToken, hostname);
    }
}

