/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import javax.inject.Singleton;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.GISManager;
import org.gcube.spatial.data.sdi.engine.impl.cache.Cache;
import org.gcube.spatial.data.sdi.engine.impl.cache.GeoServerClusterRetriever;
import org.gcube.spatial.data.sdi.engine.impl.cache.ISModule;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.model.health.ServiceHealthReport;
import org.gcube.spatial.data.sdi.model.service.GeoServerClusterConfiguration;
import org.gcube.spatial.data.sdi.model.services.GeoServerDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;

@Singleton
public class GISManagerImpl
implements GISManager {
    private Cache<GeoServerClusterConfiguration> theCache = null;
    private GeoServerClusterRetriever retriever = new GeoServerClusterRetriever();

    public GISManagerImpl() {
        this.theCache = Cache.getCache((ISModule)this.retriever, (long)Long.parseLong(LocalConfiguration.get().getProperty("gs.cache.TTL")), (String)"GeoCluster - cache");
    }

    public GeoServerClusterConfiguration getConfiguration() throws ConfigurationNotFoundException {
        return (GeoServerClusterConfiguration)this.theCache.get();
    }

    public ServiceHealthReport getHealthReport() {
        return this.retriever.getHealthReport();
    }

    public String registerService(GeoServerDefinition definition) throws ServiceRegistrationException {
        return this.retriever.registerService((ServiceDefinition)definition);
    }

    public String importHostFromToken(String sourceToken, String hostname) throws ServiceRegistrationException {
        return this.retriever.importHostFromToken(sourceToken, hostname);
    }
}

