/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.proxies;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Entity;
import org.gcube.common.clients.Call;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.spatial.data.clients.model.ConnectionDescriptor;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractProxy {
    private static final Logger log = LoggerFactory.getLogger(AbstractProxy.class);
    private ConnectionDescriptor conn;
    private String basePath = null;
    private Set<Class<?>> toRegisterClasses = new HashSet();
    private Set<Object> toRegisterObjects = new HashSet<Object>();

    protected AbstractProxy(ConnectionDescriptor conn) {
        this.conn = conn;
    }

    protected void register(Class<?> providerClass) {
        this.toRegisterClasses.add(providerClass);
    }

    protected void register(Object provider) {
        this.toRegisterObjects.add(provider);
    }

    protected GXWebTargetAdapterRequest resolve() throws UnsupportedEncodingException {
        GXWebTargetAdapterRequest toReturn = GXWebTargetAdapterRequest.newHTTPSRequest((String)this.conn.getEndpoint());
        if (this.basePath != null) {
            return toReturn.path(this.basePath);
        }
        return toReturn;
    }

    protected <T> T makeCall(Call<GXWebTargetAdapterRequest, T> call) throws Exception {
        try {
            return (T)call.call((Object)this.resolve());
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    protected void delete(String path) throws Exception {
        AbstractProxy.check(this.resolve().path(path).delete(), null);
    }

    protected void post(String path, Entity<?> entity) throws Exception {
        this.post(path, entity, null);
    }

    protected void post(String path, Object obj) {
    }

    protected <T> T post(final String path, final Entity<?> entity, final Class<T> returnClazz) throws Exception {
        return this.makeCall(new Call<GXWebTargetAdapterRequest, T>(){

            public T call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return AbstractProxy.check(endpoint.path(path).post(entity), returnClazz);
            }
        });
    }

    protected String get(String path) throws Exception {
        return (String)this.get(path, null);
    }

    protected <T> T get(final String path, final Class<T> clazz) throws Exception {
        return this.makeCall(new Call<GXWebTargetAdapterRequest, T>(){

            public T call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return AbstractProxy.check(endpoint.path(path).get(), clazz);
            }
        });
    }

    protected static <T> T check(GXInboundResponse resp, Class<T> clazz) throws RemoteException {
        try {
            log.debug("Checking Response {}", (Object)resp);
            if (resp.hasGXError()) {
                RemoteException e = new RemoteException("Error received from server");
                e.setRemoteMessage(resp.getMessage());
                e.setResponseHTTPCode(Integer.valueOf(resp.getHTTPCode()));
                e.setContent(resp.getStreamedContentAsString());
                throw e;
            }
            if (clazz == null) {
                return null;
            }
            if (clazz == String.class) {
                return (T)resp.getStreamedContentAsString();
            }
            return (T)resp.tryConvertStreamedContentFromJson(clazz);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("Unable to read  response from server.", (Throwable)e);
        }
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

