/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients.model.engine;

import org.gcube.spatial.data.clients.model.engine.ComparableVersion;

public class Range {
    private ComparableVersion upperBound = null;
    private ComparableVersion lowerBound = null;

    public void setLowerBound(ComparableVersion lowerBound) {
        if (this.upperBound != null && lowerBound.compareTo(this.upperBound) >= 0) {
            throw new IllegalArgumentException("Lower Bound (" + lowerBound.getCanonical() + ") must be below Upper Bound (" + this.upperBound.getCanonical() + ")");
        }
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(ComparableVersion upperBound) {
        if (this.lowerBound != null && upperBound.compareTo(this.lowerBound) <= 0) {
            throw new IllegalArgumentException("Upper Bound (" + upperBound.getCanonical() + ") must be above Lower Bound (" + this.lowerBound.getCanonical() + ")");
        }
        this.upperBound = upperBound;
    }

    public Range(String lower, String upper) {
        if (lower != null) {
            this.setLowerBound(new ComparableVersion(lower));
        }
        if (upper != null) {
            this.setUpperBound(new ComparableVersion(upper));
        }
    }

    public Range(ComparableVersion lower, ComparableVersion upper) {
        this.setLowerBound(lower);
        this.setUpperBound(upper);
    }

    public boolean supports(String target) {
        return this.supports(new ComparableVersion(target));
    }

    public boolean supports(ComparableVersion target) {
        if (target == null) {
            throw new IllegalArgumentException("Target version cannot be null.");
        }
        if (this.upperBound != null && target.compareTo(this.upperBound) > 0) {
            return false;
        }
        return this.lowerBound == null || target.compareTo(this.lowerBound) >= 0;
    }

    public String toString() {
        return "[" + (this.lowerBound != null ? this.lowerBound.getCanonical() : "...") + "," + (this.upperBound != null ? this.upperBound.getCanonical() : "...") + "]";
    }

    public ComparableVersion getUpperBound() {
        return this.upperBound;
    }

    public ComparableVersion getLowerBound() {
        return this.lowerBound;
    }

    public Range() {
    }
}

