/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.gcube.spatial.data.clients.SDIGenericPlugin;
import org.gcube.spatial.data.clients.model.ClientInfo;
import org.gcube.spatial.data.clients.model.ConnectionDescriptor;
import org.gcube.spatial.data.sdi.model.service.GeoServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIClientManager {
    private static final Logger log = LoggerFactory.getLogger(SDIClientManager.class);
    private List<SDIGenericPlugin> clients = new ArrayList<SDIGenericPlugin>();

    public SDIClientManager() {
        ServiceLoader.load(SDIGenericPlugin.class).forEach(c -> this.clients.add((SDIGenericPlugin)c));
        log.info("Loaded {}\u00a0clients ", (Object)this.clients.size());
        this.clients.forEach(c -> log.debug("Loaded " + c.getInfo()));
    }

    public SDIGenericPlugin get(String engine, String version) {
        log.info("Looking for clients [target : {}\u00a0{}\u00a0] ", (Object)engine, (Object)version);
        for (SDIGenericPlugin c : this.clients) {
            if (!c.getInfo().getSupportedEngine().getEngineUniqueString().equals(engine) || !c.getInfo().getSupportedEngine().getRange().supports(version)) continue;
            return c;
        }
        return null;
    }

    public SDIGenericPlugin get(ConnectionDescriptor conn) throws Exception {
        SDIGenericPlugin toReturn = this.get(conn.getEngineUniqueID(), conn.getVersion());
        if (toReturn == null) {
            throw new Exception("Unable to get client for " + conn.getEngineUniqueID() + " " + conn.getVersion());
        }
        return toReturn.at(conn);
    }

    public SDIGenericPlugin get(GeoServiceDescriptor service) throws Exception {
        return this.get(service.getConnection());
    }

    public List<ClientInfo> list() {
        ArrayList<ClientInfo> toReturn = new ArrayList<ClientInfo>();
        this.clients.forEach(c -> toReturn.add(c.getInfo()));
        return toReturn;
    }

    public List<ClientInfo> list(String engineId) {
        ArrayList<ClientInfo> toReturn = new ArrayList<ClientInfo>();
        this.clients.forEach(c -> {
            if (c.getInfo().getSupportedEngine().getEngineUniqueString().equals(engineId)) {
                toReturn.add(c.getInfo());
            }
        });
        return toReturn;
    }
}

