/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.metadata;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.spatial.data.sdi.model.ParameterType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TemplateDescriptor {
    @XmlElement(name="templateID")
    private String id;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="sourceURL")
    private String sourceURL;
    @XmlElement(name="parameters")
    private ArrayList<ParameterType> expectedParameters;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.expectedParameters != null && !this.expectedParameters.isEmpty()) {
            for (ParameterType param : this.expectedParameters) {
                result = 31 * result + param.hashCode();
            }
        }
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sourceURL == null ? 0 : this.sourceURL.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateDescriptor other = (TemplateDescriptor)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expectedParameters == null || this.expectedParameters.isEmpty()) {
            if (other.expectedParameters != null && !other.expectedParameters.isEmpty()) {
                return false;
            }
        } else {
            if (this.expectedParameters.size() != other.expectedParameters.size()) {
                return false;
            }
            if (!other.expectedParameters.containsAll(this.expectedParameters)) {
                return false;
            }
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.sourceURL == null ? other.sourceURL != null : !this.sourceURL.equals(other.sourceURL));
    }

    public void addParameter(String name, String value) {
        if (this.expectedParameters == null) {
            this.expectedParameters = new ArrayList();
        }
        this.expectedParameters.add(new ParameterType(name, value));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public ArrayList<ParameterType> getExpectedParameters() {
        return this.expectedParameters;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public void setExpectedParameters(ArrayList<ParameterType> expectedParameters) {
        this.expectedParameters = expectedParameters;
    }

    public TemplateDescriptor() {
    }

    @ConstructorProperties(value={"id", "name", "description", "sourceURL", "expectedParameters"})
    public TemplateDescriptor(String id, String name, String description, String sourceURL, ArrayList<ParameterType> expectedParameters) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.sourceURL = sourceURL;
        this.expectedParameters = expectedParameters;
    }

    public String toString() {
        return "TemplateDescriptor(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", sourceURL=" + this.getSourceURL() + ", expectedParameters=" + this.getExpectedParameters() + ")";
    }
}

