/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.is;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.gis.is.GeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfrastructureCrawler {
    static final Logger logger = LoggerFactory.getLogger(InfrastructureCrawler.class);

    public static List<GeoServerDescriptor> queryforGeoServer() {
        ArrayList<GeoServerDescriptor> toReturn = new ArrayList<GeoServerDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Gis'").addCondition("$resource/Profile/Platform/Name/text() eq 'GeoServer'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        List accesspoints = client.submit((Query)query);
        for (ServiceEndpoint.AccessPoint point : accesspoints) {
            try {
                toReturn.add(new GeoServerDescriptor(point.address(), point.username(), StringEncrypter.getEncrypter().decrypt(point.password(), new Key[0]), 0L));
            }
            catch (Exception e) {
                logger.warn("Unable to decript password for " + point.username() + " in access point " + point.address() + ", access to modify methods may fail");
            }
        }
        return toReturn;
    }
}

