package org.gcube.spatial.data.geonetwork.utils;

import org.gcube.common.encryption.StringEncrypter;
import org.gcube.spatial.data.geonetwork.model.faults.EncryptionException;

/**
 * Utility class for encryption and decryption operations.
 */
public class EncryptionUtils {

	/**
	 * Decrypts the given encrypted string.
	 * @param toDecrypt the string to decrypt
	 * @return the decrypted string
	 * @throws EncryptionException if decryption fails
	 */
	public static final String decrypt(String toDecrypt) throws EncryptionException{
		try{
			return StringEncrypter.getEncrypter().decrypt(toDecrypt);
		}catch(Exception e){
			throw new EncryptionException(e);
		}
		
	}
	
	/**
	 * Encrypts the given plain text string.
	 * @param toEncrypt the string to encrypt
	 * @return the encrypted string
	 * @throws EncryptionException if encryption fails
	 */
	public static final String encrypt(String toEncrypt) throws EncryptionException{		
		try{
			return StringEncrypter.getEncrypter().encrypt(toEncrypt);
		}catch(Exception e){
			throw new EncryptionException(e);
		}
	}
}
