package org.gcube.spatial.data.geonetwork.iso.tpl.extent;

/**
 * Abstract base class for geographic extents.
 */
public abstract class GeographicExtent {

	/**
	 * Enumeration of geographic extent types.
	 */
	protected enum Type{
		/** Bounding polygon type */
		BOUNDING_POLYGON,
		/** Bounding box type */
		BOUNDING_BOX,
		/** Description type */
		DESCRIPTION
	}
	
	/**
	 * Gets the type of this geographic extent.
	 * @return the extent type
	 */
	public abstract Type getType();
}
