package org.gcube.spatial.data.geonetwork.iso.tpl.extent;

import java.util.HashSet;

import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

@Getter
@Setter
/**
 * Represents geographic, temporal, and vertical extents.
 */
public class Extent {

	
	private String description;
	@NonNull
	private HashSet<GeographicExtent> geographicExtents=new HashSet<>();
	@NonNull
	private HashSet<TemporalExtent> temporalExtents=new HashSet<>();
	@NonNull
	private HashSet<VerticalExtent> verticalExtents=new HashSet<>();
	
	/**
	 * Adds a geographic extent.
	 * @param toAdd the geographic extent to add
	 */
	public void addGeographicExtent(GeographicExtent toAdd) {
		getGeographicExtents().add(toAdd);
	}
	
	/**
	 * Adds a temporal extent.
	 * @param toAdd the temporal extent to add
	 */
	public void addTemporalExtent(TemporalExtent toAdd) {
		getTemporalExtents().add(toAdd);
	}
	
	/**
	 * Adds a vertical extent.
	 * @param toAdd the vertical extent to add
	 */
	public void addVerticalExtent(VerticalExtent toAdd) {
		getVerticalExtents().add(toAdd);
	}
}
