package org.gcube.spatial.data.geonetwork.configuration;

/**
 * Manager for configuration instances.
 */
public class ConfigurationManager {

	private static Class<? extends Configuration> configClass=DefaultConfiguration.class;
	
	/**
	 * Gets a new instance of the configured Configuration class.
	 * @return a new Configuration instance
	 * @throws InstantiationException if the class cannot be instantiated
	 * @throws IllegalAccessException if the class or its constructor is not accessible
	 */
	public static synchronized Configuration get() throws InstantiationException, IllegalAccessException{		
		return configClass.newInstance();
	}
	
	/**
	 * Sets the Configuration class to be used.
	 * @param configuration the Configuration class
	 */
	public static void setConfiguration(Class<? extends Configuration>  configuration){configClass=configuration;}
	
}
