package org.gcube.spatial.data.geonetwork.iso.tpl.distribution;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.gcube.spatial.data.geonetwork.iso.Protocol;

import lombok.AllArgsConstructor;
import lombok.Data;

@Data
@AllArgsConstructor
/**
 * Represents distribution information for metadata.
 */
public class DistributionInfo {

	/**
	 * Enumeration of distribution info types.
	 */
	public static enum DistributionInfoType{
		/** GeoServer distribution type */
		GeoServer,
		/** Thredds distribution type */
		Thredds
	}
	
	private DistributionInfoType type;
	
	private Collection<Protocol> protocols;
	
	private Collection<OnlineResource> onlines;

	/**
	 * Constructs a new DistributionInfo with the specified type and online resources.
	 * @param type the distribution info type
	 * @param onlines the collection of online resources
	 */
	public DistributionInfo(DistributionInfoType type, Collection<OnlineResource> onlines) {
		super();
		this.type = type;
		this.onlines = onlines;
		Set<Protocol> protocols=new HashSet<Protocol>();
		for(OnlineResource res:onlines){
			protocols.add(res.getProtocol());
		}
		this.protocols=protocols;
	}
}
