package org.gcube.spatial.data.geonetwork.model;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * Represents an account with user credentials and type.
 */
@Getter
@Setter
@EqualsAndHashCode
@AllArgsConstructor
public class Account {

	/**
	 * Enumeration of account types.
	 */
	public static enum Type{
		/** CKAN account type */
		CKAN,
		/** Scope account type */
		SCOPE
	}
	
	private String user;
	private String password;
	private Type type;
	@Override
	public String toString() {
		return "Account [user=" + user + ", password=" + "***" + ", type="
				+ type + "]";
	}
	
	
}
