package org.gcube.spatial.data.geonetwork.iso.tpl.codelists;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
/**
 * Enumeration of geometric object types for spatial representation.
 */
public enum GeometricObjectType {

	/** Complex geometric object type */
	COMPLEX("complex","Complex"),
	/** Composite geometric object type */
	COMPOSITE("composite","Composite"),
	CURVE("curve","Curve"),
	POINT("point","Point"),
	SOLID("solid","Solid"),
	SURFACE("surface","Surface");
	
	
	private String id;
	private String label;
	
	
	/**
	 * Gets a GeometricObjectType by its ID.
	 * @param id the ID to search for
	 * @return the matching GeometricObjectType
	 * @throws IllegalArgumentException if no matching type is found
	 */
	public static GeometricObjectType getById(String id) {
		for(GeometricObjectType t:GeometricObjectType.values())
			if(t.id.equals(id)) return t;
		throw new IllegalArgumentException("No GeometricObjectType with id "+id);
	}
}
