/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl.spatial;

import lombok.NonNull;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.GeometricObjectType;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.TopologyLevel;
import org.gcube.spatial.data.geonetwork.iso.tpl.spatial.SpatialRepresentation;

public class VectorRepresentation
extends SpatialRepresentation {
    @NonNull
    private TopologyLevel topologyLevel = TopologyLevel.GEOMETRY_ONLY;
    private int geometricObjectCount = 0;
    @NonNull
    private GeometricObjectType geometricObjectType = GeometricObjectType.POINT;

    @Override
    public SpatialRepresentation.Type getType() {
        return SpatialRepresentation.Type.VECTOR;
    }

    @NonNull
    public TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public int getGeometricObjectCount() {
        return this.geometricObjectCount;
    }

    @NonNull
    public GeometricObjectType getGeometricObjectType() {
        return this.geometricObjectType;
    }

    public void setTopologyLevel(@NonNull TopologyLevel topologyLevel) {
        if (topologyLevel == null) {
            throw new NullPointerException("topologyLevel is marked non-null but is null");
        }
        this.topologyLevel = topologyLevel;
    }

    public void setGeometricObjectCount(int geometricObjectCount) {
        this.geometricObjectCount = geometricObjectCount;
    }

    public void setGeometricObjectType(@NonNull GeometricObjectType geometricObjectType) {
        if (geometricObjectType == null) {
            throw new NullPointerException("geometricObjectType is marked non-null but is null");
        }
        this.geometricObjectType = geometricObjectType;
    }

    public VectorRepresentation() {
    }

    public VectorRepresentation(@NonNull TopologyLevel topologyLevel, int geometricObjectCount, @NonNull GeometricObjectType geometricObjectType) {
        if (topologyLevel == null) {
            throw new NullPointerException("topologyLevel is marked non-null but is null");
        }
        if (geometricObjectType == null) {
            throw new NullPointerException("geometricObjectType is marked non-null but is null");
        }
        this.topologyLevel = topologyLevel;
        this.geometricObjectCount = geometricObjectCount;
        this.geometricObjectType = geometricObjectType;
    }
}

