/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl.keys;

import java.util.Date;
import java.util.HashSet;
import lombok.NonNull;

public class Thesaurus {
    public static final Thesaurus INSPIRE_THEMES = new Thesaurus("GEMET - INSPIRE themes, version 1.0", new Date(2008, 6, 1));
    @NonNull
    private String name;
    @NonNull
    private Date creationDate;
    private HashSet<String> codelist = new HashSet();

    static {
        Thesaurus.INSPIRE_THEMES.codelist.add("Addresses");
        Thesaurus.INSPIRE_THEMES.codelist.add("Administrative units");
        Thesaurus.INSPIRE_THEMES.codelist.add("Cadastral parcels");
        Thesaurus.INSPIRE_THEMES.codelist.add("Coordinate reference systems");
        Thesaurus.INSPIRE_THEMES.codelist.add("Geographical grid systems");
        Thesaurus.INSPIRE_THEMES.codelist.add("Geographical names");
        Thesaurus.INSPIRE_THEMES.codelist.add("Hydrography");
        Thesaurus.INSPIRE_THEMES.codelist.add("Protected sites");
        Thesaurus.INSPIRE_THEMES.codelist.add("Transport networks");
        Thesaurus.INSPIRE_THEMES.codelist.add("Elevation");
        Thesaurus.INSPIRE_THEMES.codelist.add("Geology");
        Thesaurus.INSPIRE_THEMES.codelist.add("Land cover");
        Thesaurus.INSPIRE_THEMES.codelist.add("Orthoimagery");
        Thesaurus.INSPIRE_THEMES.codelist.add("Agricultural and aquaculture facilities");
        Thesaurus.INSPIRE_THEMES.codelist.add("Area management / restriction / regulation zones & reporting units");
        Thesaurus.INSPIRE_THEMES.codelist.add("Atmospheric conditions");
        Thesaurus.INSPIRE_THEMES.codelist.add("Bio-geographical regions");
        Thesaurus.INSPIRE_THEMES.codelist.add("Buildings");
        Thesaurus.INSPIRE_THEMES.codelist.add("Energy Resources");
        Thesaurus.INSPIRE_THEMES.codelist.add("Environmental monitoring Facilities");
        Thesaurus.INSPIRE_THEMES.codelist.add("Habitats and biotopes");
        Thesaurus.INSPIRE_THEMES.codelist.add("Human health and safety");
        Thesaurus.INSPIRE_THEMES.codelist.add("Land use");
        Thesaurus.INSPIRE_THEMES.codelist.add("Meteorological geographical features");
        Thesaurus.INSPIRE_THEMES.codelist.add("Mineral Resources");
        Thesaurus.INSPIRE_THEMES.codelist.add("Natural risk zones");
        Thesaurus.INSPIRE_THEMES.codelist.add("Oceanographic geographical features");
        Thesaurus.INSPIRE_THEMES.codelist.add("Population distribution and demography");
        Thesaurus.INSPIRE_THEMES.codelist.add("Production and industrial facilities");
        Thesaurus.INSPIRE_THEMES.codelist.add("Sea regions");
        Thesaurus.INSPIRE_THEMES.codelist.add("Soil");
        Thesaurus.INSPIRE_THEMES.codelist.add("Species distribution");
        Thesaurus.INSPIRE_THEMES.codelist.add("Statistical units");
        Thesaurus.INSPIRE_THEMES.codelist.add("Utility and governmental services");
    }

    public HashSet<String> codelistValues() {
        return (HashSet)this.codelist.clone();
    }

    public boolean validate(String value) {
        if (this.codelist.isEmpty()) {
            return true;
        }
        return this.codelist.contains(value);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Thesaurus [name=" + this.name + "]";
    }

    public Thesaurus(@NonNull String name, @NonNull Date creationDate) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (creationDate == null) {
            throw new NullPointerException("creationDate is marked non-null but is null");
        }
        this.name = name;
        this.creationDate = creationDate;
    }

    public Thesaurus(@NonNull String name, @NonNull Date creationDate, HashSet<String> codelist) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (creationDate == null) {
            throw new NullPointerException("creationDate is marked non-null but is null");
        }
        this.name = name;
        this.creationDate = creationDate;
        this.codelist = codelist;
    }
}

