/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl.keys;

import java.util.HashSet;
import java.util.Set;
import org.gcube.spatial.data.geonetwork.iso.tpl.InvalidValueException;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.KeywordType;
import org.gcube.spatial.data.geonetwork.iso.tpl.keys.Thesaurus;

public class KeywordSet {
    private KeywordType type;
    private Set<String> values = new HashSet<String>();
    private Thesaurus thesaurus;

    public void validate() throws InvalidValueException {
        if (this.values.isEmpty()) {
            throw new InvalidValueException("KeywordSet cannot be empty. Thesaurus is : " + this.thesaurus);
        }
        if (this.thesaurus != null) {
            for (String v : this.values) {
                if (this.thesaurus.validate(v)) continue;
                throw new InvalidValueException("Invalid value " + v + " for Thesaurus : " + this.thesaurus);
            }
        }
    }

    public KeywordSet(KeywordType type, Thesaurus thesaurus) {
        this.type = type;
        this.thesaurus = thesaurus;
    }

    public void addKeyword(String toAdd) {
        this.values.add(toAdd);
    }

    public KeywordSet(Set<String> values) {
        this.values = values;
    }

    public KeywordType getType() {
        return this.type;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public Thesaurus getThesaurus() {
        return this.thesaurus;
    }

    public KeywordSet() {
    }

    public KeywordSet(KeywordType type, Set<String> values, Thesaurus thesaurus) {
        this.type = type;
        this.values = values;
        this.thesaurus = thesaurus;
    }
}

