/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl.extent;

import lombok.NonNull;
import org.gcube.spatial.data.geonetwork.iso.tpl.extent.GeographicExtent;

public class BoundingBox
extends GeographicExtent {
    public static final BoundingBox WORLD_EXTENT = new BoundingBox(90.0, -90.0, 180.0, -180.0);
    @NonNull
    private Double north;
    @NonNull
    private Double south;
    @NonNull
    private Double west;
    @NonNull
    private Double east;

    public double[] toArray() {
        return new double[]{this.east, this.south, this.west, this.north};
    }

    public String toString() {
        return this.east + "," + this.south + "," + this.west + "," + this.north;
    }

    @Override
    public GeographicExtent.Type getType() {
        return GeographicExtent.Type.BOUNDING_BOX;
    }

    @NonNull
    public Double getNorth() {
        return this.north;
    }

    @NonNull
    public Double getSouth() {
        return this.south;
    }

    @NonNull
    public Double getWest() {
        return this.west;
    }

    @NonNull
    public Double getEast() {
        return this.east;
    }

    public void setNorth(@NonNull Double north) {
        if (north == null) {
            throw new NullPointerException("north is marked non-null but is null");
        }
        this.north = north;
    }

    public void setSouth(@NonNull Double south) {
        if (south == null) {
            throw new NullPointerException("south is marked non-null but is null");
        }
        this.south = south;
    }

    public void setWest(@NonNull Double west) {
        if (west == null) {
            throw new NullPointerException("west is marked non-null but is null");
        }
        this.west = west;
    }

    public void setEast(@NonNull Double east) {
        if (east == null) {
            throw new NullPointerException("east is marked non-null but is null");
        }
        this.east = east;
    }

    public BoundingBox(@NonNull Double north, @NonNull Double south, @NonNull Double west, @NonNull Double east) {
        if (north == null) {
            throw new NullPointerException("north is marked non-null but is null");
        }
        if (south == null) {
            throw new NullPointerException("south is marked non-null but is null");
        }
        if (west == null) {
            throw new NullPointerException("west is marked non-null but is null");
        }
        if (east == null) {
            throw new NullPointerException("east is marked non-null but is null");
        }
        this.north = north;
        this.south = south;
        this.west = west;
        this.east = east;
    }
}

