/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl.codelists;

public enum TopologyLevel {
    GEOMETRY_ONLY("geometryOnly", "Geometry only"),
    TOPOLOGY_1D("topology1D", "Topology 1D"),
    PLANAR_GRAPH("planarGraph", "Planar graph"),
    FULL_PLANAR_GRAPH("fullPlanarGraph", "Full planar graph"),
    SURFACE_GRAPH("surfaceGraph", "Surface graph"),
    FULL_SURFACE_GRAPH("fullSurfaceGraph", "Full surface graph"),
    TOPOLOGY_3D("topology3D", "Topology 3D"),
    ABSTRACT("abstract", "Abstract");

    private String id;
    private String label;

    public static TopologyLevel getById(String id) {
        TopologyLevel[] topologyLevelArray = TopologyLevel.values();
        int n = topologyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            TopologyLevel t = topologyLevelArray[n2];
            if (t.id.equals(id)) {
                return t;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No TopologyLevel with id " + id);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    private TopologyLevel(String id, String label) {
        this.id = id;
        this.label = label;
    }
}

