/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gcube.spatial.data.geonetwork.iso.tpl.MetadataDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISOMetadataByTemplate {
    private static final Logger log = LoggerFactory.getLogger(ISOMetadataByTemplate.class);
    private static List<TemplateLoader> loaders = new ArrayList<TemplateLoader>();
    private static Configuration cfg;

    static {
        try {
            cfg = new Configuration(Configuration.VERSION_2_3_25);
            cfg.setDefaultEncoding("UTF-8");
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setLogTemplateExceptions(false);
            loaders.add((TemplateLoader)new ClassTemplateLoader(ISOMetadataByTemplate.class, "/xmlTemplates"));
            ISOMetadataByTemplate.reload();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final void reload() {
        MultiTemplateLoader loader = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()]));
        cfg.setTemplateLoader((TemplateLoader)loader);
    }

    public static final File createXML(MetadataDescriptor desc) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        return ISOMetadataByTemplate.custom(desc, "BaseTemplate.ftlx");
    }

    public static final File custom(Object descriptor, String template) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        File file;
        block3: {
            OutputStreamWriter out = null;
            try {
                Template temp = cfg.getTemplate(template);
                File output = File.createTempFile("ISO_", ".xml");
                out = new OutputStreamWriter(new FileOutputStream(output));
                temp.process(descriptor, (Writer)out);
                file = output;
                if (out == null) break block3;
            }
            catch (Throwable throwable) {
                if (out != null) {
                    IOUtils.closeQuietly(out);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out);
        }
        return file;
    }

    public static final void registerTemplateFolder(File baseDir) throws IOException {
        loaders.add((TemplateLoader)new FileTemplateLoader(baseDir));
        ISOMetadataByTemplate.reload();
    }
}

