/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.spatial.data.geonetwork.iso.EnvironmentConfiguration;
import org.gcube.spatial.data.geonetwork.iso.GcubeISOMetadata;
import org.gcube.spatial.data.geonetwork.iso.Protocol;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.gcube.spatial.data.geonetwork.iso.tpl.extent.BoundingBox;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultAddress;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultCitationDate;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.metadata.iso.constraint.DefaultLegalConstraints;
import org.geotoolkit.metadata.iso.distribution.DefaultDigitalTransferOptions;
import org.geotoolkit.metadata.iso.distribution.DefaultDistribution;
import org.geotoolkit.metadata.iso.distribution.DefaultFormat;
import org.geotoolkit.metadata.iso.identification.DefaultBrowseGraphic;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.geotoolkit.metadata.iso.identification.DefaultKeywords;
import org.geotoolkit.metadata.iso.identification.DefaultResolution;
import org.geotoolkit.metadata.iso.maintenance.DefaultMaintenanceInformation;
import org.geotoolkit.metadata.iso.spatial.DefaultGeometricObjects;
import org.geotoolkit.metadata.iso.spatial.DefaultVectorSpatialRepresentation;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.util.InternationalString;

public class ISOMetadataFactory {
    public static Metadata generateMeta(GcubeISOMetadata gcubeMeta) throws URISyntaxException {
        String metadataIdentifier = UUID.randomUUID().toString();
        DefaultResponsibleParty author = new DefaultResponsibleParty();
        author.setIndividualName(gcubeMeta.getUser());
        author.setOrganisationName((InternationalString)new DefaultInternationalString(gcubeMeta.getConfig().getProjectName()));
        author.setRole(Role.AUTHOR);
        DefaultResponsibleParty distributor = new DefaultResponsibleParty();
        distributor.setIndividualName(gcubeMeta.getConfig().getDistributorIndividualName());
        distributor.setOrganisationName((InternationalString)new DefaultInternationalString(gcubeMeta.getConfig().getProjectName()));
        distributor.setRole(Role.DISTRIBUTOR);
        DefaultContact distributorContact = new DefaultContact();
        DefaultAddress distributorAddress = new DefaultAddress();
        distributorAddress.getElectronicMailAddresses().add(gcubeMeta.getConfig().getDistributorEMail());
        distributorContact.setAddress((Address)distributorAddress);
        DefaultOnlineResource distributorOnline = new DefaultOnlineResource(new URI(gcubeMeta.getConfig().getDistributorSite()));
        distributorOnline.setName(String.valueOf(gcubeMeta.getConfig().getProjectName()) + " site.");
        distributorOnline.setProtocol(gcubeMeta.getConfig().getHttpProtocolDeclaration());
        distributorContact.setOnlineResource((OnlineResource)distributorOnline);
        distributor.setContactInfo((Contact)distributorContact);
        DefaultResponsibleParty provider = new DefaultResponsibleParty();
        provider.setIndividualName(gcubeMeta.getConfig().getProviderIndividualName());
        provider.setOrganisationName((InternationalString)new DefaultInternationalString(gcubeMeta.getConfig().getProjectName()));
        provider.setRole(Role.RESOURCE_PROVIDER);
        DefaultContact providerContact = new DefaultContact();
        DefaultAddress providerAddress = new DefaultAddress();
        providerAddress.getElectronicMailAddresses().add(gcubeMeta.getConfig().getProviderEMail());
        providerContact.setAddress((Address)providerAddress);
        DefaultOnlineResource providerOnline = new DefaultOnlineResource(new URI(gcubeMeta.getConfig().getProviderSite()));
        providerOnline.setName(String.valueOf(gcubeMeta.getConfig().getProjectName()) + " site.");
        providerOnline.setProtocol(gcubeMeta.getConfig().getHttpProtocolDeclaration());
        providerContact.setOnlineResource((OnlineResource)providerOnline);
        provider.setContactInfo((Contact)providerContact);
        DefaultDataIdentification ident = new DefaultDataIdentification();
        ident.getLanguages().add(Locale.ENGLISH);
        DefaultCitation citation = new DefaultCitation();
        citation.setTitle((InternationalString)new DefaultInternationalString(gcubeMeta.getTitle()));
        citation.getDates().add(new DefaultCitationDate(gcubeMeta.getCreationDate(), DateType.CREATION));
        citation.getPresentationForms().add(gcubeMeta.getPresentationForm());
        citation.setIdentifiers(Collections.singleton(new DefaultIdentifier(metadataIdentifier)));
        ident.setCitation((Citation)citation);
        ident.setAbstract((InternationalString)new DefaultInternationalString(gcubeMeta.getAbstractField()));
        ident.setPurpose((InternationalString)new DefaultInternationalString(gcubeMeta.getPurpose()));
        ident.getCredits().addAll(gcubeMeta.getCredits());
        ident.getResourceMaintenances().add(new DefaultMaintenanceInformation(MaintenanceFrequency.AS_NEEDED));
        for (Map.Entry<Thesaurus, HashSet<String>> entry : gcubeMeta.getDescriptiveKeywords().entrySet()) {
            DefaultKeywords keywords = new DefaultKeywords();
            for (String key : entry.getValue()) {
                keywords.getKeywords().add(new DefaultInternationalString(key));
            }
            keywords.setType(entry.getKey().getType());
            DefaultCitation thesaurus = new DefaultCitation();
            thesaurus.setTitle((InternationalString)new DefaultInternationalString(entry.getKey().getTitle()));
            thesaurus.getDates().add(new DefaultCitationDate(entry.getKey().getCitationDate(), DateType.CREATION));
            if (entry.getKey().isAuthored()) {
                thesaurus.setOtherCitationDetails((InternationalString)new DefaultInternationalString(entry.getKey().getCitationDescription()));
                DefaultResponsibleParty thesaurusParty = new DefaultResponsibleParty();
                thesaurusParty.setIndividualName(entry.getKey().getTitle());
                thesaurusParty.setOrganisationName((InternationalString)new DefaultInternationalString(entry.getKey().getCitationOrganization()));
                thesaurusParty.setRole(Role.POINT_OF_CONTACT);
                DefaultContact thesaurusContact = new DefaultContact();
                thesaurusContact.setOnlineResource((OnlineResource)ISOMetadataFactory.getOnline(entry.getKey().getTitle(), entry.getKey().getCitationUri()));
                thesaurusParty.setContactInfo((Contact)thesaurusContact);
                thesaurus.getCitedResponsibleParties().add(thesaurusParty);
            }
            keywords.setThesaurusName((Citation)thesaurus);
            ident.getDescriptiveKeywords().add(keywords);
        }
        ident.getTopicCategories().addAll(gcubeMeta.getTopicCategories());
        ident.getExtents().add(gcubeMeta.getExtent());
        DefaultGeometricObjects geoObjs = new DefaultGeometricObjects();
        geoObjs.setGeometricObjectType(gcubeMeta.getGeometricObjectType());
        geoObjs.setGeometricObjectCount(Integer.valueOf(gcubeMeta.getGeometryCount()));
        DefaultVectorSpatialRepresentation spatial = new DefaultVectorSpatialRepresentation();
        spatial.setTopologyLevel(gcubeMeta.getTopologyLevel());
        spatial.getGeometricObjects().add(geoObjs);
        DefaultResolution layerResolution = new DefaultResolution();
        layerResolution.setDistance(Double.valueOf(gcubeMeta.getResolution()));
        ident.getSpatialResolutions().add(layerResolution);
        for (String uri : gcubeMeta.getGraphicOverviewsURI()) {
            DefaultBrowseGraphic graph = new DefaultBrowseGraphic(new URI(uri));
            ident.getGraphicOverviews().add(graph);
        }
        DefaultLegalConstraints constraints = new DefaultLegalConstraints();
        constraints.getUseLimitations().add(new DefaultInternationalString(gcubeMeta.getConfig().getLicense()));
        constraints.getAccessConstraints().add(Restriction.LICENSE);
        constraints.getUseConstraints().add(Restriction.LICENSE);
        constraints.getOtherConstraints().add(new DefaultInternationalString("other restrictions"));
        DefaultMetadata meta = new DefaultMetadata((ResponsibleParty)author, new Date(System.currentTimeMillis()), (Identification)ident);
        meta.setCharacterSet(CharacterSet.UTF_8);
        meta.getContacts().add(distributor);
        meta.getContacts().add(provider);
        meta.getSpatialRepresentationInfo().add(spatial);
        meta.getMetadataConstraints().add(constraints);
        meta.setLanguage(Locale.ENGLISH);
        meta.getHierarchyLevels().add(ScopeCode.DATASET);
        meta.setFileIdentifier(metadataIdentifier);
        return meta;
    }

    public static DefaultDistribution getDistributionByLayer(String layerName, String geoserverUrl, String style, String bbox, EnvironmentConfiguration config) throws URISyntaxException {
        DefaultDistribution distribution = new DefaultDistribution();
        distribution.getTransferOptions().add(ISOMetadataFactory.getTransferOptionsByLayer(layerName, geoserverUrl, style, bbox, config));
        DefaultFormat format1 = new DefaultFormat();
        format1.setName((InternationalString)new DefaultInternationalString(Protocol.WMS.getName()));
        format1.setVersion((InternationalString)new DefaultInternationalString(Protocol.WMS.getVersion()));
        DefaultFormat format2 = new DefaultFormat();
        format2.setName((InternationalString)new DefaultInternationalString(Protocol.WFS.getName()));
        format2.setVersion((InternationalString)new DefaultInternationalString(Protocol.WFS.getVersion()));
        DefaultFormat format3 = new DefaultFormat();
        format3.setName((InternationalString)new DefaultInternationalString(Protocol.WCS.getName()));
        format3.setVersion((InternationalString)new DefaultInternationalString(Protocol.WCS.getVersion()));
        DefaultFormat format4 = new DefaultFormat();
        format4.setName((InternationalString)new DefaultInternationalString(Protocol.HTTP.getName()));
        format4.setVersion((InternationalString)new DefaultInternationalString(Protocol.HTTP.getVersion()));
        distribution.setDistributionFormats(new ArrayList<DefaultFormat>(Arrays.asList(format1, format2, format3, format4)));
        return distribution;
    }

    public static DefaultDigitalTransferOptions getTransferOptionsByLayer(String layerName, String geoserverUrl, String style, String bbox, EnvironmentConfiguration config) throws URISyntaxException {
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        return transferOptions;
    }

    public static DefaultOnlineResource getOnline(String name, String uriString) throws URISyntaxException {
        return ISOMetadataFactory.getOnline(name, Protocol.getByURI(uriString).getDeclaration(), String.valueOf(Protocol.getByURI(uriString).getName()) + " link to resource.", uriString);
    }

    public static DefaultOnlineResource getOnline(String name, String protocolDeclaration, String uriString) throws URISyntaxException {
        return ISOMetadataFactory.getOnline(name, protocolDeclaration, String.valueOf(Protocol.getByURI(uriString).getName()) + " link to resource.", uriString);
    }

    public static DefaultOnlineResource getOnline(String name, String protocol, String description, String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        DefaultOnlineResource resource = new DefaultOnlineResource(uri);
        resource.setName(name);
        resource.setProtocol(protocol);
        resource.setDescription((InternationalString)new DefaultInternationalString(description));
        return resource;
    }

    public static String getWmsUrl(String geoServerUrl, String layerName, String workspace, String style, String bbox, String CRS) {
        if (bbox == null) {
            bbox = BoundingBox.WORLD_EXTENT.toString();
        }
        return String.valueOf(geoServerUrl) + "/wms?service=wms&version=1.1.0" + "&request=GetMap&layers=" + layerName + "&styles=" + (style == null ? "" : style) + "&bbox=" + bbox + "&width=676&height=330" + "&srs=EPSG:4326&crs=" + CRS + "&format=application/openlayers";
    }

    public static String getWfsUrl(String geoServerUrl, String layerName, String workspace) {
        return String.valueOf(geoServerUrl) + "/ows?service=wfs&version=1.0.0" + "&request=GetFeature&typeName=" + workspace + ":" + layerName + "&format=json";
    }

    public static String getWcsUrl(String geoServerUrl, String layerName, String workspace, String bbox) {
        if (bbox == null) {
            bbox = BoundingBox.WORLD_EXTENT.toString();
        }
        return String.valueOf(geoServerUrl) + "/wcs?service=wcs&version=1.0.0" + "&request=GetCoverage&coverage=" + layerName + "&CRS=EPSG:4326" + "&bbox=" + bbox + "&width=676&height=330&format=geotiff";
    }

    public static String getGisLinkByUUID(String uuid) throws UriResolverMapException, IllegalArgumentException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scope", ScopeUtils.getCurrentScope());
        params.put("gis-UUID", uuid);
        UriResolverManager resolver = new UriResolverManager("GIS");
        return resolver.getLink(params, true);
    }
}

