/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.spatial.data.geonetwork.iso.EnvironmentConfiguration;
import org.gcube.spatial.data.geonetwork.iso.ISOMetadataFactory;
import org.gcube.spatial.data.geonetwork.iso.MissingInformationException;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.gcube.spatial.data.geonetwork.iso.tpl.ISOMetadataByTemplate;
import org.gcube.spatial.data.geonetwork.iso.tpl.MetadataDescriptor;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.GeometricObjectType;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.KeywordType;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.ResponsiblePartyRole;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.RestrictionCode;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.TopicCategory;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.TopologyLevel;
import org.gcube.spatial.data.geonetwork.iso.tpl.constraints.LegalConstraints;
import org.gcube.spatial.data.geonetwork.iso.tpl.constraints.ResourceConstraints;
import org.gcube.spatial.data.geonetwork.iso.tpl.distribution.DistributionInfo;
import org.gcube.spatial.data.geonetwork.iso.tpl.distribution.OnlineResource;
import org.gcube.spatial.data.geonetwork.iso.tpl.extent.BoundingBox;
import org.gcube.spatial.data.geonetwork.iso.tpl.keys.KeywordSet;
import org.gcube.spatial.data.geonetwork.iso.tpl.parties.Contact;
import org.gcube.spatial.data.geonetwork.iso.tpl.parties.ResponsibleParty;
import org.gcube.spatial.data.geonetwork.iso.tpl.spatial.VectorRepresentation;
import org.gcube.spatial.data.geonetwork.utils.StringValidator;
import org.geotoolkit.metadata.iso.extent.DefaultExtent;
import org.geotoolkit.xml.XML;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.PresentationForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GcubeISOMetadata {
    private static final Logger log = LoggerFactory.getLogger(GcubeISOMetadata.class);
    private EnvironmentConfiguration config;
    private MetadataDescriptor descriptor;
    @NonNull
    private String user;
    @NonNull
    private String lineageStatement;
    @NonNull
    private String title;
    @NonNull
    private Date creationDate;
    @NonNull
    private PresentationForm presentationForm;
    @NonNull
    private String abstractField;
    @NonNull
    private String purpose;
    @NonNull
    private String UUIDIdentifier;
    private ArrayList<String> credits = new ArrayList();
    private HashMap<Thesaurus, HashSet<String>> descriptiveKeywords = new HashMap();
    private ArrayList<org.opengis.metadata.identification.TopicCategory> topicCategories = new ArrayList();
    private DefaultExtent extent = (DefaultExtent)DefaultExtent.WORLD;
    private org.opengis.metadata.spatial.GeometricObjectType geometricObjectType = org.opengis.metadata.spatial.GeometricObjectType.SURFACE;
    private int geometryCount = 0;
    private org.opengis.metadata.spatial.TopologyLevel topologyLevel = org.opengis.metadata.spatial.TopologyLevel.GEOMETRY_ONLY;
    private double resolution = 0.5;
    @NonNull
    private String inspireTheme;
    private ArrayList<String> graphicOverviewsURI = new ArrayList();
    private DistributionInfo distributionInfo;
    private ResourceConstraints contraints = new ResourceConstraints("I'll tell you when", new LegalConstraints(RestrictionCode.LICENSE, "CC-BY-SA"), new LegalConstraints(RestrictionCode.LICENSE, "CC-BY-SA"));

    @Deprecated
    public GcubeISOMetadata() throws Exception {
        this.config = EnvironmentConfiguration.getConfiguration();
        this.credits.add(this.config.getProjectCitation());
        this.addKeyword(this.config.getProjectName(), this.config.getThesauri().get("General"));
    }

    protected void checkConstraints() throws MissingInformationException {
        if (!StringValidator.isValidateString(this.getUser())) {
            throw new MissingInformationException("Field user is mandatory");
        }
        if (!StringValidator.isValidateString(this.getTitle())) {
            throw new MissingInformationException("Field title is mandatory");
        }
        if (this.getCreationDate() == null) {
            throw new MissingInformationException("Field creationDate is mandatory");
        }
        if (this.getPresentationForm() == null) {
            throw new MissingInformationException("Field presentationForm is mandatory");
        }
        if (!StringValidator.isValidateString(this.getAbstractField())) {
            throw new MissingInformationException("Field abstractField is mandatory");
        }
        if (!StringValidator.isValidateString(this.getPurpose())) {
            throw new MissingInformationException("Field purpose is mandatory");
        }
        if (this.getTopicCategories().size() == 0) {
            throw new MissingInformationException("At least one topic category is required");
        }
        if (this.getExtent() == null) {
            throw new MissingInformationException("Field Extent is mandatory");
        }
        if (this.getGeometricObjectType() == null) {
            throw new MissingInformationException("Field geometricObjectType is mandatory");
        }
        if (this.getTopologyLevel() == null) {
            throw new MissingInformationException("Field topology level is mandatory");
        }
        if (this.getCredits().size() == 0) {
            throw new MissingInformationException("At least one credits is needed");
        }
        if (this.getDescriptiveKeywords().isEmpty()) {
            throw new MissingInformationException("Missing Descriptive keywords");
        }
    }

    public File getMetadataFile() throws Exception {
        this.checkConstraints();
        MetadataDescriptor desc = new MetadataDescriptor();
        ArrayList<ResponsibleParty> respParties = new ArrayList<ResponsibleParty>();
        AuthorizationEntry authEntry = Constants.authorizationService().get(SecurityTokenProvider.instance.get());
        respParties.add(new ResponsibleParty(this.getUser(), "gCube Context " + authEntry.getContext(), ResponsiblePartyRole.AUTHOR));
        respParties.add(new ResponsibleParty(this.getUser(), "gCube Context " + authEntry.getContext(), ResponsiblePartyRole.POINT_OF_CONTACT));
        respParties.add(new ResponsibleParty(this.config.getProjectName(), this.config.getProjectName(), ResponsiblePartyRole.ORIGINATOR));
        respParties.add(new ResponsibleParty(this.config.getDistributorIndividualName(), this.config.getDistributorOrganisationName(), ResponsiblePartyRole.DISTRIBUTOR, new Contact(this.config.getDistributorEMail(), this.config.getDistributorSite())));
        respParties.add(new ResponsibleParty(this.config.getProviderIndividualName(), this.config.getProviderOrganisationName(), ResponsiblePartyRole.RESOURCE_PROVIDER, new Contact(this.config.getProviderEMail(), this.config.getProviderSite())));
        desc.setResponsibleParties(respParties);
        desc.setTitle(this.getTitle());
        desc.setCreationTime(this.getCreationDate());
        desc.setAbstractField(this.getAbstractField());
        for (String credit : this.getCredits()) {
            desc.addCredits(credit);
        }
        VectorRepresentation representation = new VectorRepresentation(TopologyLevel.getById(this.getTopologyLevel().identifier()), this.getGeometryCount(), GeometricObjectType.getById(this.getGeometricObjectType().identifier()));
        desc.setSpatialRepresentation(representation);
        KeywordSet keySet = new KeywordSet();
        for (Map.Entry<Thesaurus, HashSet<String>> entry : this.getDescriptiveKeywords().entrySet()) {
            for (String s : entry.getValue()) {
                keySet.addKeyword(s);
            }
        }
        desc.addKeywordSet(keySet);
        desc.addKeywordSet(new KeywordSet(KeywordType.THEME, Collections.singleton(this.getInspireTheme()), org.gcube.spatial.data.geonetwork.iso.tpl.keys.Thesaurus.INSPIRE_THEMES));
        desc.setPublicationTime(desc.getCreationTime());
        desc.setPurpose(this.getPurpose());
        desc.setUUIDIdentifier(this.UUIDIdentifier != null ? this.UUIDIdentifier : UUID.randomUUID().toString());
        desc.getExtent().addGeographicExtent(BoundingBox.WORLD_EXTENT);
        desc.setSpatialResolution(this.getResolution());
        for (org.opengis.metadata.identification.TopicCategory cat : this.getTopicCategories()) {
            desc.addTopicCategory(TopicCategory.getById(cat.identifier()));
        }
        try {
            desc.setDistributionInfo(this.distributionInfo);
        }
        catch (NullPointerException e) {
            log.warn("*******Distribution info is null!!!****** This should happen only in legacy approaches.");
        }
        desc.setLineageStatement(this.getLineageStatement());
        desc.setConstraints(this.getContraints());
        return ISOMetadataByTemplate.createXML(desc);
    }

    public void setGeoServerDistributionInfo(String geoServerUrl, String layerName, String workspace, String style, String CRS) throws UriResolverMapException, IllegalArgumentException {
        ArrayList<OnlineResource> resources = new ArrayList<OnlineResource>();
        String bbox = BoundingBox.WORLD_EXTENT.toString();
        String wmsUrl = ISOMetadataFactory.getWmsUrl(geoServerUrl, layerName, workspace, style, bbox, CRS);
        String wcsUrl = ISOMetadataFactory.getWcsUrl(geoServerUrl, layerName, workspace, bbox);
        String wfsUrl = ISOMetadataFactory.getWfsUrl(geoServerUrl, layerName, workspace);
        String gisViewerUrl = ISOMetadataFactory.getGisLinkByUUID(this.UUIDIdentifier);
        resources.add(new OnlineResource(wmsUrl, "WMS Link"));
        resources.add(new OnlineResource(wcsUrl, "WCS Link"));
        resources.add(new OnlineResource(wfsUrl, "WFS Link"));
        resources.add(new OnlineResource(gisViewerUrl, "GISViewer Link"));
        this.distributionInfo = new DistributionInfo(DistributionInfo.DistributionInfoType.GeoServer, resources);
    }

    @Deprecated
    public Metadata getMetadata() throws Exception {
        return (Metadata)XML.unmarshal((File)this.getMetadataFile());
    }

    public ArrayList<String> getCredits() {
        return (ArrayList)this.credits.clone();
    }

    public void addCredits(String toAddCredits) {
        this.credits.add(toAddCredits);
    }

    public HashMap<Thesaurus, HashSet<String>> getDescriptiveKeywords() {
        return (HashMap)this.descriptiveKeywords.clone();
    }

    public synchronized void addKeyword(String keyword, Thesaurus thesaurus) {
        if (!this.descriptiveKeywords.containsKey(thesaurus)) {
            this.descriptiveKeywords.put(thesaurus, new HashSet());
        }
        this.descriptiveKeywords.get(thesaurus).add(keyword);
    }

    public ArrayList<org.opengis.metadata.identification.TopicCategory> getTopicCategories() {
        return (ArrayList)this.topicCategories.clone();
    }

    public void addTopicCategory(org.opengis.metadata.identification.TopicCategory toAdd) {
        this.topicCategories.add(toAdd);
    }

    public ArrayList<String> getGraphicOverviewsURI() {
        return (ArrayList)this.graphicOverviewsURI.clone();
    }

    public void addGraphicOverview(String uri) {
        this.graphicOverviewsURI.add(uri);
    }

    public EnvironmentConfiguration getConfig() {
        return this.config;
    }

    public MetadataDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NonNull
    public String getUser() {
        return this.user;
    }

    @NonNull
    public String getLineageStatement() {
        return this.lineageStatement;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public Date getCreationDate() {
        return this.creationDate;
    }

    @NonNull
    public PresentationForm getPresentationForm() {
        return this.presentationForm;
    }

    @NonNull
    public String getAbstractField() {
        return this.abstractField;
    }

    @NonNull
    public String getPurpose() {
        return this.purpose;
    }

    @NonNull
    public String getUUIDIdentifier() {
        return this.UUIDIdentifier;
    }

    public DefaultExtent getExtent() {
        return this.extent;
    }

    public org.opengis.metadata.spatial.GeometricObjectType getGeometricObjectType() {
        return this.geometricObjectType;
    }

    public int getGeometryCount() {
        return this.geometryCount;
    }

    public org.opengis.metadata.spatial.TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public double getResolution() {
        return this.resolution;
    }

    @NonNull
    public String getInspireTheme() {
        return this.inspireTheme;
    }

    public DistributionInfo getDistributionInfo() {
        return this.distributionInfo;
    }

    public ResourceConstraints getContraints() {
        return this.contraints;
    }

    public void setConfig(EnvironmentConfiguration config) {
        this.config = config;
    }

    public void setDescriptor(MetadataDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setUser(@NonNull String user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.user = user;
    }

    public void setLineageStatement(@NonNull String lineageStatement) {
        if (lineageStatement == null) {
            throw new NullPointerException("lineageStatement is marked non-null but is null");
        }
        this.lineageStatement = lineageStatement;
    }

    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    public void setCreationDate(@NonNull Date creationDate) {
        if (creationDate == null) {
            throw new NullPointerException("creationDate is marked non-null but is null");
        }
        this.creationDate = creationDate;
    }

    public void setPresentationForm(@NonNull PresentationForm presentationForm) {
        if (presentationForm == null) {
            throw new NullPointerException("presentationForm is marked non-null but is null");
        }
        this.presentationForm = presentationForm;
    }

    public void setAbstractField(@NonNull String abstractField) {
        if (abstractField == null) {
            throw new NullPointerException("abstractField is marked non-null but is null");
        }
        this.abstractField = abstractField;
    }

    public void setPurpose(@NonNull String purpose) {
        if (purpose == null) {
            throw new NullPointerException("purpose is marked non-null but is null");
        }
        this.purpose = purpose;
    }

    public void setUUIDIdentifier(@NonNull String UUIDIdentifier) {
        if (UUIDIdentifier == null) {
            throw new NullPointerException("UUIDIdentifier is marked non-null but is null");
        }
        this.UUIDIdentifier = UUIDIdentifier;
    }

    public void setCredits(ArrayList<String> credits) {
        this.credits = credits;
    }

    public void setDescriptiveKeywords(HashMap<Thesaurus, HashSet<String>> descriptiveKeywords) {
        this.descriptiveKeywords = descriptiveKeywords;
    }

    public void setTopicCategories(ArrayList<org.opengis.metadata.identification.TopicCategory> topicCategories) {
        this.topicCategories = topicCategories;
    }

    public void setExtent(DefaultExtent extent) {
        this.extent = extent;
    }

    public void setGeometricObjectType(org.opengis.metadata.spatial.GeometricObjectType geometricObjectType) {
        this.geometricObjectType = geometricObjectType;
    }

    public void setGeometryCount(int geometryCount) {
        this.geometryCount = geometryCount;
    }

    public void setTopologyLevel(org.opengis.metadata.spatial.TopologyLevel topologyLevel) {
        this.topologyLevel = topologyLevel;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public void setInspireTheme(@NonNull String inspireTheme) {
        if (inspireTheme == null) {
            throw new NullPointerException("inspireTheme is marked non-null but is null");
        }
        this.inspireTheme = inspireTheme;
    }

    public void setGraphicOverviewsURI(ArrayList<String> graphicOverviewsURI) {
        this.graphicOverviewsURI = graphicOverviewsURI;
    }

    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    public void setContraints(ResourceConstraints contraints) {
        this.contraints = contraints;
    }

    public GcubeISOMetadata(@NonNull String user, @NonNull String lineageStatement, @NonNull String title, @NonNull Date creationDate, @NonNull PresentationForm presentationForm, @NonNull String abstractField, @NonNull String purpose, @NonNull String UUIDIdentifier, @NonNull String inspireTheme) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (lineageStatement == null) {
            throw new NullPointerException("lineageStatement is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (creationDate == null) {
            throw new NullPointerException("creationDate is marked non-null but is null");
        }
        if (presentationForm == null) {
            throw new NullPointerException("presentationForm is marked non-null but is null");
        }
        if (abstractField == null) {
            throw new NullPointerException("abstractField is marked non-null but is null");
        }
        if (purpose == null) {
            throw new NullPointerException("purpose is marked non-null but is null");
        }
        if (UUIDIdentifier == null) {
            throw new NullPointerException("UUIDIdentifier is marked non-null but is null");
        }
        if (inspireTheme == null) {
            throw new NullPointerException("inspireTheme is marked non-null but is null");
        }
        this.user = user;
        this.lineageStatement = lineageStatement;
        this.title = title;
        this.creationDate = creationDate;
        this.presentationForm = presentationForm;
        this.abstractField = abstractField;
        this.purpose = purpose;
        this.UUIDIdentifier = UUIDIdentifier;
        this.inspireTheme = inspireTheme;
    }
}

