/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import lombok.NonNull;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.spatial.data.geonetwork.iso.ISOMetadataFactory;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.Language;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.MaintenanceUpdateFrequency;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.ScopeCode;
import org.gcube.spatial.data.geonetwork.iso.tpl.codelists.TopicCategory;
import org.gcube.spatial.data.geonetwork.iso.tpl.constraints.ResourceConstraints;
import org.gcube.spatial.data.geonetwork.iso.tpl.distribution.DistributionInfo;
import org.gcube.spatial.data.geonetwork.iso.tpl.distribution.OnlineResource;
import org.gcube.spatial.data.geonetwork.iso.tpl.extent.BoundingBox;
import org.gcube.spatial.data.geonetwork.iso.tpl.extent.Extent;
import org.gcube.spatial.data.geonetwork.iso.tpl.keys.KeywordSet;
import org.gcube.spatial.data.geonetwork.iso.tpl.parties.ResponsibleParty;
import org.gcube.spatial.data.geonetwork.iso.tpl.spatial.SpatialRepresentation;
import org.gcube.spatial.data.geonetwork.iso.tpl.spatial.VectorRepresentation;

public class MetadataDescriptor {
    @NonNull
    private String UUIDIdentifier;
    @NonNull
    private Language language = Language.ENGLISH;
    @NonNull
    private ScopeCode scope = ScopeCode.DATASET;
    @NonNull
    private Collection<ResponsibleParty> responsibleParties = new ArrayList<ResponsibleParty>();
    @NonNull
    private Date creationTime;
    @NonNull
    private SpatialRepresentation spatialRepresentation = new VectorRepresentation();
    @NonNull
    private Date publicationTime;
    @NonNull
    private String title;
    @NonNull
    private String abstractField;
    @NonNull
    private String purpose;
    @NonNull
    private HashSet<String> credits = new HashSet();
    @NonNull
    private MaintenanceUpdateFrequency maintenanceUpdateFrequency = MaintenanceUpdateFrequency.AS_NEEDED;
    @NonNull
    private ArrayList<KeywordSet> keywordSets = new ArrayList();
    @NonNull
    private ResourceConstraints constraints;
    @NonNull
    private DistributionInfo distributionInfo;
    @NonNull
    private Extent extent = new Extent();
    @NonNull
    private Double spatialResolution;
    @NonNull
    private HashSet<TopicCategory> topicCategories = new HashSet();
    @NonNull
    private String referenceSystem = "WGS:84";
    @NonNull
    private String lineageStatement;

    public void setGeoServerDistributionInfo(String geoServerUrl, String layerName, String workspace, String style, String CRS, BoundingBox toDeclareBB) throws UriResolverMapException, IllegalArgumentException {
        ArrayList<OnlineResource> resources = new ArrayList<OnlineResource>();
        String wmsUrl = ISOMetadataFactory.getWmsUrl(geoServerUrl, layerName, workspace, style, toDeclareBB.toString(), CRS);
        String wcsUrl = ISOMetadataFactory.getWcsUrl(geoServerUrl, layerName, workspace, toDeclareBB.toString());
        String wfsUrl = ISOMetadataFactory.getWfsUrl(geoServerUrl, layerName, workspace);
        String gisViewerUrl = ISOMetadataFactory.getGisLinkByUUID(this.UUIDIdentifier);
        resources.add(new OnlineResource(wmsUrl, "WMS Link"));
        resources.add(new OnlineResource(wcsUrl, "WCS Link"));
        resources.add(new OnlineResource(wfsUrl, "WFS Link"));
        resources.add(new OnlineResource(gisViewerUrl, "GISViewer Link"));
        this.distributionInfo = new DistributionInfo(DistributionInfo.DistributionInfoType.GeoServer, resources);
    }

    public void addCredits(String toAdd) {
        this.getCredits().add(toAdd);
    }

    public void addResponsibleParty(ResponsibleParty toAdd) {
        this.getResponsibleParties().add(toAdd);
    }

    public void addKeywordSet(KeywordSet toAdd) {
        this.getKeywordSets().add(toAdd);
    }

    public void addTopicCategory(TopicCategory toAdd) {
        this.getTopicCategories().add(toAdd);
    }

    @NonNull
    public String getUUIDIdentifier() {
        return this.UUIDIdentifier;
    }

    @NonNull
    public Language getLanguage() {
        return this.language;
    }

    @NonNull
    public ScopeCode getScope() {
        return this.scope;
    }

    @NonNull
    public Collection<ResponsibleParty> getResponsibleParties() {
        return this.responsibleParties;
    }

    @NonNull
    public Date getCreationTime() {
        return this.creationTime;
    }

    @NonNull
    public SpatialRepresentation getSpatialRepresentation() {
        return this.spatialRepresentation;
    }

    @NonNull
    public Date getPublicationTime() {
        return this.publicationTime;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAbstractField() {
        return this.abstractField;
    }

    @NonNull
    public String getPurpose() {
        return this.purpose;
    }

    @NonNull
    public HashSet<String> getCredits() {
        return this.credits;
    }

    @NonNull
    public MaintenanceUpdateFrequency getMaintenanceUpdateFrequency() {
        return this.maintenanceUpdateFrequency;
    }

    @NonNull
    public ArrayList<KeywordSet> getKeywordSets() {
        return this.keywordSets;
    }

    @NonNull
    public ResourceConstraints getConstraints() {
        return this.constraints;
    }

    @NonNull
    public DistributionInfo getDistributionInfo() {
        return this.distributionInfo;
    }

    @NonNull
    public Extent getExtent() {
        return this.extent;
    }

    @NonNull
    public Double getSpatialResolution() {
        return this.spatialResolution;
    }

    @NonNull
    public HashSet<TopicCategory> getTopicCategories() {
        return this.topicCategories;
    }

    @NonNull
    public String getReferenceSystem() {
        return this.referenceSystem;
    }

    @NonNull
    public String getLineageStatement() {
        return this.lineageStatement;
    }

    public void setUUIDIdentifier(@NonNull String UUIDIdentifier) {
        if (UUIDIdentifier == null) {
            throw new NullPointerException("UUIDIdentifier");
        }
        this.UUIDIdentifier = UUIDIdentifier;
    }

    public void setLanguage(@NonNull Language language) {
        if (language == null) {
            throw new NullPointerException("language");
        }
        this.language = language;
    }

    public void setScope(@NonNull ScopeCode scope) {
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        this.scope = scope;
    }

    public void setResponsibleParties(@NonNull Collection<ResponsibleParty> responsibleParties) {
        if (responsibleParties == null) {
            throw new NullPointerException("responsibleParties");
        }
        this.responsibleParties = responsibleParties;
    }

    public void setCreationTime(@NonNull Date creationTime) {
        if (creationTime == null) {
            throw new NullPointerException("creationTime");
        }
        this.creationTime = creationTime;
    }

    public void setSpatialRepresentation(@NonNull SpatialRepresentation spatialRepresentation) {
        if (spatialRepresentation == null) {
            throw new NullPointerException("spatialRepresentation");
        }
        this.spatialRepresentation = spatialRepresentation;
    }

    public void setPublicationTime(@NonNull Date publicationTime) {
        if (publicationTime == null) {
            throw new NullPointerException("publicationTime");
        }
        this.publicationTime = publicationTime;
    }

    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.title = title;
    }

    public void setAbstractField(@NonNull String abstractField) {
        if (abstractField == null) {
            throw new NullPointerException("abstractField");
        }
        this.abstractField = abstractField;
    }

    public void setPurpose(@NonNull String purpose) {
        if (purpose == null) {
            throw new NullPointerException("purpose");
        }
        this.purpose = purpose;
    }

    public void setCredits(@NonNull HashSet<String> credits) {
        if (credits == null) {
            throw new NullPointerException("credits");
        }
        this.credits = credits;
    }

    public void setMaintenanceUpdateFrequency(@NonNull MaintenanceUpdateFrequency maintenanceUpdateFrequency) {
        if (maintenanceUpdateFrequency == null) {
            throw new NullPointerException("maintenanceUpdateFrequency");
        }
        this.maintenanceUpdateFrequency = maintenanceUpdateFrequency;
    }

    public void setKeywordSets(@NonNull ArrayList<KeywordSet> keywordSets) {
        if (keywordSets == null) {
            throw new NullPointerException("keywordSets");
        }
        this.keywordSets = keywordSets;
    }

    public void setConstraints(@NonNull ResourceConstraints constraints) {
        if (constraints == null) {
            throw new NullPointerException("constraints");
        }
        this.constraints = constraints;
    }

    public void setDistributionInfo(@NonNull DistributionInfo distributionInfo) {
        if (distributionInfo == null) {
            throw new NullPointerException("distributionInfo");
        }
        this.distributionInfo = distributionInfo;
    }

    public void setExtent(@NonNull Extent extent) {
        if (extent == null) {
            throw new NullPointerException("extent");
        }
        this.extent = extent;
    }

    public void setSpatialResolution(@NonNull Double spatialResolution) {
        if (spatialResolution == null) {
            throw new NullPointerException("spatialResolution");
        }
        this.spatialResolution = spatialResolution;
    }

    public void setTopicCategories(@NonNull HashSet<TopicCategory> topicCategories) {
        if (topicCategories == null) {
            throw new NullPointerException("topicCategories");
        }
        this.topicCategories = topicCategories;
    }

    public void setReferenceSystem(@NonNull String referenceSystem) {
        if (referenceSystem == null) {
            throw new NullPointerException("referenceSystem");
        }
        this.referenceSystem = referenceSystem;
    }

    public void setLineageStatement(@NonNull String lineageStatement) {
        if (lineageStatement == null) {
            throw new NullPointerException("lineageStatement");
        }
        this.lineageStatement = lineageStatement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataDescriptor)) {
            return false;
        }
        MetadataDescriptor other = (MetadataDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$UUIDIdentifier = this.getUUIDIdentifier();
        String other$UUIDIdentifier = other.getUUIDIdentifier();
        if (this$UUIDIdentifier == null ? other$UUIDIdentifier != null : !this$UUIDIdentifier.equals(other$UUIDIdentifier)) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        ScopeCode this$scope = this.getScope();
        ScopeCode other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        Collection<ResponsibleParty> this$responsibleParties = this.getResponsibleParties();
        Collection<ResponsibleParty> other$responsibleParties = other.getResponsibleParties();
        if (this$responsibleParties == null ? other$responsibleParties != null : !((Object)this$responsibleParties).equals(other$responsibleParties)) {
            return false;
        }
        Date this$creationTime = this.getCreationTime();
        Date other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        SpatialRepresentation this$spatialRepresentation = this.getSpatialRepresentation();
        SpatialRepresentation other$spatialRepresentation = other.getSpatialRepresentation();
        if (this$spatialRepresentation == null ? other$spatialRepresentation != null : !this$spatialRepresentation.equals(other$spatialRepresentation)) {
            return false;
        }
        Date this$publicationTime = this.getPublicationTime();
        Date other$publicationTime = other.getPublicationTime();
        if (this$publicationTime == null ? other$publicationTime != null : !((Object)this$publicationTime).equals(other$publicationTime)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$abstractField = this.getAbstractField();
        String other$abstractField = other.getAbstractField();
        if (this$abstractField == null ? other$abstractField != null : !this$abstractField.equals(other$abstractField)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
            return false;
        }
        HashSet<String> this$credits = this.getCredits();
        HashSet<String> other$credits = other.getCredits();
        if (this$credits == null ? other$credits != null : !((Object)this$credits).equals(other$credits)) {
            return false;
        }
        MaintenanceUpdateFrequency this$maintenanceUpdateFrequency = this.getMaintenanceUpdateFrequency();
        MaintenanceUpdateFrequency other$maintenanceUpdateFrequency = other.getMaintenanceUpdateFrequency();
        if (this$maintenanceUpdateFrequency == null ? other$maintenanceUpdateFrequency != null : !((Object)((Object)this$maintenanceUpdateFrequency)).equals((Object)other$maintenanceUpdateFrequency)) {
            return false;
        }
        ArrayList<KeywordSet> this$keywordSets = this.getKeywordSets();
        ArrayList<KeywordSet> other$keywordSets = other.getKeywordSets();
        if (this$keywordSets == null ? other$keywordSets != null : !((Object)this$keywordSets).equals(other$keywordSets)) {
            return false;
        }
        ResourceConstraints this$constraints = this.getConstraints();
        ResourceConstraints other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !this$constraints.equals(other$constraints)) {
            return false;
        }
        DistributionInfo this$distributionInfo = this.getDistributionInfo();
        DistributionInfo other$distributionInfo = other.getDistributionInfo();
        if (this$distributionInfo == null ? other$distributionInfo != null : !((Object)this$distributionInfo).equals(other$distributionInfo)) {
            return false;
        }
        Extent this$extent = this.getExtent();
        Extent other$extent = other.getExtent();
        if (this$extent == null ? other$extent != null : !this$extent.equals(other$extent)) {
            return false;
        }
        Double this$spatialResolution = this.getSpatialResolution();
        Double other$spatialResolution = other.getSpatialResolution();
        if (this$spatialResolution == null ? other$spatialResolution != null : !((Object)this$spatialResolution).equals(other$spatialResolution)) {
            return false;
        }
        HashSet<TopicCategory> this$topicCategories = this.getTopicCategories();
        HashSet<TopicCategory> other$topicCategories = other.getTopicCategories();
        if (this$topicCategories == null ? other$topicCategories != null : !((Object)this$topicCategories).equals(other$topicCategories)) {
            return false;
        }
        String this$referenceSystem = this.getReferenceSystem();
        String other$referenceSystem = other.getReferenceSystem();
        if (this$referenceSystem == null ? other$referenceSystem != null : !this$referenceSystem.equals(other$referenceSystem)) {
            return false;
        }
        String this$lineageStatement = this.getLineageStatement();
        String other$lineageStatement = other.getLineageStatement();
        return !(this$lineageStatement == null ? other$lineageStatement != null : !this$lineageStatement.equals(other$lineageStatement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetadataDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $UUIDIdentifier = this.getUUIDIdentifier();
        result = result * 59 + ($UUIDIdentifier == null ? 0 : $UUIDIdentifier.hashCode());
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 0 : ((Object)((Object)$language)).hashCode());
        ScopeCode $scope = this.getScope();
        result = result * 59 + ($scope == null ? 0 : ((Object)((Object)$scope)).hashCode());
        Collection<ResponsibleParty> $responsibleParties = this.getResponsibleParties();
        result = result * 59 + ($responsibleParties == null ? 0 : ((Object)$responsibleParties).hashCode());
        Date $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 0 : ((Object)$creationTime).hashCode());
        SpatialRepresentation $spatialRepresentation = this.getSpatialRepresentation();
        result = result * 59 + ($spatialRepresentation == null ? 0 : $spatialRepresentation.hashCode());
        Date $publicationTime = this.getPublicationTime();
        result = result * 59 + ($publicationTime == null ? 0 : ((Object)$publicationTime).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        String $abstractField = this.getAbstractField();
        result = result * 59 + ($abstractField == null ? 0 : $abstractField.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 0 : $purpose.hashCode());
        HashSet<String> $credits = this.getCredits();
        result = result * 59 + ($credits == null ? 0 : ((Object)$credits).hashCode());
        MaintenanceUpdateFrequency $maintenanceUpdateFrequency = this.getMaintenanceUpdateFrequency();
        result = result * 59 + ($maintenanceUpdateFrequency == null ? 0 : ((Object)((Object)$maintenanceUpdateFrequency)).hashCode());
        ArrayList<KeywordSet> $keywordSets = this.getKeywordSets();
        result = result * 59 + ($keywordSets == null ? 0 : ((Object)$keywordSets).hashCode());
        ResourceConstraints $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 0 : $constraints.hashCode());
        DistributionInfo $distributionInfo = this.getDistributionInfo();
        result = result * 59 + ($distributionInfo == null ? 0 : ((Object)$distributionInfo).hashCode());
        Extent $extent = this.getExtent();
        result = result * 59 + ($extent == null ? 0 : $extent.hashCode());
        Double $spatialResolution = this.getSpatialResolution();
        result = result * 59 + ($spatialResolution == null ? 0 : ((Object)$spatialResolution).hashCode());
        HashSet<TopicCategory> $topicCategories = this.getTopicCategories();
        result = result * 59 + ($topicCategories == null ? 0 : ((Object)$topicCategories).hashCode());
        String $referenceSystem = this.getReferenceSystem();
        result = result * 59 + ($referenceSystem == null ? 0 : $referenceSystem.hashCode());
        String $lineageStatement = this.getLineageStatement();
        result = result * 59 + ($lineageStatement == null ? 0 : $lineageStatement.hashCode());
        return result;
    }

    @ConstructorProperties(value={"UUIDIdentifier", "language", "scope", "responsibleParties", "creationTime", "spatialRepresentation", "publicationTime", "title", "abstractField", "purpose", "credits", "maintenanceUpdateFrequency", "keywordSets", "constraints", "distributionInfo", "extent", "spatialResolution", "topicCategories", "referenceSystem", "lineageStatement"})
    public MetadataDescriptor(@NonNull String UUIDIdentifier, @NonNull Language language, @NonNull ScopeCode scope, @NonNull Collection<ResponsibleParty> responsibleParties, @NonNull Date creationTime, @NonNull SpatialRepresentation spatialRepresentation, @NonNull Date publicationTime, @NonNull String title, @NonNull String abstractField, @NonNull String purpose, @NonNull HashSet<String> credits, @NonNull MaintenanceUpdateFrequency maintenanceUpdateFrequency, @NonNull ArrayList<KeywordSet> keywordSets, @NonNull ResourceConstraints constraints, @NonNull DistributionInfo distributionInfo, @NonNull Extent extent, @NonNull Double spatialResolution, @NonNull HashSet<TopicCategory> topicCategories, @NonNull String referenceSystem, @NonNull String lineageStatement) {
        if (UUIDIdentifier == null) {
            throw new NullPointerException("UUIDIdentifier");
        }
        if (language == null) {
            throw new NullPointerException("language");
        }
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        if (responsibleParties == null) {
            throw new NullPointerException("responsibleParties");
        }
        if (creationTime == null) {
            throw new NullPointerException("creationTime");
        }
        if (spatialRepresentation == null) {
            throw new NullPointerException("spatialRepresentation");
        }
        if (publicationTime == null) {
            throw new NullPointerException("publicationTime");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (abstractField == null) {
            throw new NullPointerException("abstractField");
        }
        if (purpose == null) {
            throw new NullPointerException("purpose");
        }
        if (credits == null) {
            throw new NullPointerException("credits");
        }
        if (maintenanceUpdateFrequency == null) {
            throw new NullPointerException("maintenanceUpdateFrequency");
        }
        if (keywordSets == null) {
            throw new NullPointerException("keywordSets");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints");
        }
        if (distributionInfo == null) {
            throw new NullPointerException("distributionInfo");
        }
        if (extent == null) {
            throw new NullPointerException("extent");
        }
        if (spatialResolution == null) {
            throw new NullPointerException("spatialResolution");
        }
        if (topicCategories == null) {
            throw new NullPointerException("topicCategories");
        }
        if (referenceSystem == null) {
            throw new NullPointerException("referenceSystem");
        }
        if (lineageStatement == null) {
            throw new NullPointerException("lineageStatement");
        }
        this.UUIDIdentifier = UUIDIdentifier;
        this.language = language;
        this.scope = scope;
        this.responsibleParties = responsibleParties;
        this.creationTime = creationTime;
        this.spatialRepresentation = spatialRepresentation;
        this.publicationTime = publicationTime;
        this.title = title;
        this.abstractField = abstractField;
        this.purpose = purpose;
        this.credits = credits;
        this.maintenanceUpdateFrequency = maintenanceUpdateFrequency;
        this.keywordSets = keywordSets;
        this.constraints = constraints;
        this.distributionInfo = distributionInfo;
        this.extent = extent;
        this.spatialResolution = spatialResolution;
        this.topicCategories = topicCategories;
        this.referenceSystem = referenceSystem;
        this.lineageStatement = lineageStatement;
    }

    public String toString() {
        return "MetadataDescriptor(UUIDIdentifier=" + this.getUUIDIdentifier() + ", language=" + (Object)((Object)this.getLanguage()) + ", scope=" + (Object)((Object)this.getScope()) + ", responsibleParties=" + this.getResponsibleParties() + ", creationTime=" + this.getCreationTime() + ", spatialRepresentation=" + this.getSpatialRepresentation() + ", publicationTime=" + this.getPublicationTime() + ", title=" + this.getTitle() + ", abstractField=" + this.getAbstractField() + ", purpose=" + this.getPurpose() + ", credits=" + this.getCredits() + ", maintenanceUpdateFrequency=" + (Object)((Object)this.getMaintenanceUpdateFrequency()) + ", keywordSets=" + this.getKeywordSets() + ", constraints=" + this.getConstraints() + ", distributionInfo=" + this.getDistributionInfo() + ", extent=" + this.getExtent() + ", spatialResolution=" + this.getSpatialResolution() + ", topicCategories=" + this.getTopicCategories() + ", referenceSystem=" + this.getReferenceSystem() + ", lineageStatement=" + this.getLineageStatement() + ")";
    }

    public MetadataDescriptor() {
    }
}

