/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.extension;

import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtilsExtensions
extends HTTPUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtilsExtensions.class);
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String XML_CONTENT_TYPE = "text/xml";
    String username;
    String pw;
    private int lastHttpStatus = 0;
    HttpClient client = new HttpClient();

    public HttpUtilsExtensions() {
    }

    public HttpUtilsExtensions(String userName, String password) {
        super(userName, password);
        this.username = userName;
        this.pw = password;
    }

    public String getJSON(String url) throws MalformedURLException, GNServerException {
        GetMethod httpMethod = null;
        try {
            this.setAuth(this.client, url, this.username, this.pw);
            httpMethod = new GetMethod(url);
            httpMethod.setRequestHeader("Accept", JSON_CONTENT_TYPE);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            if (this.lastHttpStatus == 200) {
                InputStream is = httpMethod.getResponseBodyAsStream();
                String response = IOUtils.toString((InputStream)is);
                if (response.trim().length() == 0) {
                    log.warn("ResponseBody is empty");
                    return null;
                }
                String string = response;
                return string;
            }
            try {
                log.info("(" + this.lastHttpStatus + ") " + HttpStatus.getStatusText((int)this.lastHttpStatus) + " -- " + url);
                throw new GNServerException("ERROR from calling " + url, this.lastHttpStatus);
            }
            catch (ConnectException e) {
                log.info("Couldn't connect to [" + url + "]");
            }
            catch (IOException e) {
                log.info("Error talking to [" + url + "]", (Throwable)e);
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
        return null;
    }

    public String putJSON(String url, String content) throws UnsupportedEncodingException, GNServerException {
        PutMethod httpMethod = null;
        try {
            this.setAuth(this.client, url, this.username, this.pw);
            httpMethod = new PutMethod(url);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity(content, JSON_CONTENT_TYPE, "UTF-8"));
            httpMethod.setRequestHeader("Accept", JSON_CONTENT_TYPE);
            this.lastHttpStatus = this.client.executeMethod((HttpMethod)httpMethod);
            if (this.lastHttpStatus >= 200 && this.lastHttpStatus < 300) {
                log.debug("HTTP " + httpMethod.getStatusText() + " <-- " + url);
                InputStream responseStream = httpMethod.getResponseBodyAsStream();
                if (super.isIgnoreResponseContentOnSuccess() || responseStream == null) {
                    return "";
                }
                String string = IOUtils.toString((InputStream)responseStream);
                return string;
            }
            try {
                String badresponse = IOUtils.toString((InputStream)httpMethod.getResponseBodyAsStream());
                String message = HTTPUtils.getGeoNetworkErrorMessage((String)badresponse);
                log.warn("Bad response: " + this.lastHttpStatus + " " + httpMethod.getStatusText() + " -- " + httpMethod.getName() + " " + url + " : " + message);
                log.debug("GeoNetwork response:\n" + badresponse);
                throw new GNServerException("ERROR from calling " + url + ". Message is " + badresponse, this.lastHttpStatus);
            }
            catch (ConnectException e) {
                log.info("Couldn't connect to [" + url + "]");
                return null;
            }
            catch (IOException e) {
                log.error("Error talking to " + url + " : " + e.getLocalizedMessage());
                return null;
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected void setAuth(HttpClient client, String url, String username, String pw) throws MalformedURLException {
        URL u = new URL(url);
        if (username != null && pw != null) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(username, pw);
            client.getState().setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)defaultcreds);
            client.getParams().setAuthenticationPreemptive(true);
        } else {
            log.trace("Not setting credentials to access to " + url);
        }
    }

    private void reset() {
        this.lastHttpStatus = 0;
    }

    private boolean isReset() {
        return this.lastHttpStatus == 0;
    }

    public int getLastHttpStatus() {
        if (this.isReset()) {
            return super.getLastHttpStatus();
        }
        return this.lastHttpStatus;
    }

    public boolean delete(String arg0) {
        this.reset();
        return super.delete(arg0);
    }

    public boolean exists(String arg0) {
        this.reset();
        return super.exists(arg0);
    }

    public String get(String arg0) throws MalformedURLException {
        this.reset();
        return super.get(arg0);
    }

    public boolean httpPing(String arg0) {
        this.reset();
        return super.httpPing(arg0);
    }

    public String post(String arg0, String arg1, String arg2, String arg3) {
        this.reset();
        return super.post(arg0, arg1, arg2, arg3);
    }

    public String post(String url, File file, String contentType) {
        this.reset();
        return super.post(url, file, contentType);
    }

    public String post(String url, InputStream content, String contentType) {
        this.reset();
        return super.post(url, content, contentType);
    }

    public String post(String url, RequestEntity requestEntity) {
        this.reset();
        return super.post(url, requestEntity);
    }

    public String post(String url, String content, String contentType) {
        this.reset();
        return super.post(url, content, contentType);
    }

    public String postXml(String url, InputStream content) {
        this.reset();
        return super.postXml(url, content);
    }

    public String postXml(String url, String content) {
        this.reset();
        return super.postXml(url, content);
    }

    public String postXml(String url, String content, String encoding) {
        this.reset();
        return super.postXml(url, content, encoding);
    }

    public String put(String arg0, String arg1, String arg2) {
        this.reset();
        return super.put(arg0, arg1, arg2);
    }

    public String put(String url, File file, String contentType) {
        this.reset();
        return super.put(url, file, contentType);
    }

    public String put(String url, RequestEntity requestEntity) {
        this.reset();
        return super.put(url, requestEntity);
    }

    public String putXml(String url, String content) {
        this.reset();
        return super.putXml(url, content);
    }
}

