/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.extension;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import org.gcube.spatial.data.geonetwork.extension.HttpUtilsExtensions;
import org.gcube.spatial.data.geonetwork.extension.ServerAccess;
import org.gcube.spatial.data.geonetwork.model.User;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GNMetadataAdminExtension {
    private static final Logger log = LoggerFactory.getLogger(GNMetadataAdminExtension.class);
    private static final XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
    private static final String USER_3 = "/srv/api/0.1/users";
    private static final String GROUPS_3 = "/srv/api/0.1/groups";
    private static final String CREATE_GROUP_METHOD_2 = "/srv/en/group.update";
    private static final String GROUP_LIST_METHOD = "/srv/en/xml.group.list";
    private static final String USER_LIST_METHOD_2 = "/srv/en/xml.user.list";
    private static final String CREATE_USER_METHOD = "/srv/en/user.update";
    private static final String GET_GROUPS_BY_USER = "/srv/en/xml.usergroups.list";
    private static final String METADATA_SELECT = "/srv/en/metadata.select";
    private static final String ASSIGN_MASSIVE_OWNERSHIP = "/srv/en/metadata.massive.newowner";
    private static final String AVAILABLE_OWNERSHIP = "/srv/en/xml.ownership.groups";
    private static final String METADATA_OWNERS = "/srv/en/xml.ownership.editors";
    private static final String TRANSFER_OWNSERSHIP = "/srv/en/xml.ownership.transfer";

    public static String allowedOwnershipTransfer(HTTPUtils connection, ServerAccess access, Integer userId) throws GNServerException, GNLibException {
        log.debug("Getting available ownership transfer for user " + userId);
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText(userId + ""));
        return GNMetadataAdminExtension.gnCall(connection, access, request, AVAILABLE_OWNERSHIP);
    }

    public static String metadataOwners(HTTPUtils connection, ServerAccess access) throws GNServerException, GNLibException {
        log.debug("Getting metadata owners");
        Element request = new Element("request");
        return GNMetadataAdminExtension.gnCall(connection, access, request, METADATA_OWNERS);
    }

    public static String selectMeta(HTTPUtils connection, ServerAccess access, List<Long> toSelectIds) throws GNServerException, GNLibException {
        log.debug("Massive metadata selection..");
        Element request = GNMetadataAdminExtension.buildSelectMetadata(toSelectIds);
        return GNMetadataAdminExtension.gnCall(connection, access, request, METADATA_SELECT);
    }

    public static String clearMetaSelection(HTTPUtils connection, ServerAccess access) throws GNServerException, GNLibException {
        log.debug("Massive metadata selection..");
        Element request = GNMetadataAdminExtension.buildClearMetaSelection();
        return GNMetadataAdminExtension.gnCall(connection, access, request, METADATA_SELECT);
    }

    public static String assignMassiveOwnership(HTTPUtils connection, ServerAccess access, Integer userId, Integer groupId) throws GNServerException, GNLibException {
        log.debug("Assign massive ownership to u:{},g:{} ", (Object)userId, (Object)groupId);
        Element request = new Element("request");
        request.addContent((Content)new Element("user").setText(userId + ""));
        request.addContent((Content)new Element("group").setText(groupId + ""));
        return GNMetadataAdminExtension.gnCall(connection, access, request, ASSIGN_MASSIVE_OWNERSHIP);
    }

    public static String transferOwnership(HTTPUtils connection, ServerAccess access, Integer sourceUserId, Integer sourceGroupId, Integer destUserId, Integer destGroupId) throws GNServerException, GNLibException {
        log.debug("Transfering ownership from u:{},g:{} to u:{},g:{}", new Object[]{sourceUserId, sourceGroupId, destUserId, destGroupId});
        Element request = new Element("request");
        request.addContent((Content)new Element("sourceUser").setText(sourceUserId + ""));
        request.addContent((Content)new Element("sourceGroup").setText(sourceGroupId + ""));
        request.addContent((Content)new Element("targetUser").setText(destUserId + ""));
        request.addContent((Content)new Element("targetGroup").setText(destGroupId + ""));
        return GNMetadataAdminExtension.gnCall(connection, access, request, TRANSFER_OWNSERSHIP);
    }

    public static String editUser(HTTPUtils connection, ServerAccess access, User toAdd, Collection<Integer> groups) throws GNLibException, GNServerException {
        log.debug("Coupling user {} to groups {} ", (Object)toAdd, groups);
        JSONObject request = null;
        String method = null;
        if (access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            Element requestEl = new Element("request");
            requestEl.addContent((Content)new Element("operation").setText("editinfo"));
            requestEl.addContent((Content)new Element("id").setText(toAdd.getId() + ""));
            requestEl.addContent((Content)new Element("username").setText(toAdd.getUsername()));
            requestEl.addContent((Content)new Element("password").setText(toAdd.getPassword()));
            requestEl.addContent((Content)new Element("profile").setText(toAdd.getProfile().name()));
            if (groups != null) {
                for (Integer groupId : groups) {
                    requestEl.addContent((Content)new Element("groups").setText(groupId + ""));
                }
            }
            request = requestEl;
            method = CREATE_USER_METHOD;
        } else {
            try {
                JSONObject object = new JSONObject();
                object.put("username", (Object)toAdd.getUsername());
                object.put("password", (Object)toAdd.getPassword());
                object.put("profile", (Object)toAdd.getProfile().toString());
                object.put("enabled", true);
                if (groups != null) {
                    JSONArray array = new JSONArray();
                    for (Integer groupId : groups) {
                        array.put((Object)(groupId + ""));
                    }
                    object.put("groupsReviewer", (Object)array);
                }
                request = object;
                method = "/srv/api/0.1/users/" + toAdd.getId();
            }
            catch (Exception e) {
                throw new GNLibException("Unabel to create JSON request for group creation ", (Throwable)e);
            }
        }
        return GNMetadataAdminExtension.gnCall(connection, access, request, method);
    }

    public static String getUserGroupd(HTTPUtils connection, ServerAccess access, Integer userId) throws GNLibException, GNServerException {
        log.debug("Getting user groups..");
        return GNMetadataAdminExtension.gnCall(connection, access, new Element("request").addContent((Content)new Element("id").setText(userId + "")), GET_GROUPS_BY_USER);
    }

    public static String getUsers(HTTPUtils connection, ServerAccess access) throws GNServerException, GNLibException {
        log.debug("Requesting users..");
        if (access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            return GNMetadataAdminExtension.gnCall(connection, access, new Element("request"), USER_LIST_METHOD_2);
        }
        String toReturn = GNMetadataAdminExtension.gnCall(connection, access, null, USER_3);
        return toReturn;
    }

    public static String createUser(HTTPUtils connection, ServerAccess access, String name, String password, User.Profile profile, Collection<Integer> groups) throws GNServerException, GNLibException {
        log.debug("Requesting users..");
        log.debug("Compiling admin request document");
        JSONObject userRequest = null;
        String method = null;
        if (access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            Element request = new Element("request");
            request.addContent((Content)new Element("operation").setText("newuser"));
            request.addContent((Content)new Element("username").setText(name));
            request.addContent((Content)new Element("password").setText(password));
            request.addContent((Content)new Element("profile").setText(profile.name()));
            if (groups != null) {
                for (Integer groupId : groups) {
                    request.addContent((Content)new Element("groups").setText(groupId + ""));
                }
            }
            userRequest = request;
            method = CREATE_USER_METHOD;
        } else {
            try {
                JSONObject object = new JSONObject();
                object.put("username", (Object)name);
                object.put("password", (Object)password);
                object.put("profile", (Object)profile);
                object.put("enabled", true);
                if (groups != null) {
                    JSONArray array = new JSONArray();
                    for (Integer groupId : groups) {
                        array.put((Object)(groupId + ""));
                    }
                    object.put("groupsReviewer", (Object)array);
                }
                userRequest = object;
                method = USER_3;
            }
            catch (Exception e) {
                throw new GNLibException("Unabel to create JSON request for group creation ", (Throwable)e);
            }
        }
        return GNMetadataAdminExtension.gnCall(connection, access, userRequest, method);
    }

    public static String createGroup(HTTPUtils connection, ServerAccess access, String groupName, String groupDescription, String groupMail, Integer groupId) throws GNLibException, GNServerException {
        log.debug(String.format("Creating group [Name : %s, Description : %s, Mail : %s ", groupName, groupDescription, groupMail));
        JSONObject adminRequest = null;
        String method = null;
        if (access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            Element request = new Element("request");
            request.addContent((Content)new Element("name").setText(groupName));
            request.addContent((Content)new Element("description").setText(groupDescription));
            request.addContent((Content)new Element("email").setText(groupMail));
            adminRequest = request;
            method = CREATE_GROUP_METHOD_2;
        } else {
            try {
                JSONObject object = new JSONObject();
                object.put("name", (Object)groupName);
                object.put("description", (Object)groupDescription);
                object.put("email", (Object)groupMail);
                object.put("id", (Object)groupId);
                adminRequest = object;
                method = GROUPS_3;
            }
            catch (Exception e) {
                throw new GNLibException("Unabel to create JSON request for group creation ", (Throwable)e);
            }
        }
        return GNMetadataAdminExtension.gnCall(connection, access, adminRequest, method);
    }

    public static String getGroups(HTTPUtils connection, ServerAccess access) throws GNServerException, GNLibException {
        log.debug("Requesting groups..");
        Element request = null;
        String method = null;
        if (access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            request = new Element("request");
            method = GROUP_LIST_METHOD;
        } else {
            method = GROUPS_3;
        }
        return GNMetadataAdminExtension.gnCall(connection, access, request, method);
    }

    private static String gnCall(HTTPUtils connection, ServerAccess access, Object gnRequest, String toInvokeMethod) throws GNServerException, GNLibException {
        String serviceURL = access.getGnServiceURL() + toInvokeMethod;
        try {
            String result = gnRequest == null ? GNMetadataAdminExtension.gnGET(connection, serviceURL) : GNMetadataAdminExtension.gnPut(connection, serviceURL, gnRequest);
            int httpStatus = connection.getLastHttpStatus();
            if (httpStatus < 200 || httpStatus >= 300) {
                throw new GNServerException("Error executing call, received " + httpStatus + ". Result is " + result);
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new GNServerException("Unable to send request ", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GNServerException("Unable to send request ", (Throwable)e);
        }
        catch (GNLibException e) {
            throw e;
        }
    }

    private static Element buildSelectMetadata(List<Long> toSelectIds) {
        log.debug("building selection request");
        Element request = new Element("request");
        if (toSelectIds != null) {
            for (Long id : toSelectIds) {
                request.addContent((Content)new Element("id").setText(id.toString()));
            }
            request.addContent((Content)new Element("selected").setText("add"));
        } else {
            request.addContent((Content)new Element("selected").setText("add-all"));
        }
        return request;
    }

    private static Element buildClearMetaSelection() {
        log.debug("building selection request");
        Element request = new Element("request");
        request.addContent((Content)new Element("selected").setText("remove-all"));
        return request;
    }

    private static String gnPut(HTTPUtils connection, String serviceURL, Object gnRequest) throws UnsupportedEncodingException, GNLibException, GNServerException {
        if (gnRequest instanceof Element) {
            String s = outputter.outputString((Element)gnRequest);
            connection.setIgnoreResponseContentOnSuccess(false);
            String res = connection.postXml(serviceURL, s);
            return res;
        }
        if (gnRequest instanceof JSONObject) {
            String s = ((JSONObject)gnRequest).toString();
            connection.setIgnoreResponseContentOnSuccess(false);
            return ((HttpUtilsExtensions)connection).putJSON(serviceURL, s);
        }
        throw new GNLibException("Unable to manage request element " + gnRequest);
    }

    private static String gnGET(HTTPUtils connection, String serviceURL) throws MalformedURLException, GNServerException {
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = ((HttpUtilsExtensions)connection).getJSON(serviceURL);
        return res;
    }
}

