/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.extension;

import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.op.gn3.GN3MetadataGetInfo;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gcube.spatial.data.geonetwork.extension.GN26Extension;
import org.gcube.spatial.data.geonetwork.extension.GN3Extension;
import org.gcube.spatial.data.geonetwork.extension.GNMetadataAdminExtension;
import org.gcube.spatial.data.geonetwork.extension.ServerAccess;
import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.utils.GroupUtils;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.jdom.Element;

public class GNClientExtension
implements GNClient {
    private GNClient client;
    private ServerAccess access;

    public GNClientExtension(ServerAccess access) {
        this.access = access;
        switch (access.getVersion()) {
            case DUE: {
                this.client = access.isLogin() ? new GN26Extension(access.getGnServiceURL(), access.getUser(), access.getPassword()) : new GN26Extension(access.getGnServiceURL());
                break;
            }
            default: {
                this.client = access.isLogin() ? new GN3Extension(access.getGnServiceURL(), access.getUser(), access.getPassword()) : new GN3Extension(access.getGnServiceURL());
            }
        }
    }

    public void createGroup(String name, String description, String mail, Integer id) throws GNLibException, GNServerException {
        GNMetadataAdminExtension.createGroup(this.getConnection(), this.access, name, description, mail, id);
    }

    public Set<Group> getGroups() throws GNLibException, GNServerException {
        String groupResponse = GNMetadataAdminExtension.getGroups(this.getConnection(), this.access);
        if (this.access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            return GroupUtils.parseGroupXMLResponse(groupResponse);
        }
        return GroupUtils.parseUserJSONResponse(groupResponse);
    }

    public Set<User> getUsers() throws GNLibException, GNServerException {
        String userResponse = GNMetadataAdminExtension.getUsers(this.getConnection(), this.access);
        if (this.access.getVersion().equals((Object)ServerAccess.Version.DUE)) {
            return UserUtils.parseUserXMLResponse(userResponse);
        }
        return UserUtils.parseUserJSONResponse(userResponse);
    }

    public void createUser(String name, String password, User.Profile profile, Collection<Integer> groups) throws GNServerException, GNLibException {
        GNMetadataAdminExtension.createUser(this.getConnection(), this.access, name, password, profile, groups);
    }

    public void editUser(User toAdd, Collection<Integer> groups) throws GNServerException, GNLibException {
        Set<Integer> alreadyAddedGroups = this.getGroupsByUser(toAdd.getId());
        alreadyAddedGroups.addAll(groups);
        GNMetadataAdminExtension.editUser(this.getConnection(), this.access, toAdd, alreadyAddedGroups);
    }

    public Set<Integer> getGroupsByUser(Integer userId) throws GNLibException, GNServerException {
        return UserUtils.parseGroupsByUserResponse(GNMetadataAdminExtension.getUserGroupd(this.getConnection(), this.access, userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignOwnership(List<Long> toTransferIds, Integer targetUserId, Integer targetGroupId) throws GNServerException, GNLibException {
        try {
            GNMetadataAdminExtension.selectMeta(this.getConnection(), this.access, toTransferIds);
            GNMetadataAdminExtension.assignMassiveOwnership(this.getConnection(), this.access, targetUserId, targetGroupId);
        }
        finally {
            GNMetadataAdminExtension.clearMetaSelection(this.getConnection(), this.access);
        }
    }

    public String getPossibleOwnershipTransfer(Integer userId) throws GNServerException, GNLibException {
        return GNMetadataAdminExtension.allowedOwnershipTransfer(this.getConnection(), this.access, userId);
    }

    public String getMetadataOwners() throws GNServerException, GNLibException {
        return GNMetadataAdminExtension.metadataOwners(this.getConnection(), this.access);
    }

    public void transferOwnership(Integer sourceUserId, Integer sourceGroupId, Integer targetUserId, Integer targetGroupId) throws GNServerException, GNLibException {
        GNMetadataAdminExtension.transferOwnership(this.getConnection(), this.access, sourceUserId, sourceGroupId, targetUserId, targetGroupId);
    }

    public boolean ping() {
        return this.client.ping();
    }

    public long insertMetadata(GNInsertConfiguration cfg, File metadataFile) throws GNLibException, GNServerException {
        return this.client.insertMetadata(cfg, metadataFile);
    }

    public long insertRequest(File requestFile) throws GNLibException, GNServerException {
        return this.client.insertRequest(requestFile);
    }

    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException {
        this.client.setPrivileges(metadataId, cfg);
    }

    public GNSearchResponse search(GNSearchRequest searchRequest) throws GNLibException, GNServerException {
        return this.client.search(searchRequest);
    }

    public GNSearchResponse search(File fileRequest) throws GNLibException, GNServerException {
        return this.client.search(fileRequest);
    }

    public Element get(Long id) throws GNLibException, GNServerException {
        return this.client.get(id);
    }

    public Element get(String uuid) throws GNLibException, GNServerException {
        return this.client.get(uuid);
    }

    public void deleteMetadata(long id) throws GNLibException, GNServerException {
        this.client.deleteMetadata(id);
    }

    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException {
        this.client.updateMetadata(id, metadataFile);
    }

    public void updateMetadata(long id, File metadataFile, String encoding) throws GNLibException, GNServerException {
        this.client.updateMetadata(id, metadataFile, encoding);
    }

    public GN3MetadataGetInfo.MetadataInfo getInfo(Long id) throws GNLibException, GNServerException {
        return this.client.getInfo(id);
    }

    public GN3MetadataGetInfo.MetadataInfo getInfo(String uuid) throws GNLibException, GNServerException {
        return this.client.getInfo(uuid);
    }

    public HTTPUtils getConnection() throws GNLibException {
        return this.client.getConnection();
    }
}

