/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso.tpl;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.spatial.data.geonetwork.iso.BoundingBox;
import org.gcube.spatial.data.geonetwork.iso.ISOMetadataFactory;
import org.gcube.spatial.data.geonetwork.iso.tpl.DistributionInfo;
import org.gcube.spatial.data.geonetwork.iso.tpl.Keyword;
import org.gcube.spatial.data.geonetwork.iso.tpl.OnlineResource;
import org.gcube.spatial.data.geonetwork.iso.tpl.ResponsibleParty;

public class MetadataDescriptor {
    private String UUIDIdentifier;
    private Collection<ResponsibleParty> responsibleParties;
    private Date creationTime;
    private Long geometricObjectCount;
    private Date publicationTime;
    private String title;
    private String abstractField;
    private String purpose;
    private String credit;
    private Collection<Keyword> keywords;
    private DistributionInfo distributionInfo;
    private BoundingBox boundingBox;
    private Double spatialResolution;
    private String topicCategory;
    private String guidelinesConformityExplanation;
    private Boolean guidelinesConformityPass;
    private String lineageStatement;

    public void setGeoServerDistributionInfo(String geoServerUrl, String layerName, String workspace, String style, String CRS) throws UriResolverMapException, IllegalArgumentException {
        ArrayList<OnlineResource> resources = new ArrayList<OnlineResource>();
        String bbox = this.getBoundingBox().toString();
        String wmsUrl = ISOMetadataFactory.getWmsUrl(geoServerUrl, layerName, workspace, style, bbox, CRS);
        String wcsUrl = ISOMetadataFactory.getWcsUrl(geoServerUrl, layerName, workspace, bbox);
        String wfsUrl = ISOMetadataFactory.getWfsUrl(geoServerUrl, layerName, workspace);
        String gisViewerUrl = ISOMetadataFactory.getGisLinkByUUID(this.UUIDIdentifier);
        resources.add(new OnlineResource(wmsUrl, "WMS Link"));
        resources.add(new OnlineResource(wcsUrl, "WCS Link"));
        resources.add(new OnlineResource(wfsUrl, "WFS Link"));
        resources.add(new OnlineResource(gisViewerUrl, "GISViewer Link"));
        this.distributionInfo = new DistributionInfo(DistributionInfo.DistributionInfoType.GeoServer, resources);
    }

    public String getUUIDIdentifier() {
        return this.UUIDIdentifier;
    }

    public Collection<ResponsibleParty> getResponsibleParties() {
        return this.responsibleParties;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Long getGeometricObjectCount() {
        return this.geometricObjectCount;
    }

    public Date getPublicationTime() {
        return this.publicationTime;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbstractField() {
        return this.abstractField;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getCredit() {
        return this.credit;
    }

    public Collection<Keyword> getKeywords() {
        return this.keywords;
    }

    public DistributionInfo getDistributionInfo() {
        return this.distributionInfo;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Double getSpatialResolution() {
        return this.spatialResolution;
    }

    public String getTopicCategory() {
        return this.topicCategory;
    }

    public String getGuidelinesConformityExplanation() {
        return this.guidelinesConformityExplanation;
    }

    public Boolean getGuidelinesConformityPass() {
        return this.guidelinesConformityPass;
    }

    public String getLineageStatement() {
        return this.lineageStatement;
    }

    public void setUUIDIdentifier(String UUIDIdentifier) {
        this.UUIDIdentifier = UUIDIdentifier;
    }

    public void setResponsibleParties(Collection<ResponsibleParty> responsibleParties) {
        this.responsibleParties = responsibleParties;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public void setGeometricObjectCount(Long geometricObjectCount) {
        this.geometricObjectCount = geometricObjectCount;
    }

    public void setPublicationTime(Date publicationTime) {
        this.publicationTime = publicationTime;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAbstractField(String abstractField) {
        this.abstractField = abstractField;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    public void setKeywords(Collection<Keyword> keywords) {
        this.keywords = keywords;
    }

    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setSpatialResolution(Double spatialResolution) {
        this.spatialResolution = spatialResolution;
    }

    public void setTopicCategory(String topicCategory) {
        this.topicCategory = topicCategory;
    }

    public void setGuidelinesConformityExplanation(String guidelinesConformityExplanation) {
        this.guidelinesConformityExplanation = guidelinesConformityExplanation;
    }

    public void setGuidelinesConformityPass(Boolean guidelinesConformityPass) {
        this.guidelinesConformityPass = guidelinesConformityPass;
    }

    public void setLineageStatement(String lineageStatement) {
        this.lineageStatement = lineageStatement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataDescriptor)) {
            return false;
        }
        MetadataDescriptor other = (MetadataDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$UUIDIdentifier = this.getUUIDIdentifier();
        String other$UUIDIdentifier = other.getUUIDIdentifier();
        if (this$UUIDIdentifier == null ? other$UUIDIdentifier != null : !this$UUIDIdentifier.equals(other$UUIDIdentifier)) {
            return false;
        }
        Collection<ResponsibleParty> this$responsibleParties = this.getResponsibleParties();
        Collection<ResponsibleParty> other$responsibleParties = other.getResponsibleParties();
        if (this$responsibleParties == null ? other$responsibleParties != null : !((Object)this$responsibleParties).equals(other$responsibleParties)) {
            return false;
        }
        Date this$creationTime = this.getCreationTime();
        Date other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Long this$geometricObjectCount = this.getGeometricObjectCount();
        Long other$geometricObjectCount = other.getGeometricObjectCount();
        if (this$geometricObjectCount == null ? other$geometricObjectCount != null : !((Object)this$geometricObjectCount).equals(other$geometricObjectCount)) {
            return false;
        }
        Date this$publicationTime = this.getPublicationTime();
        Date other$publicationTime = other.getPublicationTime();
        if (this$publicationTime == null ? other$publicationTime != null : !((Object)this$publicationTime).equals(other$publicationTime)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$abstractField = this.getAbstractField();
        String other$abstractField = other.getAbstractField();
        if (this$abstractField == null ? other$abstractField != null : !this$abstractField.equals(other$abstractField)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
            return false;
        }
        String this$credit = this.getCredit();
        String other$credit = other.getCredit();
        if (this$credit == null ? other$credit != null : !this$credit.equals(other$credit)) {
            return false;
        }
        Collection<Keyword> this$keywords = this.getKeywords();
        Collection<Keyword> other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords)) {
            return false;
        }
        DistributionInfo this$distributionInfo = this.getDistributionInfo();
        DistributionInfo other$distributionInfo = other.getDistributionInfo();
        if (this$distributionInfo == null ? other$distributionInfo != null : !((Object)this$distributionInfo).equals(other$distributionInfo)) {
            return false;
        }
        BoundingBox this$boundingBox = this.getBoundingBox();
        BoundingBox other$boundingBox = other.getBoundingBox();
        if (this$boundingBox == null ? other$boundingBox != null : !((Object)this$boundingBox).equals(other$boundingBox)) {
            return false;
        }
        Double this$spatialResolution = this.getSpatialResolution();
        Double other$spatialResolution = other.getSpatialResolution();
        if (this$spatialResolution == null ? other$spatialResolution != null : !((Object)this$spatialResolution).equals(other$spatialResolution)) {
            return false;
        }
        String this$topicCategory = this.getTopicCategory();
        String other$topicCategory = other.getTopicCategory();
        if (this$topicCategory == null ? other$topicCategory != null : !this$topicCategory.equals(other$topicCategory)) {
            return false;
        }
        String this$guidelinesConformityExplanation = this.getGuidelinesConformityExplanation();
        String other$guidelinesConformityExplanation = other.getGuidelinesConformityExplanation();
        if (this$guidelinesConformityExplanation == null ? other$guidelinesConformityExplanation != null : !this$guidelinesConformityExplanation.equals(other$guidelinesConformityExplanation)) {
            return false;
        }
        Boolean this$guidelinesConformityPass = this.getGuidelinesConformityPass();
        Boolean other$guidelinesConformityPass = other.getGuidelinesConformityPass();
        if (this$guidelinesConformityPass == null ? other$guidelinesConformityPass != null : !((Object)this$guidelinesConformityPass).equals(other$guidelinesConformityPass)) {
            return false;
        }
        String this$lineageStatement = this.getLineageStatement();
        String other$lineageStatement = other.getLineageStatement();
        return !(this$lineageStatement == null ? other$lineageStatement != null : !this$lineageStatement.equals(other$lineageStatement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetadataDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $UUIDIdentifier = this.getUUIDIdentifier();
        result = result * 59 + ($UUIDIdentifier == null ? 0 : $UUIDIdentifier.hashCode());
        Collection<ResponsibleParty> $responsibleParties = this.getResponsibleParties();
        result = result * 59 + ($responsibleParties == null ? 0 : ((Object)$responsibleParties).hashCode());
        Date $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 0 : ((Object)$creationTime).hashCode());
        Long $geometricObjectCount = this.getGeometricObjectCount();
        result = result * 59 + ($geometricObjectCount == null ? 0 : ((Object)$geometricObjectCount).hashCode());
        Date $publicationTime = this.getPublicationTime();
        result = result * 59 + ($publicationTime == null ? 0 : ((Object)$publicationTime).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        String $abstractField = this.getAbstractField();
        result = result * 59 + ($abstractField == null ? 0 : $abstractField.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 0 : $purpose.hashCode());
        String $credit = this.getCredit();
        result = result * 59 + ($credit == null ? 0 : $credit.hashCode());
        Collection<Keyword> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 0 : ((Object)$keywords).hashCode());
        DistributionInfo $distributionInfo = this.getDistributionInfo();
        result = result * 59 + ($distributionInfo == null ? 0 : ((Object)$distributionInfo).hashCode());
        BoundingBox $boundingBox = this.getBoundingBox();
        result = result * 59 + ($boundingBox == null ? 0 : ((Object)$boundingBox).hashCode());
        Double $spatialResolution = this.getSpatialResolution();
        result = result * 59 + ($spatialResolution == null ? 0 : ((Object)$spatialResolution).hashCode());
        String $topicCategory = this.getTopicCategory();
        result = result * 59 + ($topicCategory == null ? 0 : $topicCategory.hashCode());
        String $guidelinesConformityExplanation = this.getGuidelinesConformityExplanation();
        result = result * 59 + ($guidelinesConformityExplanation == null ? 0 : $guidelinesConformityExplanation.hashCode());
        Boolean $guidelinesConformityPass = this.getGuidelinesConformityPass();
        result = result * 59 + ($guidelinesConformityPass == null ? 0 : ((Object)$guidelinesConformityPass).hashCode());
        String $lineageStatement = this.getLineageStatement();
        result = result * 59 + ($lineageStatement == null ? 0 : $lineageStatement.hashCode());
        return result;
    }

    @ConstructorProperties(value={"UUIDIdentifier", "responsibleParties", "creationTime", "geometricObjectCount", "publicationTime", "title", "abstractField", "purpose", "credit", "keywords", "distributionInfo", "boundingBox", "spatialResolution", "topicCategory", "guidelinesConformityExplanation", "guidelinesConformityPass", "lineageStatement"})
    public MetadataDescriptor(String UUIDIdentifier, Collection<ResponsibleParty> responsibleParties, Date creationTime, Long geometricObjectCount, Date publicationTime, String title, String abstractField, String purpose, String credit, Collection<Keyword> keywords, DistributionInfo distributionInfo, BoundingBox boundingBox, Double spatialResolution, String topicCategory, String guidelinesConformityExplanation, Boolean guidelinesConformityPass, String lineageStatement) {
        this.UUIDIdentifier = UUIDIdentifier;
        this.responsibleParties = responsibleParties;
        this.creationTime = creationTime;
        this.geometricObjectCount = geometricObjectCount;
        this.publicationTime = publicationTime;
        this.title = title;
        this.abstractField = abstractField;
        this.purpose = purpose;
        this.credit = credit;
        this.keywords = keywords;
        this.distributionInfo = distributionInfo;
        this.boundingBox = boundingBox;
        this.spatialResolution = spatialResolution;
        this.topicCategory = topicCategory;
        this.guidelinesConformityExplanation = guidelinesConformityExplanation;
        this.guidelinesConformityPass = guidelinesConformityPass;
        this.lineageStatement = lineageStatement;
    }

    public String toString() {
        return "MetadataDescriptor(UUIDIdentifier=" + this.getUUIDIdentifier() + ", responsibleParties=" + this.getResponsibleParties() + ", creationTime=" + this.getCreationTime() + ", geometricObjectCount=" + this.getGeometricObjectCount() + ", publicationTime=" + this.getPublicationTime() + ", title=" + this.getTitle() + ", abstractField=" + this.getAbstractField() + ", purpose=" + this.getPurpose() + ", credit=" + this.getCredit() + ", keywords=" + this.getKeywords() + ", distributionInfo=" + this.getDistributionInfo() + ", boundingBox=" + this.getBoundingBox() + ", spatialResolution=" + this.getSpatialResolution() + ", topicCategory=" + this.getTopicCategory() + ", guidelinesConformityExplanation=" + this.getGuidelinesConformityExplanation() + ", guidelinesConformityPass=" + this.getGuidelinesConformityPass() + ", lineageStatement=" + this.getLineageStatement() + ")";
    }

    public MetadataDescriptor() {
    }
}

