/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.faults.EncryptionException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.utils.EncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeConfigurationUtils {
    private static final Logger log = LoggerFactory.getLogger(ScopeConfigurationUtils.class);

    static Set<ScopeConfiguration> fromMap(Map<String, ServiceEndpoint.Property> theMap, Properties parameters) throws EncryptionException {
        HashSet<ScopeConfiguration> toReturn = new HashSet<ScopeConfiguration>();
        Object[] suffixes = ScopeConfigurationUtils.getExistingSuffixes(theMap, parameters).split(",");
        log.debug("Suffixes to use are " + Arrays.toString(suffixes));
        for (Object suff : suffixes) {
            try {
                toReturn.add(ScopeConfigurationUtils.getConfigurationBySuffix(theMap, (String)suff, parameters));
            }
            catch (Exception e) {
                log.warn("Invalid configuration " + (String)suff, (Throwable)e);
            }
        }
        return toReturn;
    }

    static String getExistingSuffixes(Map<String, ServiceEndpoint.Property> props, Properties params) {
        if (!props.containsKey(params.getProperty("availableGroupSuffixList"))) {
            props.put(params.getProperty("availableGroupSuffixList"), new ServiceEndpoint.Property().nameAndValue(params.getProperty("availableGroupSuffixList"), ""));
        }
        return props.get(params.getProperty("availableGroupSuffixList")).value();
    }

    static ScopeConfiguration getConfigurationBySuffix(Map<String, ServiceEndpoint.Property> theMap, String suffix, Properties parameters) throws EncryptionException {
        HashMap<Account.Type, Account> accounts = new HashMap<Account.Type, Account>();
        String scopeAccountName = theMap.get(parameters.get("scopeUserPrefix") + suffix).value();
        String scopeAccountPassword = EncryptionUtils.decrypt(theMap.get(parameters.get("scopePasswordPrefix") + suffix).value());
        accounts.put(Account.Type.SCOPE, new Account(scopeAccountName, scopeAccountPassword, Account.Type.SCOPE));
        String ckanAccountName = theMap.get(parameters.get("ckanUserPrefix") + suffix).value();
        String ckanPassword = EncryptionUtils.decrypt(theMap.get(parameters.get("ckanPasswordPrefix") + suffix).value());
        accounts.put(Account.Type.CKAN, new Account(ckanAccountName, ckanPassword, Account.Type.CKAN));
        Integer publicGroup = Integer.parseInt(theMap.get(parameters.get("publicGroupPrefix") + suffix).value());
        Integer privateGroup = Integer.parseInt(theMap.get(parameters.get("privateGroupPrefix") + suffix).value());
        Integer defaultGroup = Integer.parseInt(theMap.get(parameters.get("defaultGroupPrefix") + suffix).value());
        String assignedScope = theMap.get(parameters.get("assignedScopePrefix") + suffix).value();
        return new ScopeConfiguration(assignedScope, publicGroup, privateGroup, accounts, defaultGroup);
    }

    public static ScopeConfiguration getByScope(Set<ScopeConfiguration> existing, String scope) throws MissingConfigurationException {
        for (ScopeConfiguration configuration : existing) {
            if (!configuration.getAssignedScope().equals(scope)) continue;
            return configuration;
        }
        throw new MissingConfigurationException("Scope " + scope + " has no configuration");
    }

    static String getSuffixByConfiguration(ScopeConfiguration toLookFor, Map<String, ServiceEndpoint.Property> map, Properties parameters) throws MissingConfigurationException {
        String defaultUser = toLookFor.getAccounts().get((Object)Account.Type.SCOPE).getUser();
        for (Map.Entry<String, ServiceEndpoint.Property> entry : map.entrySet()) {
            if (!entry.getValue().value().equals(defaultUser)) continue;
            return entry.getKey().substring(parameters.getProperty("scopeUserPrefix").length());
        }
        throw new MissingConfigurationException("Unable to find suffix for configuration " + toLookFor);
    }

    static Map<String, ServiceEndpoint.Property> asMap(ScopeConfiguration config, String toUseSuffix, Properties parameters) {
        HashMap<String, ServiceEndpoint.Property> toReturn = new HashMap<String, ServiceEndpoint.Property>();
        toReturn.put(parameters.getProperty("assignedScopePrefix") + toUseSuffix, new ServiceEndpoint.Property().nameAndValue(parameters.getProperty("assignedScopePrefix") + toUseSuffix, config.getAssignedScope()));
        Account scopeAccount = config.getAccounts().get((Object)Account.Type.SCOPE);
        toReturn.put(parameters.getProperty("scopeUserPrefix") + toUseSuffix, new ServiceEndpoint.Property().nameAndValue(parameters.getProperty("scopeUserPrefix") + toUseSuffix, scopeAccount.getUser()));
        toReturn.put(parameters.getProperty("scopePasswordPrefix") + toUseSuffix, new ServiceEndpoint.Property().encrypted(true).nameAndValue(parameters.getProperty("scopePasswordPrefix") + toUseSuffix, EncryptionUtils.encrypt(scopeAccount.getPassword())));
        Account ckanAccount = config.getAccounts().get((Object)Account.Type.CKAN);
        toReturn.put(parameters.getProperty("ckanUserPrefix") + toUseSuffix, new ServiceEndpoint.Property().nameAndValue(parameters.getProperty("ckanUserPrefix") + toUseSuffix, ckanAccount.getUser()));
        toReturn.put(parameters.getProperty("ckanPasswordPrefix") + toUseSuffix, new ServiceEndpoint.Property().encrypted(true).nameAndValue(parameters.getProperty("ckanPasswordPrefix") + toUseSuffix, EncryptionUtils.encrypt(ckanAccount.getPassword())));
        toReturn.put(parameters.getProperty("defaultGroupPrefix") + toUseSuffix, new ServiceEndpoint.Property().nameAndValue(parameters.getProperty("defaultGroupPrefix") + toUseSuffix, config.getDefaultGroup().toString()));
        toReturn.put(parameters.getProperty("publicGroupPrefix") + toUseSuffix, new ServiceEndpoint.Property().nameAndValue(parameters.getProperty("publicGroupPrefix") + toUseSuffix, config.getPublicGroup().toString()));
        toReturn.put(parameters.getProperty("privateGroupPrefix") + toUseSuffix, new ServiceEndpoint.Property().nameAndValue(parameters.getProperty("privateGroupPrefix") + toUseSuffix, config.getPrivateGroup().toString()));
        return toReturn;
    }

    static Map<String, ServiceEndpoint.Property> insertSuffix(Map<String, ServiceEndpoint.Property> toUpdate, String toAddSuffix, Properties params) {
        String current = ScopeConfigurationUtils.getExistingSuffixes(toUpdate, params);
        String toSet = current.length() > 0 ? current + "," + toAddSuffix : toAddSuffix;
        toUpdate.put(params.getProperty("availableGroupSuffixList"), new ServiceEndpoint.Property().nameAndValue(params.getProperty("availableGroupSuffixList"), toSet));
        return toUpdate;
    }

    static String generateSuffix(String existingSuffixes) {
        log.debug("Generating suffix, existing are : " + existingSuffixes);
        String[] suffixArray = existingSuffixes.split(",");
        int maxIndex = 0;
        for (String suff : suffixArray) {
            try {
                int actual = Integer.parseInt(suff);
                if (actual <= maxIndex) continue;
                maxIndex = actual;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        String generated = maxIndex + 1 + "";
        log.debug("Generated suffix is : " + generated);
        return generated;
    }
}

