/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPriv;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.gcube.spatial.data.geonetwork.configuration.ScopeConfigurationUtils;
import org.gcube.spatial.data.geonetwork.configuration.XMLAdapter;
import org.gcube.spatial.data.geonetwork.extension.GNClientExtension;
import org.gcube.spatial.data.geonetwork.extension.ServerAccess;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.model.faults.AuthorizationException;
import org.gcube.spatial.data.geonetwork.model.faults.GeoNetworkException;
import org.gcube.spatial.data.geonetwork.model.faults.InvalidInsertConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingServiceEndpointException;
import org.gcube.spatial.data.geonetwork.utils.GroupUtils;
import org.gcube.spatial.data.geonetwork.utils.RuntimeParameters;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.geotoolkit.xml.XML;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.opengis.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoNetwork
implements GeoNetworkAdministration {
    private static final Logger log = LoggerFactory.getLogger(GeoNetwork.class);
    private static XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
    private Configuration config;
    private GNClientExtension theClient = null;
    private ServerAccess currentAccess = null;
    private List<XMLAdapter> registeredXMLAdapters = new ArrayList<XMLAdapter>();

    public static GeoNetworkAdministration get() throws Exception {
        return new GeoNetwork(ConfigurationManager.get());
    }

    public static GeoNetworkAdministration get(Configuration config) throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        return new GeoNetwork(config);
    }

    private GeoNetwork(Configuration config) throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        this.config = config;
        log.debug("Checking scope configuration..");
        try {
            ScopeConfiguration scopeConfiguration = config.getScopeConfiguration();
        }
        catch (MissingConfigurationException e) {
            log.trace("Configuration not found for current scope " + ScopeUtils.getCurrentScope() + "acquiring one..");
            this.acquireConfiguration();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void login(LoginLevel lvl) throws AuthorizationException, MissingServiceEndpointException, MissingConfigurationException {
        String user = null;
        String password = null;
        switch (lvl) {
            case ADMIN: {
                user = this.config.getAdminAccount().getUser();
                password = this.config.getAdminAccount().getPassword();
                break;
            }
            case CKAN: {
                ScopeConfiguration scopeConfiguration = this.config.getScopeConfiguration();
                Account account = scopeConfiguration.getAccounts().get((Object)Account.Type.CKAN);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
            default: {
                ScopeConfiguration scopeConfiguration = this.config.getScopeConfiguration();
                Account account = scopeConfiguration.getAccounts().get((Object)Account.Type.SCOPE);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
        }
        this.setAccess(new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion(), true, password, user, lvl));
        this.getClient();
    }

    private ServerAccess getAccess(ScopeConfiguration scopeConfig, LoginLevel lvl) throws MissingServiceEndpointException {
        String user = null;
        String password = null;
        switch (lvl) {
            case ADMIN: {
                user = this.config.getAdminAccount().getUser();
                password = this.config.getAdminAccount().getPassword();
                break;
            }
            case CKAN: {
                ScopeConfiguration scopeConfiguration = scopeConfig;
                Account account = scopeConfiguration.getAccounts().get((Object)Account.Type.CKAN);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
            default: {
                ScopeConfiguration scopeConfiguration = scopeConfig;
                Account account = scopeConfiguration.getAccounts().get((Object)Account.Type.SCOPE);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
        }
        return new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion(), true, password, user, lvl);
    }

    @Override
    public void logout() throws MissingServiceEndpointException {
        this.setAccess(new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion()));
    }

    @Override
    public GNSearchResponse query(GNSearchRequest request) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().search(request);
    }

    @Override
    public GNSearchResponse query(File fileRequest) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().search(fileRequest);
    }

    @Override
    public Metadata getById(long id) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        String xml = out.outputString(this.getClient().get(id));
        return (Metadata)XML.unmarshal((String)xml);
    }

    @Override
    public Metadata getById(String UUID) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return (Metadata)XML.unmarshal((String)this.getByIdAsRawString(UUID));
    }

    @Override
    public String getByIdAsRawString(String UUID) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return out.outputString(this.getClient().get(UUID));
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.setPrivileges(metadataId, cfg);
    }

    private void setPrivileges(long metadataId, ScopeConfiguration toUseConfig, LoginLevel toUseLevel) throws MissingConfigurationException, MissingServiceEndpointException, GNLibException, GNServerException {
        GNPrivConfiguration cfg = null;
        switch (toUseLevel) {
            case ADMIN: {
                break;
            }
            case CKAN: {
                break;
            }
            case DEFAULT: {
                cfg = new GNPrivConfiguration();
                cfg.addPrivileges(toUseConfig.getDefaultGroup(), EnumSet.of(GNPriv.VIEW, GNPriv.FEATURED));
                break;
            }
            case PRIVATE: {
                cfg = new GNPrivConfiguration();
                cfg.addPrivileges(toUseConfig.getPrivateGroup(), EnumSet.of(GNPriv.VIEW, GNPriv.FEATURED));
                break;
            }
            case SCOPE: {
                cfg = new GNPrivConfiguration();
                cfg.addPrivileges(toUseConfig.getPublicGroup(), EnumSet.of(GNPriv.VIEW, GNPriv.FEATURED));
            }
        }
        if (cfg != null) {
            log.debug("Setting privileges... ");
            this.setPrivileges(metadataId, cfg);
        }
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        this.checkPublishingConfiguration(configuration, this.config.getScopeConfiguration());
        GNClientExtension client = this.getClient();
        long toReturn = client.insertMetadata(configuration, metadataFile);
        this.setPrivileges(toReturn, this.config.getScopeConfiguration(), this.getCurrentLoginLevel());
        return toReturn;
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        return this.insertMetadata(configuration, GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public long insertMetadata(File requestFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException {
        GNClientExtension client = this.getClient();
        long toReturn = client.insertRequest(requestFile);
        this.setPrivileges(toReturn, this.config.getScopeConfiguration(), this.getCurrentLoginLevel());
        return toReturn;
    }

    @Override
    public long insertMetadata(Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException {
        return this.insertMetadata(GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public long insertAndPromoteMetadata(File requestFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException {
        LoginLevel currentLevel = this.getCurrentLoginLevel();
        ScopeConfiguration parentConfig = this.getParentConfiguration();
        ServerAccess parentAccess = this.getAccess(parentConfig, LoginLevel.DEFAULT);
        this.setAccess(parentAccess);
        GNClientExtension client = this.getClient();
        long toReturn = client.insertRequest(requestFile);
        this.setPrivileges(toReturn, parentConfig, LoginLevel.DEFAULT);
        try {
            this.login(currentLevel);
        }
        catch (AuthorizationException e) {
            throw new GNLibException("Unabel to restore level. This should not happen.", (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public long insertAndPromoteMetadata(GNInsertConfiguration configuration, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        LoginLevel currentLevel = this.getCurrentLoginLevel();
        ScopeConfiguration parentConfig = this.getParentConfiguration();
        ServerAccess parentAccess = this.getAccess(parentConfig, LoginLevel.DEFAULT);
        this.setAccess(parentAccess);
        GNInsertConfiguration toUseConfig = null;
        try {
            toUseConfig = this.getUserConfiguration(configuration.getCategory(), configuration.getStyleSheet(), parentConfig, LoginLevel.DEFAULT);
        }
        catch (GeoNetworkException e) {
            throw new GNLibException("Unabel to get publish configuration ", (Throwable)e);
        }
        this.checkPublishingConfiguration(toUseConfig, parentConfig);
        GNClientExtension client = this.getClient();
        long toReturn = client.insertMetadata(toUseConfig, metadataFile);
        this.setPrivileges(toReturn, parentConfig, LoginLevel.DEFAULT);
        try {
            this.login(currentLevel);
        }
        catch (AuthorizationException e) {
            throw new GNLibException("Unabel to restore level. This should not happen.", (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public long insertAndPromoteMetadata(GNInsertConfiguration configuration, Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        return this.insertAndPromoteMetadata(configuration, GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public long insertAndPromoteMetadata(Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException {
        return this.insertAndPromoteMetadata(GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    private ScopeConfiguration getParentConfiguration() throws MissingConfigurationException, MissingServiceEndpointException {
        ArrayList<String> parent = ScopeUtils.getParentScopes();
        return ScopeConfigurationUtils.getByScope(this.config.getExistingConfigurations(), parent.get(parent.size() - 1));
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.updateMetadata(id, metadataFile);
    }

    @Override
    public void updateMetadata(long id, Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException {
        this.updateMetadata(id, GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.deleteMetadata(id);
    }

    @Override
    public GNInsertConfiguration getCurrentUserConfiguration(String category, String styleSheet) throws AuthorizationException, GeoNetworkException {
        if (this.getCurrentLoginLevel() == null) {
            throw new AuthorizationException("Client is not authenticated, please use Login before publishing");
        }
        return this.getUserConfiguration(category, styleSheet, this.config.getScopeConfiguration(), this.getCurrentLoginLevel());
    }

    public GNInsertConfiguration getUserConfiguration(String category, String styleSheet, ScopeConfiguration configuration, LoginLevel lvl) throws AuthorizationException, GeoNetworkException {
        Integer configuredGroup = null;
        switch (this.getCurrentLoginLevel()) {
            case CKAN: {
                throw new AuthorizationException("Current logged level " + (Object)((Object)this.getCurrentLoginLevel()) + "is read-only");
            }
            case ADMIN: {
                throw new GeoNetworkException("Current logged level is Admin, unable to determine publihing configuration");
            }
            case DEFAULT: {
                configuredGroup = configuration.getDefaultGroup();
                break;
            }
            case PRIVATE: {
                configuredGroup = configuration.getPrivateGroup();
                break;
            }
            case SCOPE: {
                configuredGroup = configuration.getPublicGroup();
            }
        }
        return new GNInsertConfiguration(configuredGroup + "", category, styleSheet, Boolean.valueOf(true));
    }

    @Override
    public Group createGroup(String name, String description, String mail, Integer id) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.createGroup(name, description, mail, id);
        long submitTime = System.currentTimeMillis();
        long timeout = 500L;
        long wait = 100L;
        try {
            timeout = Long.parseLong(new RuntimeParameters().getProps().getProperty("geonetworkUpdateTimeout"));
            wait = Long.parseLong(new RuntimeParameters().getProps().getProperty("geonetworkUpdateWait"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read GN polling parameters from local configuration", e);
        }
        log.debug("Waiting for created group to be available, timeout is {} ", (Object)timeout);
        Group created = null;
        do {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((created = GroupUtils.getByName(this.getClient().getGroups(), name)) == null && System.currentTimeMillis() - submitTime <= timeout);
        log.error("GN Update timeout {}ms reached. Group [ID : {}, name : {} ] not created.", new Object[]{timeout, id, name});
        if (created == null) {
            throw new GNServerException("Reached timeout while creating group with id " + id);
        }
        return created;
    }

    @Override
    public Set<Group> getGroups() throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().getGroups();
    }

    @Override
    public String getAvailableOwnershipTransfer(Integer userId) throws GNServerException, MissingServiceEndpointException, GNLibException {
        return this.getClient().getPossibleOwnershipTransfer(userId);
    }

    @Override
    public String getMetadataOwners() throws GNServerException, MissingServiceEndpointException, GNLibException {
        return this.getClient().getMetadataOwners();
    }

    private ScopeConfiguration acquireConfiguration() throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        ScopeConfiguration acquired = null;
        try {
            acquired = this.config.acquireConfiguration();
        }
        catch (MissingConfigurationException e) {
            acquired = this.createCurrentScopeConfiguration();
            this.config.createScopeConfiguration(acquired);
        }
        this.updateRightsOnAcquiredConfiguration(acquired);
        return acquired;
    }

    @Override
    public Set<User> getUsers() throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().getUsers();
    }

    @Override
    public User createUsers(String username, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException, GNServerException, MissingServiceEndpointException {
        this.getClient().createUser(username, password, profile, groups);
        long submitTime = System.currentTimeMillis();
        long timeout = 500L;
        long wait = 100L;
        try {
            timeout = Long.parseLong(new RuntimeParameters().getProps().getProperty("geonetworkUpdateTimeout"));
            wait = Long.parseLong(new RuntimeParameters().getProps().getProperty("geonetworkUpdateWait"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read GN polling parameters from local configuration", e);
        }
        log.debug("Waiting for created group to be available, timeout is {} ", (Object)timeout);
        User created = null;
        do {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((created = UserUtils.getByName(this.getClient().getUsers(), username)) == null && System.currentTimeMillis() - submitTime <= timeout);
        log.error("GN Update timeout {}ms reached. User {} not created.", (Object)timeout, (Object)username);
        if (created == null) {
            throw new GNServerException("Reached timeout while creating user " + username);
        }
        return created;
    }

    @Override
    public void assignOwnership(List<Long> toTransferIds, Integer targetUserId, Integer targetGroupId) throws AuthorizationException, GNServerException, MissingServiceEndpointException, GNLibException {
        if (this.getCurrentLoginLevel() == null || !this.getCurrentLoginLevel().equals((Object)LoginLevel.ADMIN)) {
            throw new AuthorizationException("You need to login as Admin to massively transfer ownership");
        }
        this.getClient().assignOwnership(toTransferIds, targetUserId, targetGroupId);
    }

    @Override
    public void transferOwnership(Integer sourceUserId, Integer sourceGroupId, Integer targetUserId, Integer targetGroupId) throws GNServerException, MissingServiceEndpointException, GNLibException {
        this.getClient().transferOwnership(sourceUserId, sourceGroupId, targetUserId, targetGroupId);
    }

    private ScopeConfiguration createCurrentScopeConfiguration() throws GNLibException, GNServerException, MissingServiceEndpointException {
        try {
            String currentScopeName = ScopeUtils.getCurrentScopeName();
            log.debug("Generating configuration for scope " + currentScopeName);
            this.login(LoginLevel.ADMIN);
            RuntimeParameters props = new RuntimeParameters();
            Integer nameLength = Integer.parseInt(props.getProps().getProperty("GNUniqueNameLength"));
            Integer passwordLength = Integer.parseInt(props.getProps().getProperty("GNPasswordLength"));
            Group privateGroup = GroupUtils.generateRandomGroup(this.getGroups(), nameLength);
            log.debug("Creating private group {} ", (Object)privateGroup);
            this.createGroup(privateGroup.getName(), "Private group for scope " + currentScopeName, "none", privateGroup.getId());
            Group publicGroup = GroupUtils.generateRandomGroup(this.getGroups(), nameLength);
            log.debug("Creating public group {} ", (Object)publicGroup);
            this.createGroup(publicGroup.getName(), "Public group for scope " + currentScopeName, "none", publicGroup.getId());
            Set<Group> existingGroups = this.getGroups();
            privateGroup = GroupUtils.getByName(existingGroups, privateGroup.getName());
            log.debug("Resulting private group : " + privateGroup);
            publicGroup = GroupUtils.getByName(existingGroups, publicGroup.getName());
            log.debug("Resulting publicGroup : " + publicGroup);
            User ckanUser = UserUtils.generateRandomUser(this.getUsers(), nameLength, passwordLength);
            log.debug("Creating ckan user..");
            HashSet<Integer> scopeAccessibleGroups = new HashSet<Integer>();
            scopeAccessibleGroups.add(publicGroup.getId());
            scopeAccessibleGroups.add(privateGroup.getId());
            this.createUsers(ckanUser.getUsername(), ckanUser.getPassword(), User.Profile.Reviewer, scopeAccessibleGroups);
            User scopeUser = UserUtils.generateRandomUser(this.getUsers(), nameLength, passwordLength);
            log.debug("Creating scope user..");
            this.createUsers(scopeUser.getUsername(), scopeUser.getPassword(), User.Profile.Reviewer, scopeAccessibleGroups);
            this.logout();
            HashMap<Account.Type, Account> accounts = new HashMap<Account.Type, Account>();
            accounts.put(Account.Type.CKAN, new Account(ckanUser.getUsername(), ckanUser.getPassword(), Account.Type.CKAN));
            accounts.put(Account.Type.SCOPE, new Account(scopeUser.getUsername(), scopeUser.getPassword(), Account.Type.SCOPE));
            return new ScopeConfiguration(currentScopeName, publicGroup.getId(), privateGroup.getId(), accounts, publicGroup.getId());
        }
        catch (Exception e) {
            throw new GNLibException("Unable to create scope configuration", (Throwable)e);
        }
    }

    private void updateRightsOnAcquiredConfiguration(ScopeConfiguration scopeConfig) throws MissingServiceEndpointException, AuthorizationException, GNLibException, GNServerException, MissingConfigurationException {
        Set<ScopeConfiguration> parentConfigurations = this.config.getParentScopesConfiguration();
        this.login(LoginLevel.ADMIN);
        GNClientExtension client = this.getClient();
        HashSet<Integer> parentVisibleGroups = new HashSet<Integer>();
        for (ScopeConfiguration conf : parentConfigurations) {
            parentVisibleGroups.add(conf.getPrivateGroup());
            parentVisibleGroups.add(conf.getPublicGroup());
        }
        Set<User> existingUsers = this.getUsers();
        User scopeUser = UserUtils.getByName(existingUsers, scopeConfig.getAccounts().get((Object)Account.Type.SCOPE).getUser());
        log.debug("Updating scope user..");
        client.editUser(scopeUser, parentVisibleGroups);
        for (ScopeConfiguration conf : parentConfigurations) {
            log.debug("Updating parent user for scope " + conf.getAssignedScope());
            User toUpdateUser = UserUtils.getByName(existingUsers, conf.getAccounts().get((Object)Account.Type.SCOPE).getUser());
            client.editUser(toUpdateUser, Collections.singleton(scopeConfig.getPublicGroup()));
        }
        this.logout();
    }

    @Override
    public void registerXMLAdapter(XMLAdapter adapter) {
        this.registeredXMLAdapters.add(adapter);
    }

    private void setAccess(ServerAccess access) {
        this.currentAccess = access;
        this.theClient = null;
    }

    private ServerAccess getCurrentAccess() throws MissingServiceEndpointException {
        if (this.currentAccess == null) {
            this.currentAccess = new ServerAccess(this.config.getGeoNetworkEndpoint(), this.config.getGeoNetworkVersion());
        }
        return this.currentAccess;
    }

    private LoginLevel getCurrentLoginLevel() throws MissingServiceEndpointException {
        return this.getCurrentAccess().getLoggedLevel();
    }

    private synchronized GNClientExtension getClient() throws MissingServiceEndpointException {
        if (this.theClient == null) {
            this.theClient = new GNClientExtension(this.getCurrentAccess());
        }
        return this.theClient;
    }

    private void checkPublishingConfiguration(GNInsertConfiguration configuration, ScopeConfiguration toUseConfig) throws AuthorizationException, InvalidInsertConfigurationException, MissingConfigurationException, MissingServiceEndpointException {
        if (this.getCurrentLoginLevel() == null) {
            throw new AuthorizationException("Client is not authenticated, please use Login before publishing");
        }
        if (!configuration.getValidate().booleanValue()) {
            throw new InvalidInsertConfigurationException("Validate option is mandatory");
        }
        Integer targetGroup = Integer.parseInt(configuration.getGroup());
        Integer configuredGroup = null;
        switch (this.getCurrentLoginLevel()) {
            case CKAN: {
                throw new AuthorizationException("Current logged level " + (Object)((Object)this.getCurrentLoginLevel()) + "is read-only");
            }
            case ADMIN: {
                break;
            }
            case DEFAULT: {
                configuredGroup = toUseConfig.getDefaultGroup();
                break;
            }
            case PRIVATE: {
                configuredGroup = toUseConfig.getPrivateGroup();
                break;
            }
            case SCOPE: {
                configuredGroup = toUseConfig.getPublicGroup();
            }
        }
        if (configuredGroup != null && !targetGroup.equals(configuredGroup)) {
            throw new InvalidInsertConfigurationException(String.format("Invalid logged level %s and specified group %d, expected %d", new Object[]{this.getCurrentLoginLevel(), targetGroup, configuredGroup}));
        }
    }

    private static File meta2File(Metadata meta, List<XMLAdapter> adapters) throws IOException, JAXBException {
        File temp = File.createTempFile("meta", ".xml");
        FileWriter writer = new FileWriter(temp);
        String marshalled = XML.marshal((Object)meta);
        for (XMLAdapter adapter : adapters) {
            marshalled = adapter.adaptXML(marshalled);
        }
        writer.write(marshalled);
        writer.close();
        return temp;
    }
}

