/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.configuration;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ScopeConfigurationUtils;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.faults.EncryptionException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingServiceEndpointException;
import org.gcube.spatial.data.geonetwork.utils.EncryptionUtils;
import org.gcube.spatial.data.geonetwork.utils.RuntimeParameters;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfiguration
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfiguration.class);
    private final Object $lock = new Object[0];
    static Properties props = null;
    private static String geonetworkCategory;
    private static String geonetworkPlatformName;
    private static String endpointName;
    private static String priorityProperty;
    private String geonetworkUrl = null;
    private String adminUserValue = null;
    private String adminPasswordValue = null;
    private ScopeConfiguration configuration = null;
    private boolean loaded = false;

    static {
        log.debug("Loading properties");
        try {
            props = new RuntimeParameters().getProps();
            log.trace("LOADED PROPERTIES : " + props);
            geonetworkCategory = props.getProperty("geonetworkCategory");
            geonetworkPlatformName = props.getProperty("geonetworkPlatformName");
            endpointName = props.getProperty("geonetworkEndpointName");
            priorityProperty = props.getProperty("priorityProperty");
        }
        catch (Exception e) {
            log.error("Unable to load properties", (Throwable)e);
        }
    }

    @Override
    public Account getAdminAccount() throws MissingServiceEndpointException {
        this.loadFromIs();
        return new Account(this.adminUserValue, this.adminPasswordValue, Account.Type.SCOPE);
    }

    @Override
    public String getGeoNetworkEndpoint() throws MissingServiceEndpointException {
        this.loadFromIs();
        return this.geonetworkUrl;
    }

    @Override
    public ScopeConfiguration getScopeConfiguration() throws MissingConfigurationException, MissingServiceEndpointException {
        this.loadFromIs();
        if (this.configuration == null) {
            throw new MissingConfigurationException("Scope not configured.");
        }
        return this.configuration;
    }

    @Override
    public void createScopeConfiguration(ScopeConfiguration toCreate) throws MissingServiceEndpointException {
        this.storeAndReload(toCreate);
    }

    @Override
    public ScopeConfiguration acquireConfiguration() throws MissingServiceEndpointException, MissingConfigurationException {
        log.debug("Loading existing configurations");
        Set<ScopeConfiguration> existing = this.getExistingConfigurations();
        log.debug("Found " + existing.size() + " configurations, checking for availability");
        ScopeConfiguration available = ScopeConfigurationUtils.getByScope(existing, ScopeConfiguration.NOT_ASSIGNED);
        available.setAssignedScope(ScopeUtils.getCurrentScopeName());
        this.storeAndReload(available);
        return this.configuration;
    }

    @Override
    public Set<ScopeConfiguration> getExistingConfigurations() throws MissingServiceEndpointException {
        return ScopeConfigurationUtils.fromMap(this.getIsAccessPoint().propertyMap(), props);
    }

    @Override
    public Set<ScopeConfiguration> getParentScopesConfiguration() throws MissingServiceEndpointException {
        Set<String> parentScopes = ScopeUtils.getParentScopes();
        HashSet<ScopeConfiguration> toReturn = new HashSet<ScopeConfiguration>();
        if (!parentScopes.isEmpty()) {
            Set<ScopeConfiguration> existing = this.getExistingConfigurations();
            for (String parent : parentScopes) {
                try {
                    toReturn.add(ScopeConfigurationUtils.getByScope(existing, parent));
                }
                catch (MissingConfigurationException e) {
                    log.warn("Parent scope {} found but no related configuration. Existing {}", (Object)parent, (Object)existing.toString());
                }
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromIs() throws MissingServiceEndpointException {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.loaded) {
                log.debug("IS Information  not loaded, doing it now..");
                ServiceEndpoint.AccessPoint point = this.getIsAccessPoint();
                Map properties = point.propertyMap();
                this.geonetworkUrl = point.address();
                log.debug("Found master endpoint @ " + point.address() + ", loading configuration map");
                this.adminUserValue = point.username();
                this.adminPasswordValue = EncryptionUtils.decrypt(point.password());
                try {
                    this.configuration = ScopeConfigurationUtils.getByScope(ScopeConfigurationUtils.fromMap(properties, props), ScopeUtils.getCurrentScopeName());
                    log.debug("Loaded config : " + this.configuration);
                    this.loaded = true;
                }
                catch (MissingConfigurationException e) {
                    log.debug("Configuration not found for current scope " + ScopeUtils.getCurrentScopeName());
                    this.configuration = null;
                }
            }
        }
    }

    protected ServiceEndpoint.AccessPoint getIsAccessPoint() throws MissingServiceEndpointException {
        log.debug("Querying IS for Geonetwork information..");
        List<ServiceEndpoint> endpoints = this.doTheQuery(geonetworkCategory, geonetworkPlatformName);
        log.debug("Found " + endpoints.size() + " ServiceEndpoints");
        ServiceEndpoint.AccessPoint point = DefaultConfiguration.getTheRightAccessPoint(endpoints.toArray(new ServiceEndpoint[endpoints.size()]));
        if (point != null) {
            return point;
        }
        throw new MissingServiceEndpointException("No Resource found under current scope " + ScopeProvider.instance.get());
    }

    protected ServiceEndpoint getISServiceEndpoint() throws MissingServiceEndpointException {
        log.debug("Querying IS for Geonetwork information..");
        List<ServiceEndpoint> endpoints = this.doTheQuery(geonetworkCategory, geonetworkPlatformName);
        log.debug("Found " + endpoints.size() + " ServiceEndpoints");
        ServiceEndpoint se = DefaultConfiguration.getTheRightServiceEndpoint(endpoints.toArray(new ServiceEndpoint[endpoints.size()]));
        if (se != null) {
            return se;
        }
        throw new MissingServiceEndpointException("No Resource found under current scope " + ScopeProvider.instance.get());
    }

    protected static final ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint ... resources) {
        ServiceEndpoint.AccessPoint toReturn = null;
        int priority = 1000;
        ServiceEndpoint[] serviceEndpointArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceEndpoint resource = serviceEndpointArray[n2];
            for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
                Map properties;
                log.debug(point.toString());
                if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
                int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
                if (toReturn != null && currentPriority >= priority) continue;
                toReturn = point;
                priority = currentPriority;
            }
            ++n2;
        }
        return toReturn;
    }

    protected static final ServiceEndpoint getTheRightServiceEndpoint(ServiceEndpoint ... resources) {
        ServiceEndpoint toReturn = null;
        int priority = 1000;
        ServiceEndpoint[] serviceEndpointArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceEndpoint resource = serviceEndpointArray[n2];
            for (ServiceEndpoint.AccessPoint point : resource.profile().accessPoints()) {
                Map properties;
                log.debug(point.toString());
                if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(priorityProperty)) continue;
                int currentPriority = Integer.parseInt(((ServiceEndpoint.Property)properties.get(priorityProperty)).value());
                if (toReturn != null && currentPriority >= priority) continue;
                toReturn = resource;
                priority = currentPriority;
            }
            ++n2;
        }
        return toReturn;
    }

    protected List<ServiceEndpoint> doTheQuery(String geonetworkCategory, String geonetworkPlatformName) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + geonetworkCategory + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + geonetworkPlatformName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    protected void storeAndReload(ScopeConfiguration toStore) throws MissingServiceEndpointException {
        log.debug("Going to store : " + toStore);
        ServiceEndpoint toUpdateResource = this.getISServiceEndpoint();
        Map accessPointConfiguration = DefaultConfiguration.getTheRightAccessPoint(toUpdateResource).propertyMap();
        String toUseSuffix = null;
        try {
            toUseSuffix = ScopeConfigurationUtils.getSuffixByConfiguration(toStore, accessPointConfiguration, props);
            log.debug("Configuration was already defined, updateing it");
        }
        catch (MissingConfigurationException e) {
            log.debug("Configuration is new, selecting new suffix");
            toUseSuffix = ScopeConfigurationUtils.generateSuffix(ScopeConfigurationUtils.getExistingSuffixes(accessPointConfiguration, props));
            ScopeConfigurationUtils.insertSuffix(accessPointConfiguration, toUseSuffix, props);
        }
        log.debug("Suffix for configuration is " + toUseSuffix);
        Map<String, ServiceEndpoint.Property> toAddValues = ScopeConfigurationUtils.asMap(toStore, toUseSuffix, props);
        accessPointConfiguration.putAll(toAddValues);
        DefaultConfiguration.getTheRightAccessPoint(toUpdateResource).properties().addAll(accessPointConfiguration.values());
        DefaultConfiguration.update(toUpdateResource);
        this.loaded = false;
        this.waitForISUpdate(toAddValues);
    }

    private void waitForISUpdate(Map<String, ServiceEndpoint.Property> toLookFor) throws MissingServiceEndpointException {
        boolean updated = false;
        boolean continuePolling = true;
        long maxWait = Long.parseLong(props.getProperty("isMaxWaitTimeMillis"));
        long wait = 500L;
        long startPollingTime = System.currentTimeMillis();
        while (!updated && continuePolling) {
            try {
                log.debug("Wating for IS [elapsedTime {}, max wait {}]", (Object)(System.currentTimeMillis() - startPollingTime), (Object)maxWait);
                Thread.sleep(wait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.debug("loading IS information");
            ServiceEndpoint toUpdateResource = this.getISServiceEndpoint();
            Map accessPointConfiguration = DefaultConfiguration.getTheRightAccessPoint(toUpdateResource).propertyMap();
            for (Map.Entry<String, ServiceEndpoint.Property> toLookForEntry : toLookFor.entrySet()) {
                if (accessPointConfiguration.containsKey(toLookForEntry.getKey()) && ((ServiceEndpoint.Property)accessPointConfiguration.get(toLookForEntry.getKey())).equals((Object)toLookForEntry.getValue())) {
                    updated = true;
                    continue;
                }
                updated = false;
                break;
            }
            wait *= 2L;
            boolean bl = continuePolling = System.currentTimeMillis() - startPollingTime < maxWait;
        }
        if (!updated) {
            log.warn("Polling timeout reached, IS was not updated");
        }
    }

    protected static ServiceEndpoint update(ServiceEndpoint toStore) {
        RegistryPublisher rp = RegistryPublisherFactory.create();
        return (ServiceEndpoint)rp.update((Resource)toStore);
    }
}

