/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.extension;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.spatial.data.geonetwork.model.User;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataAdminExtension {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataAdminExtension.class);
    private static final XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
    private static final String CREATE_GROUP_METHOD = "/srv/en/group.update";
    private static final String GROUP_LIST_METHOD = "/srv/en/xml.group.list";
    private static final String USER_LIST_METHOD = "/srv/en/xml.user.list";
    private static final String CREATE_USER_METHOD = "/srv/en/user.update";
    private static final String GET_GROUPS_BY_USER = "/srv/en/xml.usergroups.list";
    private static final String METADATA_SELECT = "/srv/en/metadata.select";
    private static final String ASSIGN_MASSIVE_OWNERSHIP = "/srv/en/metadata.massive.newowner";
    private static final String AVAILABLE_OWNERSHIP = "/srv/en/xml.ownership.groups";
    private static final String METADATA_OWNERS = "/srv/en/xml.ownership.editors";
    private static final String TRANSFER_OWNSERSHIP = "/srv/en/xml.ownership.transfer";

    public static String allowedOwnershipTransfer(HTTPUtils connection, String gnServiceUrl, Integer userId) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Getting available ownership transfer for user " + userId));
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("id").setText("" + userId));
        return GNMetadataAdminExtension.gnCall(connection, gnServiceUrl, request, AVAILABLE_OWNERSHIP);
    }

    public static String metadataOwners(HTTPUtils connection, String gnServiceUrl) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting metadata owners");
        }
        Element request = new Element("request");
        return GNMetadataAdminExtension.gnCall(connection, gnServiceUrl, request, METADATA_OWNERS);
    }

    public static String selectMeta(HTTPUtils connection, String gnServiceUrl, List<Long> toSelectIds) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Massive metadata selection..");
        }
        Element request = GNMetadataAdminExtension.buildSelectMetadata(toSelectIds);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceUrl, request, METADATA_SELECT);
    }

    public static String clearMetaSelection(HTTPUtils connection, String gnServiceUrl) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Massive metadata selection..");
        }
        Element request = GNMetadataAdminExtension.buildClearMetaSelection();
        return GNMetadataAdminExtension.gnCall(connection, gnServiceUrl, request, METADATA_SELECT);
    }

    public static String assignMassiveOwnership(HTTPUtils connection, String gnServiceUrl, Integer userId, Integer groupId) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Assign massive ownership..");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("user").setText("" + userId));
        request.addContent((Content)new Element("group").setText("" + groupId));
        return GNMetadataAdminExtension.gnCall(connection, gnServiceUrl, request, ASSIGN_MASSIVE_OWNERSHIP);
    }

    public static String transferOwnership(HTTPUtils connection, String gnServiceUrl, Integer sourceUserId, Integer sourceGroupId, Integer destUserId, Integer destGroupId) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Transfering ownership..");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("sourceUser").setText("" + sourceUserId));
        request.addContent((Content)new Element("sourceGroup").setText("" + sourceGroupId));
        request.addContent((Content)new Element("targetUser").setText("" + destUserId));
        request.addContent((Content)new Element("targetGroup").setText("" + destGroupId));
        return GNMetadataAdminExtension.gnCall(connection, gnServiceUrl, request, TRANSFER_OWNSERSHIP);
    }

    public static String editUser(HTTPUtils connection, String gnServiceURL, User toAdd, Collection<Integer> groups) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Adding user to a group..");
        }
        Element request = GNMetadataAdminExtension.buildUpdateUserRequest(toAdd.getId(), toAdd.getUsername(), toAdd.getPassword(), toAdd.getProfile(), groups);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, request, CREATE_USER_METHOD);
    }

    public static String getUserGroupd(HTTPUtils connection, String gnServiceURL, Integer userId) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting user groups..");
        }
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, new Element("request").addContent((Content)new Element("id").setText("" + userId)), GET_GROUPS_BY_USER);
    }

    public static String getUsers(HTTPUtils connection, String gnServiceURL) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Requesting users..");
        }
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, new Element("request"), USER_LIST_METHOD);
    }

    public static String createUser(HTTPUtils connection, String gnServiceURL, String name, String password, User.Profile profile, Collection<Integer> groups) throws GNServerException, GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Requesting users..");
        }
        Element userRequest = GNMetadataAdminExtension.buildCreateUserRequest(name, password, profile, groups);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, userRequest, CREATE_USER_METHOD);
    }

    public static String createGroup(HTTPUtils connection, String gnServiceURL, String groupName, String groupDescription, String groupMail) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Creating group [Name : %s, Description : %s, Mail : %s ", groupName, groupDescription, groupMail));
        }
        Element adminRequest = GNMetadataAdminExtension.buildCreateGroupRequest(groupName, groupDescription, groupMail);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, adminRequest, CREATE_GROUP_METHOD);
    }

    public static String getGroups(HTTPUtils connection, String gnServiceURL) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Requesting groups..");
        }
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, new Element("request"), GROUP_LIST_METHOD);
    }

    private static String gnCall(HTTPUtils connection, String baseURL, Element gnRequest, String toInvokeMethod) throws GNServerException {
        String serviceURL = String.valueOf(baseURL) + toInvokeMethod;
        String result = GNMetadataAdminExtension.gnPut(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error setting metadata privileges in GeoNetwork");
        }
        return result;
    }

    private static Element buildCreateGroupRequest(String groupName, String groupDescription, String groupMail) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("name").setText(groupName));
        request.addContent((Content)new Element("description").setText(groupDescription));
        request.addContent((Content)new Element("email").setText(groupMail));
        return request;
    }

    private static Element buildCreateUserRequest(String name, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("operation").setText("newuser"));
        request.addContent((Content)new Element("username").setText(name));
        request.addContent((Content)new Element("password").setText(password));
        request.addContent((Content)new Element("profile").setText(profile.name()));
        if (groups != null) {
            for (Integer groupId : groups) {
                request.addContent((Content)new Element("groups").setText("" + groupId));
            }
        }
        return request;
    }

    private static Element buildUpdateUserRequest(Integer id, String name, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("operation").setText("editinfo"));
        request.addContent((Content)new Element("id").setText("" + id));
        request.addContent((Content)new Element("username").setText(name));
        request.addContent((Content)new Element("password").setText(password));
        request.addContent((Content)new Element("profile").setText(profile.name()));
        if (groups != null) {
            for (Integer groupId : groups) {
                request.addContent((Content)new Element("groups").setText("" + groupId));
            }
        }
        return request;
    }

    private static Element buildSelectMetadata(List<Long> toSelectIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"building selection request");
        }
        Element request = new Element("request");
        if (toSelectIds != null) {
            for (Long id : toSelectIds) {
                request.addContent((Content)new Element("id").setText(id.toString()));
            }
            request.addContent((Content)new Element("selected").setText("add"));
        } else {
            request.addContent((Content)new Element("selected").setText("add-all"));
        }
        return request;
    }

    private static Element buildClearMetaSelection() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"building selection request");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("selected").setText("remove-all"));
        return request;
    }

    private static String gnPut(HTTPUtils connection, String serviceURL, Element gnRequest) {
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }
}

