/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.gcube.spatial.data.geonetwork.utils.RuntimeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@XStreamAlias(value="EnvironmentConfiguration")
public class EnvironmentConfiguration
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentConfiguration.class);
    private static EnvironmentConfiguration current = null;
    private static long lastUpdate = 0L;
    private static TransformerFactory tf = TransformerFactory.newInstance();
    private static Transformer transformer;
    private static XStream xstream;
    private static Properties props;
    private String wmsProtocolDeclaration;
    private String wfsProtocolDeclaration;
    private String wcsProtocolDeclaration;
    private String httpProtocolDeclaration;
    private String defaultCRS;
    private String projectName;
    private String projectCitation;
    private String distributorIndividualName;
    private String distributorOrganisationName;
    private String distributorEMail;
    private String distributorSite;
    private String providerIndividualName;
    private String providerOrganisationName;
    private String providerEMail;
    private String providerSite;
    private String license;
    private HashMap<String, Thesaurus> thesauri = new HashMap();

    static {
        xstream = new XStream();
        try {
            transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
        }
        catch (Exception e) {
            logger.error("Unable to initialize transformer ", (Throwable)e);
        }
        try {
            props = new RuntimeParameters().getProps();
        }
        catch (IOException e) {
            logger.error("Unable to read properties file ", (Throwable)e);
        }
        xstream.processAnnotations(EnvironmentConfiguration.class);
        xstream.processAnnotations(Thesaurus.class);
    }

    public static synchronized EnvironmentConfiguration getConfiguration() throws Exception {
        if (System.currentTimeMillis() - lastUpdate > Long.parseLong(props.getProperty("metadataConfigurationTtl"))) {
            current = EnvironmentConfiguration.getFromIS();
        }
        return current;
    }

    private static EnvironmentConfiguration getFromIS() throws Exception {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq '" + props.getProperty("genericResourceSecondaryType") + "'").addCondition("$resource/Profile/Name/text() eq '" + props.getProperty("genericResourceName") + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        for (GenericResource resource : client.submit((Query)query)) {
            try {
                EnvironmentConfiguration config = (EnvironmentConfiguration)xstream.fromXML(resource.profile().bodyAsString());
                return config;
            }
            catch (Exception e) {
                logger.warn("Unable to parse resource [ID :" + resource.id() + "]", (Throwable)e);
            }
        }
        throw new Exception("No Configuration Found");
    }

    private static GenericResource publishResource(EnvironmentConfiguration config) throws SAXException, IOException, ParserConfigurationException {
        Element toAppend = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(config.toXML().getBytes())).getDocumentElement();
        GenericResource toPublish = new GenericResource();
        Document document = toPublish.newProfile().description("Common configuration for ISO Metadata publishing").name(props.getProperty("genericResourceName")).type(props.getProperty("genericResourceSecondaryType")).newBody().getOwnerDocument();
        toPublish.profile().body().appendChild(document.importNode(toAppend, true));
        RegistryPublisher rp = RegistryPublisherFactory.create();
        toPublish = (GenericResource)rp.create((Resource)toPublish);
        return toPublish;
    }

    public String getWmsProtocolDeclaration() {
        return this.wmsProtocolDeclaration;
    }

    public void setWmsProtocolDeclaration(String wmsProtocolDeclaration) {
        this.wmsProtocolDeclaration = wmsProtocolDeclaration;
    }

    public String getWfsProtocolDeclaration() {
        return this.wfsProtocolDeclaration;
    }

    public void setWfsProtocolDeclaration(String wfsProtocolDeclaration) {
        this.wfsProtocolDeclaration = wfsProtocolDeclaration;
    }

    public String getWcsProtocolDeclaration() {
        return this.wcsProtocolDeclaration;
    }

    public void setWcsProtocolDeclaration(String wcsProtocolDeclaration) {
        this.wcsProtocolDeclaration = wcsProtocolDeclaration;
    }

    public String getHttpProtocolDeclaration() {
        return this.httpProtocolDeclaration;
    }

    public void setHttpProtocolDeclaration(String httpProtocolDeclaration) {
        this.httpProtocolDeclaration = httpProtocolDeclaration;
    }

    public String getDefaultCRS() {
        return this.defaultCRS;
    }

    public void setDefaultCRS(String defaultCRS) {
        this.defaultCRS = defaultCRS;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCitation() {
        return this.projectCitation;
    }

    public void setProjectCitation(String projectCitation) {
        this.projectCitation = projectCitation;
    }

    public String getDistributorIndividualName() {
        return this.distributorIndividualName;
    }

    public void setDistributorIndividualName(String distributorIndividualName) {
        this.distributorIndividualName = distributorIndividualName;
    }

    public String getDistributorOrganisationName() {
        return this.distributorOrganisationName;
    }

    public void setDistributorOrganisationName(String distributorOrganisationName) {
        this.distributorOrganisationName = distributorOrganisationName;
    }

    public String getDistributorEMail() {
        return this.distributorEMail;
    }

    public void setDistributorEMail(String distributorEMail) {
        this.distributorEMail = distributorEMail;
    }

    public String getDistributorSite() {
        return this.distributorSite;
    }

    public void setDistributorSite(String distributorSite) {
        this.distributorSite = distributorSite;
    }

    public String getProviderIndividualName() {
        return this.providerIndividualName;
    }

    public void setProviderIndividualName(String providerIndividualName) {
        this.providerIndividualName = providerIndividualName;
    }

    public String getProviderOrganisationName() {
        return this.providerOrganisationName;
    }

    public void setProviderOrganisationName(String providerOrganisationName) {
        this.providerOrganisationName = providerOrganisationName;
    }

    public String getProviderEMail() {
        return this.providerEMail;
    }

    public void setProviderEMail(String providerEMail) {
        this.providerEMail = providerEMail;
    }

    public String getProviderSite() {
        return this.providerSite;
    }

    public void setProviderSite(String providerSite) {
        this.providerSite = providerSite;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public HashMap<String, Thesaurus> getThesauri() {
        return this.thesauri;
    }

    public void setThesauri(HashMap<String, Thesaurus> thesauri) {
        this.thesauri = thesauri;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EnvironmentConfiguration [wmsProtocolDeclaration=");
        builder.append(this.wmsProtocolDeclaration);
        builder.append(", wfsProtocolDeclaration=");
        builder.append(this.wfsProtocolDeclaration);
        builder.append(", wcsProtocolDeclaration=");
        builder.append(this.wcsProtocolDeclaration);
        builder.append(", httpProtocolDeclaration=");
        builder.append(this.httpProtocolDeclaration);
        builder.append(", defaultCRS=");
        builder.append(this.defaultCRS);
        builder.append(", projectName=");
        builder.append(this.projectName);
        builder.append(", projectCitation=");
        builder.append(this.projectCitation);
        builder.append(", distributorIndividualName=");
        builder.append(this.distributorIndividualName);
        builder.append(", distributorOrganisationName=");
        builder.append(this.distributorOrganisationName);
        builder.append(", distributorEMail=");
        builder.append(this.distributorEMail);
        builder.append(", distributorSite=");
        builder.append(this.distributorSite);
        builder.append(", providerIndividualName=");
        builder.append(this.providerIndividualName);
        builder.append(", providerOrganisationName=");
        builder.append(this.providerOrganisationName);
        builder.append(", providerEMail=");
        builder.append(this.providerEMail);
        builder.append(", providerSite=");
        builder.append(this.providerSite);
        builder.append(", license=");
        builder.append(this.license);
        builder.append(", thesauri=");
        builder.append(this.thesauri);
        builder.append("]");
        return builder.toString();
    }

    public String toXML() {
        return xstream.toXML((Object)this);
    }

    public GenericResource publish() throws SAXException, IOException, ParserConfigurationException {
        return EnvironmentConfiguration.publishResource(this);
    }
}

