/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.extension;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.gcube.spatial.data.geonetwork.model.User;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GNMetadataAdminExtension {
    private static final Logger LOGGER = Logger.getLogger(GNMetadataAdminExtension.class);
    private static final XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
    private static final String CREATE_GROUP_METHOD = "/srv/en/group.update";
    private static final String GROUP_LIST_METHOD = "/srv/en/xml.group.list";
    private static final String USER_LIST_METHOD = "/srv/en/xml.user.list";
    private static final String CREATE_USER_METHOD = "/srv/en/user.update";
    private static final String GET_GROUPS_BY_USER = "/srv/en/xml.usergroups.list";

    public static String editUser(HTTPUtils connection, String gnServiceURL, User toAdd, Collection<Integer> groups) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Adding user to a group..");
        }
        Element request = GNMetadataAdminExtension.buildUpdateUserRequest(toAdd.getId(), toAdd.getUsername(), toAdd.getPassword(), toAdd.getProfile(), groups);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, request, CREATE_USER_METHOD);
    }

    public static String getUserGroupd(HTTPUtils connection, String gnServiceURL, Integer userId) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Getting user groups..");
        }
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, new Element("request").addContent((Content)new Element("id").setText("" + userId)), GET_GROUPS_BY_USER);
    }

    public static String getUsers(HTTPUtils connection, String gnServiceURL) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Requesting users..");
        }
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, new Element("request"), USER_LIST_METHOD);
    }

    public static String createUser(HTTPUtils connection, String gnServiceURL, String name, String password, User.Profile profile, Collection<Integer> groups) throws GNServerException, GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Requesting users..");
        }
        Element userRequest = GNMetadataAdminExtension.buildCreateUserRequest(name, password, profile, groups);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, userRequest, CREATE_USER_METHOD);
    }

    public static String createGroup(HTTPUtils connection, String gnServiceURL, String groupName, String groupDescription, String groupMail) throws GNLibException, GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Creating group [Name : %s, Description : %s, Mail : %s ", groupName, groupDescription, groupMail));
        }
        Element adminRequest = GNMetadataAdminExtension.buildCreateGroupRequest(groupName, groupDescription, groupMail);
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, adminRequest, CREATE_GROUP_METHOD);
    }

    public static String getGroups(HTTPUtils connection, String gnServiceURL) throws GNServerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Requesting groups..");
        }
        return GNMetadataAdminExtension.gnCall(connection, gnServiceURL, new Element("request"), GROUP_LIST_METHOD);
    }

    private static String gnCall(HTTPUtils connection, String baseURL, Element gnRequest, String toInvokeMethod) throws GNServerException {
        String serviceURL = String.valueOf(baseURL) + toInvokeMethod;
        String result = GNMetadataAdminExtension.gnPut(connection, serviceURL, gnRequest);
        if (connection.getLastHttpStatus() != 200) {
            throw new GNServerException("Error setting metadata privileges in GeoNetwork");
        }
        return result;
    }

    private static Element buildCreateGroupRequest(String groupName, String groupDescription, String groupMail) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("name").setText(groupName));
        request.addContent((Content)new Element("description").setText(groupDescription));
        request.addContent((Content)new Element("email").setText(groupMail));
        return request;
    }

    private static Element buildCreateUserRequest(String name, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("operation").setText("newuser"));
        request.addContent((Content)new Element("username").setText(name));
        request.addContent((Content)new Element("password").setText(password));
        request.addContent((Content)new Element("profile").setText(profile.name()));
        if (groups != null) {
            for (Integer groupId : groups) {
                request.addContent((Content)new Element("groups").setText("" + groupId));
            }
        }
        return request;
    }

    private static Element buildUpdateUserRequest(Integer id, String name, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Compiling admin request document");
        }
        Element request = new Element("request");
        request.addContent((Content)new Element("operation").setText("editinfo"));
        request.addContent((Content)new Element("id").setText("" + id));
        request.addContent((Content)new Element("username").setText(name));
        request.addContent((Content)new Element("password").setText(password));
        request.addContent((Content)new Element("profile").setText(profile.name()));
        if (groups != null) {
            for (Integer groupId : groups) {
                request.addContent((Content)new Element("groups").setText("" + groupId));
            }
        }
        return request;
    }

    private static String gnPut(HTTPUtils connection, String serviceURL, Element gnRequest) {
        String s = outputter.outputString(gnRequest);
        connection.setIgnoreResponseContentOnSuccess(false);
        String res = connection.postXml(serviceURL, s);
        return res;
    }
}

