/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.extension;

import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import java.util.Collection;
import java.util.Set;
import org.gcube.spatial.data.geonetwork.extension.GNMetadataAdminExtension;
import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.utils.GroupUtils;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;

public class GNClientExtension
extends GNClient {
    private String gnServiceURL;

    public GNClientExtension(String serviceURL) {
        super(serviceURL);
        this.gnServiceURL = serviceURL;
    }

    public void createGroup(String name, String description, String mail) throws GNLibException, GNServerException {
        GNMetadataAdminExtension.createGroup(this.getConnection(), this.gnServiceURL, name, description, mail);
    }

    public Set<Group> getGroups() throws GNLibException, GNServerException {
        return GroupUtils.parseGroupXMLResponse(GNMetadataAdminExtension.getGroups(this.getConnection(), this.gnServiceURL));
    }

    public Set<User> getUsers() throws GNLibException, GNServerException {
        return UserUtils.parseUserXMLResponse(GNMetadataAdminExtension.getUsers(this.getConnection(), this.gnServiceURL));
    }

    public void createUser(String name, String password, User.Profile profile, Collection<Integer> groups) throws GNServerException, GNLibException {
        GNMetadataAdminExtension.createUser(this.getConnection(), this.gnServiceURL, name, password, profile, groups);
    }

    public void editUser(User toAdd, Collection<Integer> groups) throws GNServerException, GNLibException {
        Set<Integer> alreadyAddedGroups = this.getGroupsByUser(toAdd.getId());
        alreadyAddedGroups.addAll(groups);
        GNMetadataAdminExtension.editUser(this.getConnection(), this.gnServiceURL, toAdd, alreadyAddedGroups);
    }

    public Set<Integer> getGroupsByUser(Integer userId) throws GNLibException, GNServerException {
        return UserUtils.parseGroupsByUserResponse(GNMetadataAdminExtension.getUserGroupd(this.getConnection(), this.gnServiceURL, userId));
    }
}

