/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.gcube.spatial.data.geonetwork.configuration.XMLAdapter;
import org.gcube.spatial.data.geonetwork.extension.GNClientExtension;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.model.faults.AuthorizationException;
import org.gcube.spatial.data.geonetwork.model.faults.GeoNetworkException;
import org.gcube.spatial.data.geonetwork.model.faults.InvalidInsertConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.model.faults.MissingServiceEndpointException;
import org.gcube.spatial.data.geonetwork.utils.GroupUtils;
import org.gcube.spatial.data.geonetwork.utils.RuntimeParameters;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.geotoolkit.xml.XML;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.opengis.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoNetwork
implements GeoNetworkAdministration {
    private static final Logger log = LoggerFactory.getLogger(GeoNetwork.class);
    private static XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
    private Configuration config;
    private GNClientExtension theClient = null;
    private LoginLevel currentLoggedLevel = null;
    private List<XMLAdapter> registeredXMLAdapters = new ArrayList<XMLAdapter>();

    public static GeoNetworkAdministration get() throws Exception {
        return new GeoNetwork(ConfigurationManager.get());
    }

    public static GeoNetworkAdministration get(Configuration config) throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        return new GeoNetwork(config);
    }

    private GeoNetwork(Configuration config) throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        this.config = config;
        log.debug("Checking scope configuration..");
        try {
            ScopeConfiguration scopeConfig = config.getScopeConfiguration();
        }
        catch (MissingConfigurationException e) {
            log.trace("Configuration not found for current scope " + ScopeUtils.getCurrentScope() + "acquiring one..");
            this.acquireConfiguration();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void login(LoginLevel lvl) throws AuthorizationException, MissingServiceEndpointException, MissingConfigurationException {
        GNClientExtension client = this.getClient();
        String user = null;
        String password = null;
        switch (lvl) {
            case ADMIN: {
                user = this.config.getAdminAccount().getUser();
                password = this.config.getAdminAccount().getPassword();
                break;
            }
            case CKAN: {
                ScopeConfiguration scopeConfiguration = this.config.getScopeConfiguration();
                Account account = scopeConfiguration.getAccounts().get((Object)Account.Type.CKAN);
                user = account.getUser();
                password = account.getPassword();
                break;
            }
            default: {
                ScopeConfiguration scopeConfiguration = this.config.getScopeConfiguration();
                Account account = scopeConfiguration.getAccounts().get((Object)Account.Type.SCOPE);
                user = account.getUser();
                password = account.getPassword();
            }
        }
        client.login(user, password);
        this.currentLoggedLevel = lvl;
    }

    @Override
    public void logout() {
        this.theClient = null;
        this.currentLoggedLevel = null;
    }

    @Override
    public GNSearchResponse query(GNSearchRequest request) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().search(request);
    }

    @Override
    public GNSearchResponse query(File fileRequest) throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().search(fileRequest);
    }

    @Override
    public Metadata getById(long id) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        String xml = out.outputString(this.getClient().get(id));
        return (Metadata)XML.unmarshal((String)xml);
    }

    @Override
    public Metadata getById(String UUID) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return (Metadata)XML.unmarshal((String)this.getByIdAsRawString(UUID));
    }

    @Override
    public String getByIdAsRawString(String UUID) throws GNLibException, GNServerException, JAXBException, MissingServiceEndpointException {
        return out.outputString(this.getClient().get(UUID));
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.setPrivileges(metadataId, cfg);
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        this.checkPublishingConfiguration(configuration);
        GNClientExtension client = this.getClient();
        return client.insertMetadata(configuration, metadataFile);
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException, MissingConfigurationException, InvalidInsertConfigurationException, AuthorizationException {
        return this.insertMetadata(configuration, GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public long insertMetadata(File requestFile) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        return client.insertRequest(requestFile);
    }

    @Override
    public long insertMetadata(Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException {
        return this.insertMetadata(GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.updateMetadata(id, metadataFile);
    }

    @Override
    public void updateMetadata(long id, Metadata meta) throws GNLibException, GNServerException, IOException, JAXBException, MissingServiceEndpointException {
        this.updateMetadata(id, GeoNetwork.meta2File(meta, this.registeredXMLAdapters));
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.deleteMetadata(id);
    }

    @Override
    public GNInsertConfiguration getCurrentUserConfiguration(String category, String styleSheet) throws AuthorizationException, GeoNetworkException {
        if (this.currentLoggedLevel == null) {
            throw new AuthorizationException("Client is not authenticated, please use Login before publishing");
        }
        ScopeConfiguration scopeConfig = this.config.getScopeConfiguration();
        Integer configuredGroup = null;
        switch (this.currentLoggedLevel) {
            case CKAN: {
                throw new AuthorizationException("Current logged level " + (Object)((Object)this.currentLoggedLevel) + "is read-only");
            }
            case ADMIN: {
                throw new GeoNetworkException("Current logged level is Admin, unable to determine publihing configuration");
            }
            case DEFAULT: {
                configuredGroup = scopeConfig.getDefaultGroup();
                break;
            }
            case PRIVATE: {
                configuredGroup = scopeConfig.getPrivateGroup();
                break;
            }
            case SCOPE: {
                configuredGroup = scopeConfig.getPublicGroup();
            }
        }
        return new GNInsertConfiguration("" + configuredGroup, category, styleSheet, Boolean.valueOf(true));
    }

    @Override
    public void createGroup(String name, String description, String mail) throws GNLibException, GNServerException, MissingServiceEndpointException {
        GNClientExtension client = this.getClient();
        client.createGroup(name, description, mail);
    }

    @Override
    public Set<Group> getGroups() throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().getGroups();
    }

    private ScopeConfiguration acquireConfiguration() throws MissingServiceEndpointException, GNLibException, GNServerException, AuthorizationException, MissingConfigurationException {
        ScopeConfiguration acquired = null;
        try {
            acquired = this.config.acquireConfiguration();
        }
        catch (MissingConfigurationException e) {
            acquired = this.createCurrentScopeConfiguration();
            this.config.createScopeConfiguration(acquired);
        }
        this.updateRightsOnAcquiredConfiguration(acquired);
        return acquired;
    }

    @Override
    public Set<User> getUsers() throws GNLibException, GNServerException, MissingServiceEndpointException {
        return this.getClient().getUsers();
    }

    @Override
    public void createUsers(String username, String password, User.Profile profile, Collection<Integer> groups) throws GNLibException, GNServerException, MissingServiceEndpointException {
        this.getClient().createUser(username, password, profile, groups);
    }

    private ScopeConfiguration createCurrentScopeConfiguration() throws GNLibException, GNServerException, MissingServiceEndpointException {
        try {
            String currentScopeName = ScopeUtils.getCurrentScopeName();
            log.debug("Generating configuration for scope " + currentScopeName);
            this.login(LoginLevel.ADMIN);
            RuntimeParameters props = new RuntimeParameters();
            Integer nameLength = Integer.parseInt(props.getProps().getProperty("GNUniqueNameLength"));
            Integer passwordLength = Integer.parseInt(props.getProps().getProperty("GNPasswordLength"));
            Set<Group> existingGroups = this.getGroups();
            Set<User> existingUsers = this.getUsers();
            Group privateGroup = GroupUtils.generateRandomGroup(existingGroups, nameLength);
            log.debug("Creating private group ..");
            this.createGroup(privateGroup.getName(), "Private group for scope " + currentScopeName, "none");
            existingGroups.add(privateGroup);
            Group publicGroup = GroupUtils.generateRandomGroup(existingGroups, nameLength);
            log.debug("Creating public group..");
            this.createGroup(publicGroup.getName(), "Public group for scope " + currentScopeName, "none");
            existingGroups = this.getGroups();
            privateGroup = GroupUtils.getByName(existingGroups, privateGroup.getName());
            log.debug("Resulting private group : " + privateGroup);
            publicGroup = GroupUtils.getByName(existingGroups, publicGroup.getName());
            log.debug("Resulting publicGroup : " + publicGroup);
            User ckanUser = UserUtils.generateRandomUser(existingUsers, nameLength, passwordLength);
            log.debug("Creating ckan user..");
            HashSet<Integer> scopeAccessibleGroups = new HashSet<Integer>();
            scopeAccessibleGroups.add(publicGroup.getId());
            scopeAccessibleGroups.add(privateGroup.getId());
            this.createUsers(ckanUser.getUsername(), ckanUser.getPassword(), User.Profile.RegisteredUser, scopeAccessibleGroups);
            existingUsers.add(ckanUser);
            User scopeUser = UserUtils.generateRandomUser(existingUsers, nameLength, passwordLength);
            log.debug("Creating scope user..");
            this.createUsers(scopeUser.getUsername(), scopeUser.getPassword(), User.Profile.Editor, scopeAccessibleGroups);
            this.logout();
            HashMap<Account.Type, Account> accounts = new HashMap<Account.Type, Account>();
            accounts.put(Account.Type.CKAN, new Account(ckanUser.getUsername(), ckanUser.getPassword(), Account.Type.CKAN));
            accounts.put(Account.Type.SCOPE, new Account(scopeUser.getUsername(), scopeUser.getPassword(), Account.Type.SCOPE));
            return new ScopeConfiguration(currentScopeName, publicGroup.getId(), privateGroup.getId(), accounts, publicGroup.getId());
        }
        catch (Exception e) {
            throw new GNLibException("Unable to create scope configuration", (Throwable)e);
        }
    }

    private void updateRightsOnAcquiredConfiguration(ScopeConfiguration scopeConfig) throws MissingServiceEndpointException, AuthorizationException, GNLibException, GNServerException, MissingConfigurationException {
        Set<ScopeConfiguration> parentConfigurations = this.config.getParentScopesConfiguration();
        this.login(LoginLevel.ADMIN);
        GNClientExtension client = this.getClient();
        HashSet<Integer> parentVisibleGroups = new HashSet<Integer>();
        for (ScopeConfiguration conf : parentConfigurations) {
            parentVisibleGroups.add(conf.getPrivateGroup());
            parentVisibleGroups.add(conf.getPublicGroup());
        }
        Set<User> existingUsers = this.getUsers();
        User scopeUser = UserUtils.getByName(existingUsers, scopeConfig.getAccounts().get((Object)Account.Type.SCOPE).getUser());
        log.debug("Updating scope user..");
        client.editUser(scopeUser, parentVisibleGroups);
        for (ScopeConfiguration conf : parentConfigurations) {
            log.debug("Updating parent user for scope " + conf.getAssignedScope());
            User toUpdateUser = UserUtils.getByName(existingUsers, conf.getAccounts().get((Object)Account.Type.SCOPE).getUser());
            client.editUser(toUpdateUser, Collections.singleton(scopeConfig.getPublicGroup()));
        }
        this.logout();
    }

    @Override
    public void registerXMLAdapter(XMLAdapter adapter) {
        this.registeredXMLAdapters.add(adapter);
    }

    private synchronized GNClientExtension getClient() throws MissingServiceEndpointException {
        if (this.theClient == null) {
            this.theClient = new GNClientExtension(this.config.getGeoNetworkEndpoint());
        }
        return this.theClient;
    }

    private void checkPublishingConfiguration(GNInsertConfiguration configuration) throws AuthorizationException, InvalidInsertConfigurationException, MissingConfigurationException, MissingServiceEndpointException {
        if (this.currentLoggedLevel == null) {
            throw new AuthorizationException("Client is not authenticated, please use Login before publishing");
        }
        if (!configuration.getValidate().booleanValue()) {
            throw new InvalidInsertConfigurationException("Validate option is mandatory");
        }
        Integer targetGroup = Integer.parseInt(configuration.getGroup());
        Integer configuredGroup = null;
        ScopeConfiguration scopeConfig = this.config.getScopeConfiguration();
        switch (this.currentLoggedLevel) {
            case CKAN: {
                throw new AuthorizationException("Current logged level " + (Object)((Object)this.currentLoggedLevel) + "is read-only");
            }
            case ADMIN: {
                break;
            }
            case DEFAULT: {
                configuredGroup = scopeConfig.getDefaultGroup();
                break;
            }
            case PRIVATE: {
                configuredGroup = scopeConfig.getPrivateGroup();
                break;
            }
            case SCOPE: {
                configuredGroup = scopeConfig.getPublicGroup();
            }
        }
        if (configuredGroup != null && !targetGroup.equals(configuredGroup)) {
            throw new InvalidInsertConfigurationException(String.format("Invalid logged level %s and specified group %d, expected %d", new Object[]{this.currentLoggedLevel, targetGroup, configuredGroup}));
        }
    }

    private static File meta2File(Metadata meta, List<XMLAdapter> adapters) throws IOException, JAXBException {
        File temp = File.createTempFile("meta", ".xml");
        FileWriter writer = new FileWriter(temp);
        String marshalled = XML.marshal((Object)meta);
        for (XMLAdapter adapter : adapters) {
            marshalled = adapter.adaptXML(marshalled);
        }
        writer.write(marshalled);
        writer.close();
        return temp;
    }
}

