/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.iso;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.gcube.spatial.data.geonetwork.iso.EnvironmentConfiguration;
import org.gcube.spatial.data.geonetwork.iso.GcubeISOMetadata;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultAddress;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultCitationDate;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.metadata.iso.constraint.DefaultLegalConstraints;
import org.geotoolkit.metadata.iso.distribution.DefaultDigitalTransferOptions;
import org.geotoolkit.metadata.iso.distribution.DefaultDistribution;
import org.geotoolkit.metadata.iso.distribution.DefaultFormat;
import org.geotoolkit.metadata.iso.identification.DefaultBrowseGraphic;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.geotoolkit.metadata.iso.identification.DefaultKeywords;
import org.geotoolkit.metadata.iso.identification.DefaultResolution;
import org.geotoolkit.metadata.iso.maintenance.DefaultMaintenanceInformation;
import org.geotoolkit.metadata.iso.spatial.DefaultGeometricObjects;
import org.geotoolkit.metadata.iso.spatial.DefaultVectorSpatialRepresentation;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.util.InternationalString;

public class ISOMetadataFactory {
    public static Metadata generateMeta(GcubeISOMetadata params) throws URISyntaxException {
        DefaultResponsibleParty author = new DefaultResponsibleParty();
        author.setIndividualName(params.getUser());
        author.setOrganisationName((InternationalString)new DefaultInternationalString(params.getConfig().getProjectName()));
        author.setRole(Role.AUTHOR);
        DefaultResponsibleParty distributor = new DefaultResponsibleParty();
        distributor.setIndividualName(params.getConfig().getDistributorIndividualName());
        distributor.setOrganisationName((InternationalString)new DefaultInternationalString(params.getConfig().getProjectName()));
        distributor.setRole(Role.DISTRIBUTOR);
        DefaultContact distributorContact = new DefaultContact();
        DefaultAddress distributorAddress = new DefaultAddress();
        distributorAddress.getElectronicMailAddresses().add(params.getConfig().getDistributorEMail());
        distributorContact.setAddress((Address)distributorAddress);
        DefaultOnlineResource distributorOnline = new DefaultOnlineResource(new URI(params.getConfig().getDistributorSite()));
        distributorOnline.setProtocol(params.getConfig().getHttpProtocolDeclaration());
        distributorContact.setOnlineResource((OnlineResource)distributorOnline);
        distributor.setContactInfo((Contact)distributorContact);
        DefaultResponsibleParty provider = new DefaultResponsibleParty();
        provider.setIndividualName(params.getConfig().getProviderIndividualName());
        provider.setOrganisationName((InternationalString)new DefaultInternationalString(params.getConfig().getProjectName()));
        provider.setRole(Role.RESOURCE_PROVIDER);
        DefaultContact providerContact = new DefaultContact();
        DefaultAddress providerAddress = new DefaultAddress();
        providerAddress.getElectronicMailAddresses().add(params.getConfig().getProviderEMail());
        providerContact.setAddress((Address)providerAddress);
        DefaultOnlineResource providerOnline = new DefaultOnlineResource(new URI(params.getConfig().getProviderSite()));
        providerOnline.setProtocol(params.getConfig().getHttpProtocolDeclaration());
        providerContact.setOnlineResource((OnlineResource)providerOnline);
        provider.setContactInfo((Contact)providerContact);
        DefaultDataIdentification ident = new DefaultDataIdentification();
        ident.getLanguages().add(Locale.ENGLISH);
        DefaultCitation citation = new DefaultCitation();
        citation.setTitle((InternationalString)new DefaultInternationalString(params.getTitle()));
        citation.getDates().add(new DefaultCitationDate(params.getCreationDate(), DateType.CREATION));
        citation.getPresentationForms().add(params.getPresentationForm());
        ident.setCitation((Citation)citation);
        ident.setAbstract((InternationalString)new DefaultInternationalString(params.getAbstractField()));
        ident.setPurpose((InternationalString)new DefaultInternationalString(params.getPurpose()));
        ident.getCredits().addAll(params.getCredits());
        ident.getResourceMaintenances().add(new DefaultMaintenanceInformation(MaintenanceFrequency.AS_NEEDED));
        for (Map.Entry<Thesaurus, HashSet<String>> entry : params.getDescriptiveKeywords().entrySet()) {
            DefaultKeywords keywords = new DefaultKeywords();
            for (String key : entry.getValue()) {
                keywords.getKeywords().add(new DefaultInternationalString(key));
            }
            keywords.setType(entry.getKey().getType());
            DefaultCitation thesaurus = new DefaultCitation();
            thesaurus.setTitle((InternationalString)new DefaultInternationalString(entry.getKey().getTitle()));
            thesaurus.getDates().add(new DefaultCitationDate(entry.getKey().getCitationDate(), DateType.CREATION));
            if (entry.getKey().isAuthored()) {
                thesaurus.setOtherCitationDetails((InternationalString)new DefaultInternationalString(entry.getKey().getCitationDescription()));
                DefaultResponsibleParty thesaurusParty = new DefaultResponsibleParty();
                thesaurusParty.setIndividualName(entry.getKey().getTitle());
                thesaurusParty.setOrganisationName((InternationalString)new DefaultInternationalString(entry.getKey().getCitationOrganization()));
                thesaurusParty.setRole(Role.POINT_OF_CONTACT);
                DefaultContact thesaurusContact = new DefaultContact();
                thesaurusContact.setOnlineResource((OnlineResource)new DefaultOnlineResource(new URI(entry.getKey().getCitationUri())));
                thesaurusParty.setContactInfo((Contact)thesaurusContact);
                thesaurus.getCitedResponsibleParties().add(thesaurusParty);
            }
            keywords.setThesaurusName((Citation)thesaurus);
            ident.getDescriptiveKeywords().add(keywords);
        }
        ident.getTopicCategories().addAll(params.getTopicCategories());
        ident.getExtents().add(params.getExtent());
        DefaultGeometricObjects geoObjs = new DefaultGeometricObjects();
        geoObjs.setGeometricObjectType(params.getGeometricObjectType());
        geoObjs.setGeometricObjectCount(Integer.valueOf(params.getGeometryCount()));
        DefaultVectorSpatialRepresentation spatial = new DefaultVectorSpatialRepresentation();
        spatial.setTopologyLevel(params.getTopologyLevel());
        spatial.getGeometricObjects().add(geoObjs);
        DefaultResolution layerResolution = new DefaultResolution();
        layerResolution.setDistance(Double.valueOf(params.getResolution()));
        ident.getSpatialResolutions().add(layerResolution);
        for (String uri : params.getGraphicOverviewsURI()) {
            DefaultBrowseGraphic graph = new DefaultBrowseGraphic(new URI(uri));
            ident.getGraphicOverviews().add(graph);
        }
        DefaultLegalConstraints constraints = new DefaultLegalConstraints();
        constraints.getUseLimitations().add(new DefaultInternationalString(params.getConfig().getLicense()));
        constraints.getAccessConstraints().add(Restriction.LICENSE);
        constraints.getUseConstraints().add(Restriction.LICENSE);
        DefaultMetadata meta = new DefaultMetadata((ResponsibleParty)author, new Date(System.currentTimeMillis()), (Identification)ident);
        meta.setCharacterSet(CharacterSet.UTF_8);
        meta.getContacts().add(distributor);
        meta.getContacts().add(provider);
        meta.getSpatialRepresentationInfo().add(spatial);
        meta.getMetadataConstraints().add(constraints);
        meta.setLanguage(Locale.ENGLISH);
        meta.getHierarchyLevels().add(ScopeCode.DATASET);
        meta.setFileIdentifier(UUID.randomUUID().toString());
        return meta;
    }

    public static DefaultDistribution getDistributionByLayer(String layerName, String geoserverUrl, String style, String bbox, EnvironmentConfiguration config) throws URISyntaxException {
        DefaultDistribution distribution = new DefaultDistribution();
        distribution.getTransferOptions().add(ISOMetadataFactory.getTransferOptionsByLayer(layerName, geoserverUrl, style, bbox, config));
        DefaultFormat format1 = new DefaultFormat();
        format1.setName((InternationalString)new DefaultInternationalString("WMS"));
        format1.setVersion((InternationalString)new DefaultInternationalString("1.1.0"));
        DefaultFormat format2 = new DefaultFormat();
        format2.setName((InternationalString)new DefaultInternationalString("WFS"));
        format2.setVersion((InternationalString)new DefaultInternationalString("1.1.0"));
        DefaultFormat format3 = new DefaultFormat();
        format3.setName((InternationalString)new DefaultInternationalString("WCS"));
        format3.setVersion((InternationalString)new DefaultInternationalString("1.0.0"));
        distribution.setDistributionFormats(new ArrayList<DefaultFormat>(Arrays.asList(format1, format2, format3)));
        return distribution;
    }

    public static DefaultDigitalTransferOptions getTransferOptionsByLayer(String layerName, String geoserverUrl, String style, String bbox, EnvironmentConfiguration config) throws URISyntaxException {
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        transferOptions.getOnLines().add(ISOMetadataFactory.getOnline(layerName, config.getWmsProtocolDeclaration(), ISOMetadataFactory.getWmsUrl(geoserverUrl, layerName, style, bbox, config.getDefaultCRS())));
        transferOptions.getOnLines().add(ISOMetadataFactory.getOnline(layerName, config.getWfsProtocolDeclaration(), ISOMetadataFactory.getWfsUrl(geoserverUrl, layerName)));
        transferOptions.getOnLines().add(ISOMetadataFactory.getOnline(layerName, config.getWcsProtocolDeclaration(), ISOMetadataFactory.getWcsUrl(geoserverUrl, layerName, bbox)));
        return transferOptions;
    }

    public static DefaultOnlineResource getOnline(String name, String protocol, String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        DefaultOnlineResource resource = new DefaultOnlineResource(uri);
        resource.setName(name);
        resource.setProtocol(protocol);
        return resource;
    }

    private static String getWmsUrl(String geoServerUrl, String layerName, String style, String bbox, String CRS) {
        return String.valueOf(geoServerUrl) + "/wms?service=wms&version=1.1.0" + "&request=GetMap&layers=" + layerName + "&styles=" + (style == null ? "" : style) + "&bbox=" + bbox + "&width=676&height=330" + "&srs=EPSG:4326&crs=" + CRS + "&format=application/openlayers";
    }

    private static String getWfsUrl(String geoServerUrl, String layerName) {
        return String.valueOf(geoServerUrl) + "/ows?service=wfs&version=1.0.0" + "&request=GetFeature&typeName=" + layerName + "&format=json";
    }

    private static String getWcsUrl(String geoServerUrl, String layerName, String bbox) {
        return String.valueOf(geoServerUrl) + "/wcs?service=wcs&version=1.0.0" + "&request=GetCoverage&coverage=" + layerName + "&CRS=EPSG:4326" + "&bbox=" + bbox + "&width=676&height=330&format=geotiff";
    }
}

