/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.configuration;

import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.utils.RuntimeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfiguration
implements Configuration {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfiguration.class);
    private String url;
    private Map<LoginLevel, String> users = new HashMap<LoginLevel, String>();
    private Map<LoginLevel, String> pwds = new HashMap<LoginLevel, String>();
    private int group;

    public DefaultConfiguration() throws Exception {
        Properties props = new RuntimeParameters().getProps();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + props.getProperty("geonetwork.category") + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + props.getProperty("geonetwork.platform.name") + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        List accesspoints = client.submit((Query)query);
        String endpointName = props.getProperty("geonetwork.endpoint.name");
        String masterProperty = props.getProperty("geonetwork.master");
        String scopeName = ScopeProvider.instance.get().substring(ScopeProvider.instance.get().lastIndexOf(47) + 1);
        String scopeUser = String.valueOf(scopeName) + props.getProperty("geonetwork.scopeuser.password.suffix");
        String privateUser = String.valueOf(scopeName) + props.getProperty("geonetwork.privateuser.password.suffix");
        String scopeGroup = String.valueOf(scopeName) + props.getProperty("geonetwork.scopegroup.id");
        boolean found = false;
        for (ServiceEndpoint.AccessPoint point : accesspoints) {
            Map properties;
            if (!point.name().equals(endpointName) || !(properties = point.propertyMap()).containsKey(masterProperty) || !Boolean.parseBoolean(((ServiceEndpoint.Property)properties.get(masterProperty)).value())) continue;
            this.url = point.address();
            this.users.put(LoginLevel.DEFAULT, point.username());
            this.pwds.put(LoginLevel.DEFAULT, DefaultConfiguration.decrypt(point.password()));
            if (properties.containsKey(privateUser)) {
                this.users.put(LoginLevel.PRIVATE, privateUser);
                this.pwds.put(LoginLevel.PRIVATE, DefaultConfiguration.decrypt(((ServiceEndpoint.Property)properties.get(privateUser)).value()));
            }
            if (properties.containsKey(scopeUser)) {
                this.users.put(LoginLevel.SCOPE, scopeUser);
                this.pwds.put(LoginLevel.SCOPE, DefaultConfiguration.decrypt(((ServiceEndpoint.Property)properties.get(scopeUser)).value()));
            }
            if (properties.containsKey(scopeGroup)) {
                this.group = Integer.parseInt(((ServiceEndpoint.Property)properties.get(scopeGroup)).value());
            }
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("No Resource found under current scope " + ScopeProvider.instance.get());
        }
    }

    @Override
    public String getGeoNetworkEndpoint() {
        return this.url;
    }

    @Override
    public Map<LoginLevel, String> getGeoNetworkPasswords() {
        return this.pwds;
    }

    @Override
    public Map<LoginLevel, String> getGeoNetworkUsers() {
        return this.users;
    }

    @Override
    public int getScopeGroup() {
        return this.group;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultConfiguration [url=");
        builder.append(this.url);
        builder.append(", users=");
        builder.append(this.users);
        builder.append(", pwds=");
        builder.append(this.pwds);
        builder.append("]");
        return builder.toString();
    }

    private static final String decrypt(String toDecrypt) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
    }
}

